/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.model.ModelAttachment;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.EnumAttachmentType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemAttachment;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AttachmentType
extends PaintableType
implements IScope {
    public static ArrayList<AttachmentType> attachments = new ArrayList();
    public EnumAttachmentType type = EnumAttachmentType.generic;
    public boolean silencer = false;
    public boolean flashlight = false;
    public float flashlightRange = 10.0f;
    public int flashlightStrength = 12;
    public boolean disableMuzzleFlash = false;
    public float spreadMultiplier = 1.0f;
    public float recoilMultiplier = 1.0f;
    public float recoilControlMultiplier = 1.0f;
    public float recoilControlMultiplierSneaking = 1.0f;
    public float recoilControlMultiplierSprinting = 1.0f;
    public float damageMultiplier = 1.0f;
    public float meleeDamageMultiplier = 1.0f;
    public float bulletSpeedMultiplier = 1.0f;
    public float reloadTimeMultiplier = 1.0f;
    public float moveSpeedMultiplier = 1.0f;
    public EnumFireMode modeOverride = null;
    public boolean secondaryFire = false;
    public List<String> secondaryAmmo = new ArrayList<String>();
    public float secondaryDamage = 1.0f;
    public float secondarySpread = 1.0f;
    public float secondarySpeed = 5.0f;
    public int secondaryReloadTime = 1;
    public int secondaryShootDelay = 1;
    public String secondaryShootSound;
    public String secondaryReloadSound;
    public EnumFireMode secondaryFireMode = EnumFireMode.SEMIAUTO;
    public String toggleSound;
    public int secondaryNumBullets = 1;
    public int numSecAmmoItems = 1;
    public float zoomLevel = 1.0f;
    public float FOVZoomLevel = 1.0f;
    public String zoomOverlay;
    public boolean hasScopeOverlay = false;
    public boolean hasNightVision = false;
    @SideOnly(value=Side.CLIENT)
    public ModelAttachment model;
    public int maxStackSize = 1;
    public float secondaryDefaultSpread = 0.0f;
    public boolean hasVariableZoom = false;
    private float minZoom = 1.0f;
    private float maxZoom = 4.0f;
    private float zoomAugment = 1.0f;

    public AttachmentType(TypeFile file) {
        super(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        if (this.shortName != null && this.isValid) {
            attachments.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        try {
            super.read(config, file);
            String typeString = ConfigUtils.configString(config, "AttachmentType", this.type.toString());
            this.type = EnumAttachmentType.get(typeString);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelAttachment.class);
            }
            this.texture = ConfigUtils.configString(config, "Texture", this.texture);
            this.silencer = ConfigUtils.configBool(config, "Silencer", this.silencer);
            this.disableMuzzleFlash = ConfigUtils.configBool(config, new String[]{"DisableMuzzleFlash", "DisableFlash"}, this.disableMuzzleFlash);
            this.flashlight = ConfigUtils.configBool(config, "Flashlight", this.flashlight);
            this.flashlightRange = ConfigUtils.configFloat(config, "FlashlightRange", this.flashlightRange);
            this.flashlightStrength = ConfigUtils.configInt(config, "FlashlightStrength", this.flashlightStrength);
            String modeOverrideString = ConfigUtils.configString(config, "ModeOverride", null);
            if (modeOverrideString != null) {
                this.modeOverride = EnumFireMode.getFireMode(modeOverrideString);
            }
            this.secondaryFire = ConfigUtils.configBool(config, "SecondaryMode", this.secondaryFire);
            ArrayList<String[]> splits = ConfigUtils.getSplitsFromKey(config, new String[]{"SecondaryAmmo"});
            try {
                for (String[] split : splits) {
                    if (split.length == 2) {
                        this.secondaryAmmo.add(split[1]);
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "SecondaryAmmo in unknown format, skipping", split, null);
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while parsing SecondaryMode", null, ex);
            }
            this.secondaryDamage = ConfigUtils.configFloat(config, "SecondaryDamage", this.secondaryDamage);
            this.secondarySpread = ConfigUtils.configFloat(config, new String[]{"SecondarySpread", "SecondaryAccuracy"}, this.secondarySpread);
            this.secondarySpeed = ConfigUtils.configFloat(config, "SecondaryBulletSpeed", this.secondarySpeed);
            this.secondaryShootDelay = ConfigUtils.configInt(config, "SecondaryShootDelay", this.secondaryShootDelay);
            this.secondaryReloadTime = ConfigUtils.configInt(config, "SecondaryReloadTime", this.secondaryReloadTime);
            this.secondaryShootDelay = ConfigUtils.configInt(config, "SecondaryShootDelay", this.secondaryShootDelay);
            this.secondaryNumBullets = ConfigUtils.configInt(config, "SecondaryNumBullets", this.secondaryNumBullets);
            this.numSecAmmoItems = ConfigUtils.configInt(config, "LoadSecondaryIntoGun", this.numSecAmmoItems);
            String secondaryFireModeString = ConfigUtils.configString(config, "SecondaryFireMode", null);
            if (secondaryFireModeString != null) {
                this.secondaryFireMode = EnumFireMode.getFireMode(secondaryFireModeString);
            }
            this.secondaryShootSound = ConfigUtils.configGunSound(this.packName, config, "SecondaryShootSound", this.secondaryShootSound);
            this.secondaryReloadSound = ConfigUtils.configGunSound(this.packName, config, "SecondaryReloadSound", this.secondaryReloadSound);
            this.toggleSound = ConfigUtils.configGunSound(this.packName, config, "ModeSwitchSound", this.toggleSound);
            this.meleeDamageMultiplier = ConfigUtils.configFloat(config, "MeleeDamageMultiplier", this.meleeDamageMultiplier);
            this.damageMultiplier = ConfigUtils.configFloat(config, "DamageMultiplier", this.damageMultiplier);
            this.spreadMultiplier = ConfigUtils.configFloat(config, "SpreadMultiplier", this.spreadMultiplier);
            this.recoilMultiplier = ConfigUtils.configFloat(config, "RecoilMultiplier", this.recoilMultiplier);
            this.recoilControlMultiplier = ConfigUtils.configFloat(config, "RecoilControlMultiplier", this.recoilControlMultiplier);
            this.recoilControlMultiplierSneaking = ConfigUtils.configFloat(config, "RecoilControlMultiplierSneaking", this.recoilControlMultiplierSneaking);
            this.recoilControlMultiplierSprinting = ConfigUtils.configFloat(config, "RecoilControlMultiplierSprinting", this.recoilControlMultiplierSprinting);
            this.bulletSpeedMultiplier = ConfigUtils.configFloat(config, "BulletSpeedMultiplier", this.bulletSpeedMultiplier);
            this.recoilControlMultiplierSprinting = ConfigUtils.configFloat(config, "RecoilControlMultiplierSprinting", this.recoilControlMultiplierSprinting);
            this.moveSpeedMultiplier = ConfigUtils.configFloat(config, new String[]{"MovementSpeedMultiplier", "MoveSpeedModifier"}, this.moveSpeedMultiplier);
            this.minZoom = ConfigUtils.configFloat(config, "MinZoom", this.minZoom);
            this.maxZoom = ConfigUtils.configFloat(config, "MaxZoom", this.maxZoom);
            this.zoomAugment = ConfigUtils.configFloat(config, "ZoomAugment", this.zoomAugment);
            this.zoomLevel = ConfigUtils.configFloat(config, "ZoomLevel", this.zoomLevel);
            this.FOVZoomLevel = ConfigUtils.configFloat(config, "FOVZoomLevel", this.FOVZoomLevel);
            String zoomOverlayString = ConfigUtils.configString(config, "ZoomOverlay", null);
            if (zoomOverlayString == null || zoomOverlayString.isEmpty() || zoomOverlayString.equalsIgnoreCase("None")) {
                this.hasScopeOverlay = false;
            } else {
                this.hasScopeOverlay = true;
                this.zoomOverlay = zoomOverlayString;
            }
            this.hasNightVision = ConfigUtils.configBool(config, "HasNightVision", this.hasNightVision);
        }
        catch (Exception e) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error reading attachment config", null, e);
            this.isValid = false;
        }
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelAttachment.class);
    }

    public static AttachmentType getFromNBT(NBTTagCompound tags) {
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tags);
        if (stack != null && stack.func_77973_b() instanceof ItemAttachment) {
            return ((ItemAttachment)stack.func_77973_b()).type;
        }
        return null;
    }

    @Override
    public float getZoomFactor() {
        return this.zoomLevel;
    }

    @Override
    public boolean hasZoomOverlay() {
        return this.hasScopeOverlay;
    }

    @Override
    public String getZoomOverlay() {
        return this.zoomOverlay;
    }

    @Override
    public float getFOVFactor() {
        return this.FOVZoomLevel;
    }

    public static AttachmentType getAttachment(String s) {
        for (AttachmentType attachment : attachments) {
            if (!attachment.shortName.equals(s)) continue;
            return attachment;
        }
        return null;
    }

    @Override
    public float GetRecommendedScale() {
        return 100.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }

    @Override
    public float getMinZoom() {
        return this.hasVariableZoom ? this.minZoom : -1.0f;
    }

    @Override
    public float getMaxZoom() {
        return this.hasVariableZoom ? this.maxZoom : -1.0f;
    }

    @Override
    public float getZoomAugment() {
        return this.hasVariableZoom ? this.zoomAugment : -1.0f;
    }

    @Override
    public boolean hasVariableZoom() {
        return this.hasVariableZoom;
    }
}

