/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.eventhandlers;

import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.raytracing.BlockHit;
import com.flansmod.common.guns.raytracing.BulletHit;
import com.flansmod.common.guns.raytracing.DriveableHit;
import com.flansmod.common.guns.raytracing.EntityHit;
import com.flansmod.common.guns.raytracing.PlayerBulletHit;
import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.MovingObjectPosition;

@Cancelable
public class BulletHitEvent
extends Event {
    private EntityBullet bullet;
    private BulletHit hit;
    private Entity entity;
    private Block block;
    private boolean allowBlockDestruction = true;

    public BulletHitEvent(EntityBullet bullet, BulletHit hit) {
        this.bullet = bullet;
        this.hit = hit;
        if (hit instanceof DriveableHit) {
            this.entity = ((DriveableHit)hit).driveable;
        } else if (hit instanceof PlayerBulletHit) {
            this.entity = ((PlayerBulletHit)hit).hitbox.player;
        } else if (hit instanceof EntityHit) {
            this.entity = ((EntityHit)hit).entity;
        }
        if (hit instanceof BlockHit) {
            MovingObjectPosition raytraceResult = ((BlockHit)hit).raytraceResult;
            this.block = bullet.field_70170_p.func_147439_a(raytraceResult.field_72311_b, raytraceResult.field_72312_c, raytraceResult.field_72309_d);
        }
    }

    public EntityBullet getBullet() {
        return this.bullet;
    }

    public BulletHit getHit() {
        return this.hit;
    }

    public boolean hitEntity() {
        return this.entity != null;
    }

    public Entity getHitEntity() {
        return this.entity;
    }

    public Block getHitBlock() {
        return this.block;
    }

    public boolean isAllowBlockDestruction() {
        return this.allowBlockDestruction;
    }

    public void setAllowBlockDestruction(boolean allowBlockDestruction) {
        this.allowBlockDestruction = allowBlockDestruction;
    }
}

