/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables.mechas;

import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.client.gui.GuiDriveableController;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.mechas.EnumMechaSlotType;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaInventory;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.eventhandlers.DriveableDeathByHandEvent;
import com.flansmod.common.eventhandlers.GunFiredEvent;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.InventoryHelper;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.raytracing.DriveableHit;
import com.flansmod.common.network.PacketDriveableDamage;
import com.flansmod.common.network.PacketDriveableGUI;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketMechaControl;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.common.vector.Vector3i;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;

public class EntityMecha
extends EntityDriveable {
    private int ticksSinceUsed;
    public int toggleTimer = 0;
    private float moveX = 0.0f;
    private float moveZ = 0.0f;
    public RotatedAxes legAxes;
    public float prevLegsYaw = 0.0f;
    private int jumpDelay = 0;
    public MechaInventory inventory;
    public float legSwing = 0.0f;
    public float shootDelayLeft = 0.0f;
    public float shootDelayRight = 0.0f;
    public int soundDelayLeft = 0;
    public int soundDelayRight = 0;
    public Vector3i breakingBlock = null;
    public float breakingProgress = 0.0f;
    private float rocketTimer = 0.0f;
    private int diamondTimer = 0;
    public int legAnimTimer = 1;
    public int legAnimMax = 1;
    public int animState;
    public int targetLeftUpper = 0;
    public int targetLeftLower = 0;
    public int targetLeftFoot = 0;
    public int targetLeftUpperSpeed = 1;
    public int targetLeftLowerSpeed = 1;
    public int targetLeftFootSpeed = 1;
    int targetRightUpper = 0;
    int targetRightLower = 0;
    int targetRightFoot = 0;
    int targetRightUpperSpeed = 1;
    int targetRightLowerSpeed = 1;
    int targetRightFootSpeed = 1;
    public float leftLegUpperAngle = 0.0f;
    public float leftLegLowerAngle = 0.0f;
    public float leftFootAngle = 0.0f;
    public float rightLegUpperAngle = 0.0f;
    public float rightLegLowerAngle = 0.0f;
    public float rightFootAngle = 0.0f;
    public float prevLeftLegUpperAngle = 0.0f;
    public float prevLeftLegLowerAngle = 0.0f;
    public float prevLeftFootAngle = 0.0f;
    public float prevRightLegUpperAngle = 0.0f;
    public float prevRightLegLowerAngle = 0.0f;
    public float prevRightFootAngle = 0.0f;
    public float legPosition = 0.0f;
    public int stompDelay;
    public GunAnimations leftAnimations = new GunAnimations();
    public GunAnimations rightAnimations = new GunAnimations();
    boolean couldNotFindFuel;

    public EntityMecha(World world) {
        super(world);
        this.func_70105_a(2.0f, 3.0f);
        this.field_70138_W = 3.0f;
        this.legAxes = new RotatedAxes();
        this.inventory = new MechaInventory(this);
        this.isMecha = true;
    }

    public EntityMecha(World world, double x, double y, double z, MechaType type, DriveableData data, NBTTagCompound tags, EntityPlayer p) {
        super(world, type, data, p);
        this.legAxes = new RotatedAxes();
        this.func_70105_a(2.0f, 3.0f);
        this.field_70138_W = 3.0f;
        this.func_70107_b(x, y, z);
        this.initType(type, false);
        this.inventory = new MechaInventory(this, tags);
        this.isMecha = true;
    }

    public EntityMecha(World world, double x, double y, double z, EntityPlayer placer, MechaType type, DriveableData data, NBTTagCompound tags) {
        this(world, x, y, z, type, data, tags, placer);
        this.rotateYaw(placer.field_70177_z + 90.0f);
        this.legAxes.rotateGlobalYaw(placer.field_70177_z + 90.0f);
        this.prevLegsYaw = this.legAxes.getYaw();
        this.isMecha = true;
    }

    @Override
    protected void initType(DriveableType type, boolean clientSide) {
        super.initType(type, clientSide);
        this.func_70105_a(((MechaType)type).width, ((MechaType)type).height);
        this.field_70138_W = ((MechaType)type).stepHeight;
        this.isMecha = true;
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("LegsYaw", this.legAxes.getYaw());
        tag.func_74782_a("Inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        this.isMecha = true;
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.legAxes.setAngles(tag.func_74760_g("LegsYaw"), 0.0f, 0.0f);
        this.inventory.readFromNBT(tag.func_74775_l("Inventory"));
        this.isMecha = true;
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)this.inventory.writeToNBT(new NBTTagCompound()));
        this.isMecha = true;
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.legAxes.rotateGlobalYaw(this.axes.getYaw());
        this.prevLegsYaw = this.legAxes.getYaw();
        this.inventory.readFromNBT(ByteBufUtils.readTag((ByteBuf)data));
        this.isMecha = true;
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        MechaType type = this.getMechaType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].func_130002_c(entityplayer)) continue;
            return true;
        }
        return false;
    }

    public MechaType getMechaType() {
        return MechaType.getMecha(this.driveableType);
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        MechaType type = this.getMechaType();
        DriveableData data = this.getDriveableData();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            return true;
        }
        switch (key) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case 4: {
                return this.handleJump(data, type);
            }
            case 5: {
                return true;
            }
            case 6: {
                this.handleExit();
                break;
            }
            case 7: {
                this.handleInventory();
                break;
            }
            case 8: 
            case 9: {
                return true;
            }
            case 10: {
                this.handleControlModeChange();
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean handleJump(DriveableData data, MechaType type) {
        boolean canThrustCreatively;
        boolean bl = canThrustCreatively = this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
        if (this.field_70122_E && this.jumpDelay == 0 && (canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption) && this.isPartIntact(EnumDriveablePart.hips)) {
            this.jumpDelay = 20;
            this.field_70181_x += (double)type.jumpVelocity;
            if (!canThrustCreatively) {
                data.fuelInTank -= data.engine.fuelConsumption;
            }
            return true;
        }
        return false;
    }

    private void handleExit() {
        if (this.seats[0].field_70153_n != null) {
            this.seats[0].field_70153_n.func_82142_c(false);
            this.seats[0].field_70153_n.func_70078_a(null);
        }
    }

    private void handleInventory() {
        FlansMod.getPacketHandler().sendToServer(new PacketDriveableGUI(4));
        ((EntityPlayer)this.seats[0].field_70153_n).openGui((Object)FlansMod.INSTANCE, 10, this.field_70170_p, this.field_70176_ah, this.field_70162_ai, this.field_70164_aj);
    }

    private void handleControlModeChange() {
        FlansMod.proxy.changeControlMode((EntityPlayer)this.seats[0].field_70153_n);
        this.seats[0].playerLooking = new RotatedAxes(0.0f, 0.0f, 0.0f);
    }

    private boolean useItem(boolean left) {
        if (left ? this.isPartIntact(EnumDriveablePart.leftArm) : this.isPartIntact(EnumDriveablePart.rightArm)) {
            ItemStack heldStack;
            boolean creative = !(this.seats[0].field_70153_n instanceof EntityPlayer) || ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
            ItemStack itemStack = heldStack = left ? this.inventory.getStackInSlot(EnumMechaSlotType.leftTool) : this.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
            if (heldStack == null) {
                return false;
            }
            Item heldItem = heldStack.func_77973_b();
            MechaType mechaType = this.getMechaType();
            if (heldItem instanceof ItemMechaAddon) {
                MechaItemType toolType = ((ItemMechaAddon)heldItem).type;
                float reach = toolType.reach * mechaType.reach;
                Vector3f lookOrigin = new Vector3f((double)((float)mechaType.seats[0].x / 16.0f), (double)((float)mechaType.seats[0].y / 16.0f) + this.seats[0].field_70153_n.func_70042_X(), (double)((float)mechaType.seats[0].z / 16.0f));
                lookOrigin = this.axes.findLocalVectorGlobally(lookOrigin);
                Vector3f.add(lookOrigin, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), lookOrigin);
                Vector3f lookVector = this.axes.findLocalVectorGlobally(this.seats[0].looking.findLocalVectorGlobally(new Vector3f(reach, 0.0f, 0.0f)));
                this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, lookOrigin, lookVector, 20));
                Vector3f lookTarget = Vector3f.add(lookVector, lookOrigin, null);
                MovingObjectPosition hit = this.field_70170_p.func_72933_a(lookOrigin.toVec3(), lookTarget.toVec3());
                if (hit != null && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    if (this.breakingBlock == null || this.breakingBlock.x != hit.field_72311_b || this.breakingBlock.y != hit.field_72312_c || this.breakingBlock.z != hit.field_72309_d) {
                        this.breakingProgress = 0.0f;
                    }
                    this.breakingBlock = new Vector3i(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                }
            } else if (heldItem instanceof ItemGun) {
                float delay;
                ItemGun gunItem = (ItemGun)heldItem;
                GunType gunType = gunItem.type;
                if (heldStack.field_77990_d.func_74764_b("secondaryAmmo") && gunType.getSecondaryFire(heldStack)) {
                    gunType.setSecondaryFire(heldStack, false);
                }
                float f = delay = left ? this.shootDelayLeft : this.shootDelayRight;
                if (delay <= 0.0f) {
                    int bulletID;
                    ItemStack bulletStack = null;
                    for (bulletID = 0; bulletID < gunType.getNumAmmoItemsInGun(heldStack); ++bulletID) {
                        ItemStack checkingStack = gunItem.getBulletItemStack(heldStack, bulletID);
                        if (checkingStack == null || checkingStack.func_77973_b() == null || checkingStack.func_77960_j() >= checkingStack.func_77958_k()) continue;
                        bulletStack = checkingStack;
                        break;
                    }
                    if (bulletStack == null) {
                        gunItem.reload(heldStack, gunType, this.field_70170_p, this, this.driveableData, this.infiniteAmmo() || creative, false, false, false, 0.0f, false);
                    } else if (bulletStack.func_77973_b() instanceof ItemBullet) {
                        GunFiredEvent gunFiredEvent = new GunFiredEvent(this);
                        MinecraftForge.EVENT_BUS.post((Event)gunFiredEvent);
                        if (gunFiredEvent.isCanceled()) {
                            return false;
                        }
                        this.shoot(heldStack, gunType, bulletStack, creative, left);
                        if (this.field_70170_p.field_72995_K) {
                            float althammerAngle;
                            int pumpDelay = gunType.model == null ? 0 : gunType.model.pumpDelay;
                            int pumpTime = gunType.model == null ? 1 : gunType.model.pumpTime;
                            int hammerDelay = gunType.model == null ? 0 : gunType.model.hammerDelay;
                            int casingDelay = gunType.model == null ? 0 : gunType.model.casingDelay;
                            float hammerAngle = gunType.model == null ? 0.0f : gunType.model.hammerAngle;
                            float f2 = althammerAngle = gunType.model == null ? 0.0f : gunType.model.althammerAngle;
                            if (left) {
                                this.leftAnimations.doShoot(pumpDelay, pumpTime, hammerDelay, hammerAngle, althammerAngle, casingDelay);
                            } else {
                                this.rightAnimations.doShoot(pumpDelay, pumpTime, hammerDelay, hammerAngle, althammerAngle, casingDelay);
                            }
                        }
                        bulletStack.func_77964_b(bulletStack.func_77960_j() + 1);
                        gunItem.setBulletItemStack(heldStack, bulletStack, bulletID);
                    }
                }
            }
        }
        return true;
    }

    private void shoot(ItemStack stack, GunType gunType, ItemStack bulletStack, boolean creative, boolean left) {
        MechaType mechaType = this.getMechaType();
        BulletType bulletType = ((ItemBullet)bulletStack.func_77973_b()).type;
        RotatedAxes a = new RotatedAxes();
        Vector3f armVector = new Vector3f(mechaType.armLength, 0.0f, 0.0f);
        Vector3f gunVector = new Vector3f(mechaType.armLength + 1.2f * mechaType.heldItemScale, 0.5f * mechaType.heldItemScale, 0.0f);
        Vector3f armOrigin = left ? mechaType.leftArmOrigin : mechaType.rightArmOrigin;
        a.rotateGlobalYaw(this.axes.getYaw());
        armOrigin = a.findLocalVectorGlobally(armOrigin);
        a.rotateLocalPitch(-this.seats[0].looking.getPitch());
        gunVector = a.findLocalVectorGlobally(gunVector);
        armVector = a.findLocalVectorGlobally(armVector);
        Vector3f bulletOrigin = Vector3f.add(armOrigin, gunVector, null);
        bulletOrigin = Vector3f.add(new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), bulletOrigin, null);
        if (!this.field_70170_p.field_72995_K) {
            for (int k = 0; k < gunType.numBullets; ++k) {
                this.field_70170_p.func_72838_d((Entity)((ItemBullet)bulletStack.func_77973_b()).getEntity(this.field_70170_p, bulletOrigin, armVector, (EntityLivingBase)this.seats[0].field_70153_n, gunType.getSpread(stack, false, false) / 2.0f, gunType.getDamage(stack), gunType.getBulletSpeed(stack, bulletStack), bulletStack.func_77960_j(), mechaType));
            }
        }
        if (left) {
            this.shootDelayLeft = gunType.mode == EnumFireMode.SEMIAUTO ? Math.max(gunType.shootDelay, 5.0f) : gunType.shootDelay;
        } else {
            float f = this.shootDelayRight = gunType.mode == EnumFireMode.SEMIAUTO ? Math.max(gunType.shootDelay, 5.0f) : gunType.shootDelay;
        }
        if (bulletType.dropItemOnShoot != null && !creative) {
            ItemGun.dropItem(this.field_70170_p, this, bulletType.dropItemOnShoot);
        }
        if ((left ? this.soundDelayLeft : this.soundDelayRight) <= 0 && gunType.shootSound != null) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, gunType.gunSoundRange, this.field_71093_bK, gunType.shootSound, gunType.distortSound);
            if (left) {
                this.soundDelayLeft = gunType.shootSoundLength;
            } else {
                this.soundDelayRight = gunType.shootSoundLength;
            }
            if (gunType.distantShootSound != null) {
                FlansMod.getPacketHandler().sendToDonut(new PacketPlaySound(this.field_70165_t, this.field_70163_u, this.field_70161_v, gunType.distantShootSound), this.field_70165_t, this.field_70163_u, this.field_70161_v, gunType.gunSoundRange, gunType.distantSoundRange, this.field_71093_bK);
            }
        }
    }

    @Override
    protected void func_70069_a(float f) {
        this.func_70097_a(DamageSource.field_76379_h, f);
    }

    public void setLegAngles(float LLU, float pLLU, float RLU, float pRLU, float LLL, float pLLL, float RLL, float pRLL, float LLF, float pLLF, float RLF, float pRLF) {
        this.leftLegUpperAngle = LLU;
        this.leftLegLowerAngle = LLL;
        this.leftFootAngle = LLF;
        this.rightLegUpperAngle = RLU;
        this.rightLegLowerAngle = RLL;
        this.rightFootAngle = RLF;
        this.prevLeftLegUpperAngle = pLLU;
        this.prevLeftLegLowerAngle = pLLL;
        this.prevLeftFootAngle = pLLF;
        this.prevRightLegUpperAngle = pRLU;
        this.prevRightLegLowerAngle = pRLL;
        this.prevRightFootAngle = pRLF;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        MechaType type = this.getMechaType();
        if (damagesource.func_76355_l().equals("fall")) {
            boolean takeFallDamage = type.takeFallDamage && !this.stopFallDamage();
            boolean damageBlocksFromFalling = type.damageBlocksFromFalling || this.breakBlocksUponFalling();
            boolean wouldBeNegativeDamage = !(i * type.fallDamageMultiplier * this.vulnerability() - 2.0f < 0.0f);
            float damageToInflict = takeFallDamage ? i * (type.fallDamageMultiplier * this.vulnerability()) * (float)wouldBeNegativeDamage : 0.0f;
            float blockDamageFromFalling = damageBlocksFromFalling ? i * type.blockDamageFromFalling / 10.0f : 0.0f;
            this.driveableData.parts.get((Object)EnumDriveablePart.hips).attack(damageToInflict, false);
            this.checkParts();
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
            if (blockDamageFromFalling > 1.0f) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, blockDamageFromFalling, TeamsManager.explosions);
            }
        } else if (damagesource.field_76373_n.equals("player") && damagesource.func_76346_g().field_70122_E && (this.seats[0] == null || this.seats[0].field_70153_n == null) && (damagesource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d || TeamsManager.survivalCanBreakVehicles)) {
            ItemStack mechaStack = new ItemStack(type.item, 1, this.driveableData.paintjobID);
            mechaStack.field_77990_d = new NBTTagCompound();
            this.driveableData.writeToNBT(mechaStack.field_77990_d);
            this.inventory.writeToNBT(mechaStack.field_77990_d);
            DriveableDeathByHandEvent driveableDeathByHandEvent = new DriveableDeathByHandEvent(this, (EntityPlayer)damagesource.func_76346_g(), mechaStack);
            MinecraftForge.EVENT_BUS.post((Event)driveableDeathByHandEvent);
            if (!driveableDeathByHandEvent.isCanceled()) {
                this.func_70099_a(mechaStack, 0.5f);
                if (!this.field_70170_p.field_72995_K && damagesource.func_76346_g() instanceof EntityPlayer) {
                    FlansMod.log("Player %s broke mecha %s (%d) at (%f, %f, %f)", ((EntityPlayerMP)damagesource.func_76346_g()).getDisplayName(), type.shortName, this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                this.func_70106_y();
            }
        } else {
            this.driveableData.parts.get((Object)EnumDriveablePart.core).attack(i * this.vulnerability(), damagesource.func_76347_k());
        }
        return true;
    }

    @Override
    public float bulletHit(EntityBullet bullet, DriveableHit hit, float penetratingPower) {
        DriveablePart part = this.getDriveableData().parts.get((Object)hit.part);
        penetratingPower = bullet != null ? part.hitByBullet(bullet, hit, penetratingPower, this.vulnerability()) : (penetratingPower -= 5.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.checkParts();
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
        }
        return penetratingPower;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        boolean legDir = true;
        if (this.legPosition > 1.0f) {
            this.legPosition = 0.0f;
        }
        this.prevLeftLegUpperAngle = this.leftLegUpperAngle;
        this.prevLeftLegLowerAngle = this.leftLegLowerAngle;
        this.prevLeftFootAngle = this.leftFootAngle;
        this.prevRightLegUpperAngle = this.rightLegUpperAngle;
        this.prevRightLegLowerAngle = this.rightLegLowerAngle;
        this.prevRightFootAngle = this.rightFootAngle;
        for (MechaType.LegNode node : this.getMechaType().legNodes) {
            if (!(this.legPosition >= node.lowerBound) || !(this.legPosition <= node.upperBound)) continue;
            if (node.legPart == 1) {
                this.targetLeftUpper = node.rotation;
                this.targetLeftUpperSpeed = node.speed;
                continue;
            }
            if (node.legPart == 2) {
                this.targetLeftLower = node.rotation;
                this.targetLeftLowerSpeed = node.speed;
                continue;
            }
            if (node.legPart == 3) {
                this.targetLeftFoot = node.rotation;
                this.targetLeftFootSpeed = node.speed;
                continue;
            }
            if (node.legPart == 4) {
                this.targetRightUpper = node.rotation;
                this.targetRightUpperSpeed = node.speed;
                continue;
            }
            if (node.legPart == 5) {
                this.targetRightLower = node.rotation;
                this.targetRightLowerSpeed = node.speed;
                continue;
            }
            if (node.legPart != 6) continue;
            this.targetRightFoot = node.rotation;
            this.targetRightFootSpeed = node.speed;
        }
        if (this.leftLegUpperAngle < (float)this.targetLeftUpper) {
            this.leftLegUpperAngle += (float)this.targetLeftUpperSpeed;
        } else if (this.leftLegUpperAngle > (float)this.targetLeftUpper) {
            this.leftLegUpperAngle -= (float)this.targetLeftUpperSpeed;
        }
        if ((float)Math.sqrt((this.leftLegUpperAngle - (float)this.targetLeftUpper) * (this.leftLegUpperAngle - (float)this.targetLeftUpper)) <= (float)(this.targetLeftUpperSpeed / 2)) {
            this.leftLegUpperAngle = this.targetLeftUpper;
        }
        if (this.rightLegUpperAngle < (float)this.targetRightUpper) {
            this.rightLegUpperAngle += (float)this.targetRightUpperSpeed;
        } else if (this.rightLegUpperAngle > (float)this.targetRightUpper) {
            this.rightLegUpperAngle -= (float)this.targetRightUpperSpeed;
        }
        if ((float)Math.sqrt((this.rightLegUpperAngle - (float)this.targetRightUpper) * (this.rightLegUpperAngle - (float)this.targetRightUpper)) <= (float)(this.targetRightUpperSpeed / 2)) {
            this.rightLegUpperAngle = this.targetRightUpper;
        }
        if (this.leftLegLowerAngle < (float)this.targetLeftLower) {
            this.leftLegLowerAngle += (float)this.targetLeftLowerSpeed;
        } else if (this.leftLegLowerAngle > (float)this.targetLeftLower) {
            this.leftLegLowerAngle -= (float)this.targetRightLowerSpeed;
        }
        if (this.rightLegLowerAngle < (float)this.targetRightLower) {
            this.rightLegLowerAngle += (float)this.targetRightLowerSpeed;
        } else if (this.rightLegLowerAngle > (float)this.targetRightLower) {
            this.rightLegLowerAngle -= (float)this.targetRightLowerSpeed;
        }
        if ((float)Math.sqrt((this.leftLegLowerAngle - (float)this.targetLeftLower) * (this.leftLegLowerAngle - (float)this.targetLeftLower)) <= (float)(this.targetLeftLowerSpeed / 2)) {
            this.leftLegLowerAngle = this.targetLeftLower;
        }
        if ((float)Math.sqrt((this.rightLegLowerAngle - (float)this.targetRightLower) * (this.rightLegLowerAngle - (float)this.targetRightLower)) <= (float)(this.targetRightLowerSpeed / 2)) {
            this.rightLegLowerAngle = this.targetRightLower;
        }
        if (this.leftFootAngle < (float)this.targetLeftFoot) {
            this.leftFootAngle += (float)this.targetLeftFootSpeed;
        } else if (this.leftFootAngle > (float)this.targetLeftFoot) {
            this.leftFootAngle -= (float)this.targetLeftFootSpeed;
        }
        if (this.rightFootAngle < (float)this.targetRightFoot) {
            this.rightFootAngle += (float)this.targetRightFootSpeed;
        } else if (this.rightFootAngle > (float)this.targetRightFoot) {
            this.rightFootAngle -= (float)this.targetRightFootSpeed;
        }
        if ((float)Math.sqrt((this.rightFootAngle - (float)this.targetRightFoot) * (this.rightFootAngle - (float)this.targetRightFoot)) <= (float)(this.targetRightFootSpeed / 2)) {
            this.rightFootAngle = this.targetRightFoot;
        }
        if ((float)Math.sqrt((this.leftFootAngle - (float)this.targetLeftFoot) * (this.leftFootAngle - (float)this.targetLeftFoot)) <= (float)(this.targetLeftFootSpeed / 2)) {
            this.leftFootAngle = this.targetLeftFoot;
        }
        if (this.jumpDelay > 0) {
            --this.jumpDelay;
        }
        if (this.shootDelayLeft > 0.0f) {
            this.shootDelayLeft -= 1.0f;
        }
        if (this.shootDelayRight > 0.0f) {
            this.shootDelayRight -= 1.0f;
        }
        if (this.soundDelayLeft > 0) {
            --this.soundDelayLeft;
        }
        if (this.soundDelayRight > 0) {
            --this.soundDelayRight;
        }
        if (!(this.field_70170_p.field_72995_K || this.seats[0] != null && this.seats[0].field_70153_n != null)) {
            this.leftMouseHeld = false;
            this.rightMouseHeld = false;
        }
        this.leftAnimations.update();
        this.rightAnimations.update();
        MechaType type = this.getMechaType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Mecha type null. Not ticking mecha");
            return;
        }
        if (this.stompDelay > 0) {
            --this.stompDelay;
        }
        this.prevLegsYaw = this.legAxes.getYaw();
        if (type.setPlayerInvisible && !this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.seats[0].field_70153_n.func_82142_c(true);
        }
        if (this.toggleTimer == 0 && this.autoRepair() > 0.0f) {
            for (EnumDriveablePart part : EnumDriveablePart.values()) {
                boolean hasCreativePlayer;
                DriveablePart thisPart = data.parts.get((Object)part);
                boolean bl = hasCreativePlayer = this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                if (thisPart == null || thisPart.health == 0.0f || !(thisPart.health < thisPart.maxHealth) || !hasCreativePlayer && !(data.fuelInTank >= 10.0f)) continue;
                thisPart.health += this.autoRepair();
                if (hasCreativePlayer) continue;
                data.fuelInTank -= 10.0f;
            }
            this.toggleTimer = 20;
        }
        if (this.diamondDetect() != null && this.diamondTimer == 0 && this.field_70170_p.field_72995_K && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.seats[0].field_70153_n)) {
            float sqDistance = 901.0f;
            for (float i = -30.0f; i <= 30.0f; i += 1.0f) {
                for (float j = -30.0f; j <= 30.0f; j += 1.0f) {
                    for (float k = -30.0f; k <= 30.0f; k += 1.0f) {
                        int x = MathHelper.func_76128_c((double)((double)i + this.field_70165_t));
                        int y = MathHelper.func_76128_c((double)((double)j + this.field_70163_u));
                        int z = MathHelper.func_76128_c((double)((double)k + this.field_70161_v));
                        if (!(i * i + j * j + k * k < sqDistance) || this.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150482_ag) continue;
                        sqDistance = i * i + j * j + k * k;
                    }
                }
            }
            if (sqDistance < 901.0f) {
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.diamondDetect().detectSound, false);
                this.diamondTimer = 1 + 2 * MathHelper.func_76141_d((float)MathHelper.func_76129_c((float)sqDistance));
            }
        }
        if (this.diamondTimer > 0) {
            --this.diamondTimer;
        }
        if (this.isPartIntact(EnumDriveablePart.hips)) {
            this.func_70105_a(type.width, type.height);
            this.field_70129_M = type.yOffset;
        } else {
            this.func_70105_a(type.width, type.height - type.chassisHeight);
            this.field_70129_M = type.yOffset - type.chassisHeight;
        }
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.seats[0].field_70153_n);
        boolean driverIsLiving = this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityLivingBase;
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.mechaLove > 0 && this.ticksSinceUsed > TeamsManager.mechaLove * 20) {
            this.func_70106_y();
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, z);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        if (this.seats[0] != null) {
            if (this.seats[0].field_70153_n instanceof EntityLivingBase && !(this.seats[0].field_70153_n instanceof EntityPlayer)) {
                this.axes.setAngles(((EntityLivingBase)this.seats[0].field_70153_n).field_70761_aq + 90.0f, 0.0f, 0.0f);
            } else {
                if (type.limitHeadTurn) {
                    float axesLegs = this.legAxes.getYaw();
                    float axesBody = this.axes.getYaw();
                    double dYaw = axesBody - axesLegs;
                    if (dYaw > 180.0) {
                        axesBody -= 360.0f;
                    }
                    if (dYaw < -180.0) {
                        axesBody += 360.0f;
                    }
                    if (axesLegs + type.limitHeadTurnValue < axesBody) {
                        this.axes.setAngles(axesLegs + type.limitHeadTurnValue, 0.0f, 0.0f);
                    }
                    if (axesLegs - type.limitHeadTurnValue > axesBody) {
                        this.axes.setAngles(axesLegs - type.limitHeadTurnValue, 0.0f, 0.0f);
                    }
                }
                float yaw = this.seats[0].looking.getYaw() - this.seats[0].prevLooking.getYaw();
                this.axes.rotateGlobalYaw(yaw);
                this.seats[0].looking.rotateGlobalYaw(-yaw);
                this.seats[0].playerLooking.rotateGlobalYaw(-yaw);
            }
        }
        this.moveX = 0.0f;
        this.moveZ = 0.0f;
        float jetPack = this.jetPackPower();
        if (!this.field_70122_E && thePlayerIsDrivingThis && Minecraft.func_71410_x().field_71462_r instanceof GuiDriveableController && FlansMod.proxy.isKeyDown(4) && this.shouldFly() && (((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d || data.fuelInTank >= 10.0f * jetPack)) {
            this.field_70181_x *= 0.95;
            this.field_70181_x += 0.07 * (double)jetPack;
            this.field_70143_R = 0.0f;
            if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                data.fuelInTank -= 10.0f * jetPack;
            }
            if (this.rocketTimer <= 0.0f && this.rocketPack().soundEffect != null) {
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.rocketPack().soundEffect, false);
                this.rocketTimer = this.rocketPack().soundTime;
            }
        } else if (this.func_70090_H() && this.shouldFloat()) {
            this.field_70181_x *= 0.89;
            this.field_70181_x += 0.1;
        }
        if (this.rocketTimer != 0.0f) {
            this.rocketTimer -= 1.0f;
        }
        Vector3f actualMotion = new Vector3f(0.0, this.field_70181_x - (double)0.04f, 0.0);
        if (driverIsLiving) {
            Vector3f intent;
            boolean driverIsCreative;
            EntityLivingBase entity = (EntityLivingBase)this.seats[0].field_70153_n;
            boolean bl = driverIsCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            if (thePlayerIsDrivingThis && Minecraft.func_71410_x().field_71462_r instanceof GuiDriveableController) {
                if (FlansMod.proxy.isKeyDown(0)) {
                    this.moveX = 1.0f;
                }
                if (FlansMod.proxy.isKeyDown(1)) {
                    this.moveX = -1.0f;
                }
                if (FlansMod.proxy.isKeyDown(2)) {
                    this.moveZ = -1.0f;
                }
                if (FlansMod.proxy.isKeyDown(3)) {
                    this.moveZ = 1.0f;
                }
            } else if (this.seats[0].field_70153_n instanceof EntityLiving && !(this.seats[0].field_70153_n instanceof EntityPlayer)) {
                this.moveZ = 1.0f;
            }
            if ((double)Math.abs((intent = new Vector3f(this.moveX, 0.0f, this.moveZ)).lengthSquared()) > 0.1) {
                boolean canThrustCreatively;
                intent.normalise();
                this.legSwing += 1.0f;
                this.legPosition += this.getMechaType().legAnimSpeed;
                if (this.stompDelay == 0 && this.legPosition >= this.getMechaType().stompRangeLower && this.legPosition <= this.getMechaType().stompRangeUpper) {
                    PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.getMechaType().stompSound, false);
                    this.stompDelay = this.getMechaType().stompSoundLength;
                }
                intent = this.axes.findLocalVectorGlobally(intent);
                Vector3f intentOnLegAxes = this.legAxes.findGlobalVectorLocally(intent);
                float intentAngle = (float)Math.atan2(intent.z, intent.x) * 180.0f / (float)Math.PI;
                float angleBetween = intentAngle - this.legAxes.getYaw();
                if (angleBetween > 180.0f) {
                    angleBetween -= 360.0f;
                }
                if (angleBetween < -180.0f) {
                    angleBetween += 360.0f;
                }
                float signBetween = Math.signum(angleBetween);
                if ((double)(angleBetween = Math.abs(angleBetween)) > 0.1) {
                    this.legAxes.rotateGlobalYaw(Math.min(angleBetween, type.rotateSpeed) * signBetween);
                }
                intent.scale(type.moveSpeed * data.engine.engineSpeed * this.speedMultiplier() * 0.215f);
                boolean bl2 = canThrustCreatively = this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                if ((canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption) && this.isPartIntact(EnumDriveablePart.hips)) {
                    if (!this.field_70122_E && this.shouldFly() && (canThrustCreatively || data.fuelInTank > 10.0f * jetPack + data.engine.fuelConsumption)) {
                        intent.scale(jetPack);
                        if (!canThrustCreatively) {
                            data.fuelInTank -= 10.0f * jetPack;
                        }
                    }
                    Vector3f.add(actualMotion, intent, actualMotion);
                    if (!canThrustCreatively) {
                        data.fuelInTank -= data.engine.fuelConsumption;
                    }
                }
            } else {
                this.legPosition = 0.0f;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.leftMouseHeld) {
                    this.useItem(true);
                }
                if (this.rightMouseHeld) {
                    this.useItem(false);
                }
                if (this.breakingBlock != null) {
                    boolean breakingBlocks;
                    Block blockHit = this.field_70170_p.func_147439_a(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z);
                    int metadata = this.field_70170_p.func_72805_g(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z);
                    Material material = blockHit.func_149688_o();
                    ItemStack leftStack = this.inventory.getStackInSlot(EnumMechaSlotType.leftTool);
                    ItemStack rightStack = this.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
                    boolean leftStackIsTool = leftStack != null && leftStack.func_77973_b() instanceof ItemMechaAddon;
                    boolean rightStackIsTool = rightStack != null && rightStack.func_77973_b() instanceof ItemMechaAddon;
                    boolean bl3 = breakingBlocks = this.leftMouseHeld && leftStackIsTool || this.rightMouseHeld && rightStackIsTool;
                    if (blockHit == null || !breakingBlocks) {
                        this.breakingBlock = null;
                    } else {
                        float blockHardness = blockHit.func_149712_f(this.field_70170_p, this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z);
                        float mineSpeed = 1.0f;
                        boolean atLeastOneEffectiveTool = false;
                        if (leftStackIsTool) {
                            MechaItemType leftType = ((ItemMechaAddon)leftStack.func_77973_b()).type;
                            if (leftType.function.effectiveAgainst(material) && leftType.toolHardness > blockHardness) {
                                mineSpeed *= leftType.speed;
                                atLeastOneEffectiveTool = true;
                            }
                        }
                        if (rightStackIsTool) {
                            MechaItemType rightType = ((ItemMechaAddon)rightStack.func_77973_b()).type;
                            if (rightType.function.effectiveAgainst(material) && rightType.toolHardness > blockHardness) {
                                mineSpeed *= rightType.speed;
                                atLeastOneEffectiveTool = true;
                            }
                        }
                        mineSpeed = blockHardness < -0.01f ? 0.0f : (Math.abs(blockHardness) < 0.01f ? 9001.0f : (mineSpeed /= blockHit.func_149712_f(this.field_70170_p, this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z)));
                        this.breakingProgress += 0.1f * mineSpeed;
                        if (this.breakingProgress >= 1.0f) {
                            boolean cancelled = false;
                            if (entity instanceof EntityPlayerMP) {
                                BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)this.field_70170_p, (WorldSettings.GameType)(((EntityPlayerMP)entity).field_71075_bZ.field_75098_d ? WorldSettings.GameType.CREATIVE : (((EntityPlayerMP)entity).field_71075_bZ.field_75099_e ? WorldSettings.GameType.SURVIVAL : WorldSettings.GameType.ADVENTURE)), (EntityPlayerMP)((EntityPlayerMP)this.seats[0].field_70153_n), (int)this.breakingBlock.x, (int)this.breakingBlock.y, (int)this.breakingBlock.z);
                                cancelled = event.isCanceled();
                            }
                            if (!cancelled) {
                                boolean vacuumItems = this.vacuumItems();
                                if (vacuumItems) {
                                    for (ItemStack stack : blockHit.getDrops(this.field_70170_p, this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z, metadata, 0)) {
                                        float multiplier;
                                        boolean fuelCheck;
                                        boolean bl4 = fuelCheck = data.fuelInTank >= 5.0f || ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && this.refineIron() && stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).field_150939_a == Blocks.field_150366_p) {
                                            stack = new ItemStack(Items.field_151042_j, 1, 0);
                                            if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 5.0f;
                                            }
                                        }
                                        boolean bl5 = fuelCheck = data.fuelInTank >= 0.1f || ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && this.wasteCompact().booleanValue() && stack.func_77973_b() instanceof ItemBlock && (((ItemBlock)stack.func_77973_b()).field_150939_a == Blocks.field_150347_e || ((ItemBlock)stack.func_77973_b()).field_150939_a == Blocks.field_150346_d || ((ItemBlock)stack.func_77973_b()).field_150939_a == Blocks.field_150354_m)) {
                                            stack.field_77994_a = 0;
                                            if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 0.1f;
                                            }
                                        }
                                        boolean bl6 = fuelCheck = data.fuelInTank >= 3.0f * this.diamondMultiplier() || ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151045_i) {
                                            multiplier = this.diamondMultiplier();
                                            stack.field_77994_a = stack.field_77994_a * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0));
                                            if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 3.0f * this.diamondMultiplier();
                                            }
                                        }
                                        boolean bl7 = fuelCheck = data.fuelInTank >= 2.0f * this.redstoneMultiplier() || ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151137_ax) {
                                            multiplier = this.redstoneMultiplier();
                                            stack.field_77994_a = stack.field_77994_a * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0));
                                            if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 2.0f * this.redstoneMultiplier();
                                            }
                                        }
                                        boolean bl8 = fuelCheck = data.fuelInTank >= 2.0f * this.coalMultiplier() || ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151044_h) {
                                            multiplier = this.coalMultiplier();
                                            stack.field_77994_a = stack.field_77994_a * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0));
                                            if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 2.0f * this.coalMultiplier();
                                            }
                                        }
                                        boolean bl9 = fuelCheck = data.fuelInTank >= 2.0f * this.emeraldMultiplier() || ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151166_bC) {
                                            multiplier = this.emeraldMultiplier();
                                            stack.field_77994_a = stack.field_77994_a * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0));
                                            if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 2.0f * this.emeraldMultiplier();
                                            }
                                        }
                                        boolean bl10 = fuelCheck = data.fuelInTank >= 2.0f * this.ironMultiplier() || ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151042_j && this.refineIron()) {
                                            multiplier = this.ironMultiplier();
                                            stack.field_77994_a = stack.field_77994_a * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0));
                                            if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 2.0f * this.ironMultiplier();
                                            }
                                        }
                                        if (this.autoCoal() && stack.func_77973_b() == Items.field_151044_h && data.fuelInTank + 250.0f < (float)type.fuelTankSize) {
                                            data.fuelInTank = Math.min(data.fuelInTank + 1000.0f, (float)type.fuelTankSize);
                                            this.couldNotFindFuel = false;
                                            stack.field_77994_a = 0;
                                        }
                                        if (InventoryHelper.addItemStackToInventory(this.driveableData, stack, driverIsCreative) || this.field_70170_p.field_72995_K || !this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) continue;
                                        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)((float)this.breakingBlock.x + 0.5f), (double)((float)this.breakingBlock.y + 0.5f), (double)((float)this.breakingBlock.z + 0.5f), stack));
                                    }
                                }
                                this.field_70170_p.func_147480_a(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z, atLeastOneEffectiveTool && !vacuumItems);
                            }
                        }
                    }
                }
            }
        }
        this.field_70181_x = actualMotion.y;
        this.func_70091_d(actualMotion.x, actualMotion.y, actualMotion.z);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (thePlayerIsDrivingThis) {
            FlansMod.getPacketHandler().sendToServer(new PacketMechaControl(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketMechaControl(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (!driverIsLiving || thePlayerIsDrivingThis) {
            this.legSwing /= type.legSwingLimit;
        }
    }

    private float tailFloat(float f) {
        return f - (float)MathHelper.func_76141_d((float)f);
    }

    public boolean stopFallDamage() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.stopMechaFallDamage) continue;
            return true;
        }
        return false;
    }

    public boolean breakBlocksUponFalling() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.forceBlockFallDamage) continue;
            return true;
        }
        return false;
    }

    public boolean vacuumItems() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.vacuumItems) continue;
            return true;
        }
        return false;
    }

    public boolean refineIron() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.refineIron) continue;
            return true;
        }
        return false;
    }

    public MechaItemType diamondDetect() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.diamondDetect) continue;
            return type;
        }
        return null;
    }

    public Boolean wasteCompact() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.wasteCompact) continue;
            return true;
        }
        return false;
    }

    public float diamondMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneDiamond;
        }
        return multiplier;
    }

    public float speedMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.speedMultiplier;
        }
        return multiplier;
    }

    public float coalMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneCoal;
        }
        return multiplier;
    }

    public float redstoneMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneRedstone;
        }
        return multiplier;
    }

    public float vulnerability() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= 1.0f - type.damageResistance;
        }
        return multiplier;
    }

    public float emeraldMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneEmerald;
        }
        return multiplier;
    }

    public float ironMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneIron;
        }
        return multiplier;
    }

    public int lightLevel() {
        int level = 0;
        for (MechaItemType type : this.getUpgradeTypes()) {
            level = Math.max(level, type.lightLevel);
        }
        return level;
    }

    public boolean forceDark() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.forceDark) continue;
            return true;
        }
        return false;
    }

    public boolean autoCoal() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.autoCoal) continue;
            return true;
        }
        return false;
    }

    public float autoRepair() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.autoRepair) continue;
            return type.autoRepairAmount;
        }
        return -1.0f;
    }

    public boolean shouldFloat() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.floater) continue;
            return true;
        }
        return false;
    }

    public boolean infiniteAmmo() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.infiniteAmmo) continue;
            return true;
        }
        return false;
    }

    public MechaItemType rocketPack() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.rocketPack) continue;
            return type;
        }
        return null;
    }

    public boolean shouldFly() {
        return this.rocketPack() != null;
    }

    public float jetPackPower() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.rocketPower;
        }
        return multiplier;
    }

    public ArrayList<MechaItemType> getUpgradeTypes() {
        ArrayList<MechaItemType> types = new ArrayList<MechaItemType>();
        for (ItemStack stack : this.inventory.stacks.values()) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemMechaAddon)) continue;
            types.add(((ItemMechaAddon)stack.func_77973_b()).type);
        }
        return types;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat != 0;
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public boolean hasMouseControlMode() {
        return false;
    }

    @Override
    public String getBombInventoryName() {
        return "";
    }

    @Override
    public String getMissileInventoryName() {
        return "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return null;
    }
}

