/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.model.ModelPlane;
import com.flansmod.client.model.animation.AnimationController;
import com.flansmod.client.model.animation.AnimationPart;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.ItemPlane;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.Propeller;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.paintjob.Paintjob;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderPlane
extends Render
implements IItemRenderer {
    public RenderPlane() {
        this.field_76989_e = 1.0f;
    }

    public void render(EntityPlane entityPlane, double d, double d1, double d2, float f, float f1) {
        float dRoll;
        float dPitch;
        float dYaw;
        if (entityPlane.field_70154_o != null && entityPlane.field_70154_o.getClass().toString().indexOf("mcheli.aircraft.MCH_EntitySeat") > 0) {
            return;
        }
        this.func_110777_b(entityPlane);
        PlaneType type = entityPlane.getPlaneType();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        for (dYaw = entityPlane.axes.getYaw() - entityPlane.field_70126_B; dYaw > 180.0f; dYaw -= 360.0f) {
        }
        while (dYaw <= -180.0f) {
            dYaw += 360.0f;
        }
        for (dPitch = entityPlane.axes.getPitch() - entityPlane.field_70127_C; dPitch > 180.0f; dPitch -= 360.0f) {
        }
        while (dPitch <= -180.0f) {
            dPitch += 360.0f;
        }
        for (dRoll = entityPlane.axes.getRoll() - entityPlane.prevRotationRoll; dRoll > 180.0f; dRoll -= 360.0f) {
        }
        while (dRoll <= -180.0f) {
            dRoll += 360.0f;
        }
        GL11.glRotatef((float)(180.0f - entityPlane.field_70126_B - dYaw * f1), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(entityPlane.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(entityPlane.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
        ModelPlane model = (ModelPlane)type.model;
        if (model != null) {
            int i;
            GL11.glPushMatrix();
            GL11.glScalef((float)type.modelScale, (float)type.modelScale, (float)type.modelScale);
            model.render(entityPlane, f1);
            float dRotorAngle = entityPlane.rotorAngle - entityPlane.prevRotorAngle;
            float rotorAngle = entityPlane.prevRotorAngle + dRotorAngle * f1;
            for (i = 0; i < model.heliMainRotorModels.length; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)model.heliMainRotorOrigins[i].x, (float)model.heliMainRotorOrigins[i].y, (float)model.heliMainRotorOrigins[i].z);
                GL11.glRotatef((float)((entityPlane.rotorAngle + f1 * entityPlane.throttle / 7.0f) * model.heliRotorSpeeds[i] * 1440.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)(-model.heliMainRotorOrigins[i].x), (float)(-model.heliMainRotorOrigins[i].y), (float)(-model.heliMainRotorOrigins[i].z));
                model.renderRotor(entityPlane, 0.0625f, i);
                GL11.glPopMatrix();
            }
            for (i = 0; i < model.heliTailRotorModels.length; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)model.heliTailRotorOrigins[i].x, (float)model.heliTailRotorOrigins[i].y, (float)model.heliTailRotorOrigins[i].z);
                GL11.glRotatef((float)((entityPlane.rotorAngle + f1 * entityPlane.throttle / 7.0f) * 1440.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-model.heliTailRotorOrigins[i].x), (float)(-model.heliTailRotorOrigins[i].y), (float)(-model.heliTailRotorOrigins[i].z));
                model.renderTailRotor(entityPlane, 0.0625f, i);
                GL11.glPopMatrix();
            }
            Vector3f wingPos = this.getRenderPosition(entityPlane.wingPos, entityPlane.prevWingPos, f1);
            Vector3f wingRot = this.getRenderPosition(entityPlane.wingRot, entityPlane.prevWingRot, f1);
            if (entityPlane.initiatedAnim) {
                AnimationController cont = entityPlane.anim;
                AnimationPart p = cont.getCorePart();
                this.renderAnimPart(p, new Vector3f(0.0f, 0.0f, 0.0f), model, entityPlane, 0.0625f, f1);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(model.leftWingAttach.x + wingPos.x / 16.0f), (float)(model.leftWingAttach.y + wingPos.y / 16.0f), (float)(-model.leftWingAttach.z + wingPos.z / 16.0f));
            GL11.glRotatef((float)wingRot.x, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)wingRot.y, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)wingRot.z, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderLeftWing(entityPlane, 0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(model.rightWingAttach.x + wingPos.x / 16.0f), (float)(model.rightWingAttach.y + wingPos.y / 16.0f), (float)(-model.rightWingAttach.z + wingPos.z / 16.0f));
            GL11.glRotatef((float)(-wingRot.x), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-wingRot.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)wingRot.z, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderRightWing(entityPlane, 0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(model.leftWingWheelAttach.x + entityPlane.wingWheelPos.x / 16.0f), (float)(model.leftWingWheelAttach.y + entityPlane.wingWheelPos.y / 16.0f), (float)(-model.leftWingWheelAttach.z + entityPlane.wingWheelPos.z / 16.0f));
            GL11.glRotatef((float)entityPlane.wingWheelRot.x, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)entityPlane.wingWheelRot.y, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)entityPlane.wingWheelRot.z, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderLeftWingWheel(entityPlane, 0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(model.rightWingWheelAttach.x + entityPlane.wingWheelPos.x / 16.0f), (float)(model.rightWingWheelAttach.y + entityPlane.wingWheelPos.y / 16.0f), (float)(-model.rightWingWheelAttach.z + entityPlane.wingWheelPos.z / 16.0f));
            GL11.glRotatef((float)(-entityPlane.wingWheelRot.x), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-entityPlane.wingWheelRot.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)entityPlane.wingWheelRot.z, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderRightWingWheel(entityPlane, 0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(model.bodyWheelAttach.x + entityPlane.coreWheelPos.x / 16.0f), (float)(model.bodyWheelAttach.y + entityPlane.coreWheelPos.y / 16.0f), (float)(model.bodyWheelAttach.z + entityPlane.coreWheelPos.z / 16.0f));
            GL11.glRotatef((float)entityPlane.coreWheelRot.x, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)entityPlane.coreWheelRot.y, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)entityPlane.coreWheelRot.z, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderCoreWheel(entityPlane, 0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(model.tailWheelAttach.x + entityPlane.tailWheelPos.x / 16.0f), (float)(model.tailWheelAttach.y + entityPlane.tailWheelPos.y / 16.0f), (float)(model.tailWheelAttach.z + entityPlane.tailWheelPos.z / 16.0f));
            GL11.glRotatef((float)entityPlane.tailWheelRot.x, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)entityPlane.tailWheelRot.y, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)entityPlane.tailWheelRot.z, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderTailWheel(entityPlane, 0.0625f);
            GL11.glPopMatrix();
            Vector3f doorPos = this.getRenderPosition(entityPlane.doorPos, entityPlane.prevDoorPos, f1);
            Vector3f doorRot = this.getRenderPosition(entityPlane.doorRot, entityPlane.prevDoorRot, f1);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(model.doorAttach.x + doorPos.x / 16.0f), (float)(model.doorAttach.y + doorPos.y / 16.0f), (float)(model.doorAttach.z + doorPos.z / 16.0f));
            GL11.glRotatef((float)doorRot.x, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)doorRot.y, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)doorRot.z, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderDoor(entityPlane, 0.0625f);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
        if (FlansMod.DEBUG) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)-1.0f);
            for (DriveablePart part : entityPlane.getDriveableData().parts.values()) {
                if (part.box == null) continue;
                GL11.glColor4f((float)1.0f, (float)(entityPlane.isPartIntact(part.type) ? 1.0f : 0.0f), (float)0.0f, (float)0.3f);
                RenderPlane.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)part.box.x, (double)part.box.y, (double)part.box.z, (double)(part.box.x + part.box.w), (double)(part.box.y + part.box.h), (double)(part.box.z + part.box.d)));
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (Propeller prop : type.propellers) {
                RenderPlane.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)((float)prop.x / 16.0f - 0.25f), (double)((float)prop.y / 16.0f - 0.25f), (double)((float)prop.z / 16.0f - 0.25f), (double)((float)prop.x / 16.0f + 0.25f), (double)((float)prop.y / 16.0f + 0.25f), (double)((float)prop.z / 16.0f + 0.25f)));
            }
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)0.3f);
            for (ShootPoint point : type.shootPointsPrimary) {
                RenderPlane.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)(point.rootPos.position.x - 0.25f), (double)(point.rootPos.position.y - 0.25f), (double)(point.rootPos.position.z - 0.25f), (double)(point.rootPos.position.x + 0.25f), (double)(point.rootPos.position.y + 0.25f), (double)(point.rootPos.position.z + 0.25f)));
            }
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (ShootPoint point : type.shootPointsSecondary) {
                RenderPlane.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)(point.rootPos.position.x - 0.25f), (double)(point.rootPos.position.y - 0.25f), (double)(point.rootPos.position.z - 0.25f), (double)(point.rootPos.position.x + 0.25f), (double)(point.rootPos.position.y + 0.25f), (double)(point.rootPos.position.z + 0.25f)));
            }
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
    }

    public Vector3f getRenderPosition(Vector3f current, Vector3f previous, float f) {
        Vector3f diff = new Vector3f(current.x - previous.x, current.y - previous.y, current.z - previous.z);
        Vector3f corrected = new Vector3f(previous.x + diff.x * f, previous.y + diff.y * f, previous.z + diff.z * f);
        return corrected;
    }

    public void func_76986_a(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.render((EntityPlane)entity, d, d1, d2, f, f1);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        DriveableType type = ((EntityDriveable)entity).getDriveableType();
        Paintjob paintjob = type.getPaintjob(((EntityDriveable)entity).getDriveableData().paintjobID);
        return FlansModResourceHandler.getPaintjobTexture(paintjob);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: {
                return Minecraft.func_71410_x().field_71474_y.field_74347_j && item != null && item.func_77973_b() instanceof ItemPlane && ((ItemPlane)item.func_77973_b()).type.model != null;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        if (item != null && item.func_77973_b() instanceof ItemPlane) {
            PlaneType planeType = ((ItemPlane)item.func_77973_b()).type;
            if (planeType.model != null) {
                float scale = 0.5f;
                switch (type) {
                    case ENTITY: {
                        scale = 1.5f;
                        GL11.glRotatef((float)((EntityItem)data[1]).field_70173_aa, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case EQUIPPED: {
                        GL11.glRotatef((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.4f);
                        scale = 1.0f;
                        break;
                    }
                    case EQUIPPED_FIRST_PERSON: {
                        GL11.glRotatef((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.15f, (float)0.45f, (float)-0.6f);
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                }
                GL11.glScalef((float)(scale / planeType.cameraDistance), (float)(scale / planeType.cameraDistance), (float)(scale / planeType.cameraDistance));
                Minecraft.func_71410_x().field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(planeType));
                ModelDriveable model = planeType.model;
                model.render(planeType);
            }
        }
        GL11.glPopMatrix();
    }

    public int getPartId(int i) {
        int id = i;
        return id;
    }

    public void renderAnimPart(AnimationPart p, Vector3f parent, ModelPlane mod, EntityPlane plane, float f5, float f1) {
        Vector3f pos = Vector3f.sub(p.position, parent, null);
        Vector3f offset = this.Interpolate(p.offset, p.prevOff, f1);
        Vector3f rotation = this.Interpolate(p.rotation, p.prevRot, f1);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(pos.x / 16.0f), (float)(-pos.y / 16.0f), (float)(-pos.z / 16.0f));
        GL11.glRotatef((float)rotation.x, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotation.y, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotation.z, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(offset.x / 16.0f), (float)(offset.y / 16.0f), (float)(offset.z / 16.0f));
        int i = this.getPartId(p.type);
        mod.renderValk(plane, f5, i);
        if (p.hasChildren) {
            for (AnimationPart p2 : p.children) {
                this.renderAnimPart(p2, p.position, mod, plane, f5, f1);
            }
        }
        GL11.glPopMatrix();
    }

    public Vector3f Interpolate(Vector3f current, Vector3f prev, float f1) {
        Vector3f result = new Vector3f(prev.x + (current.x - prev.x) * f1, prev.y + (current.y - prev.y) * f1, prev.z + (current.z - prev.z) * f1);
        return result;
    }
}

