/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.model.GunAnimations;
import com.flansmod.client.model.ModelGun;
import com.flansmod.common.vector.Vector3f;
import org.lwjgl.opengl.GL11;

public class RenderArms {
    public static void renderArmPump(ModelGun model, GunAnimations anim, float smoothing, Vector3f rotationPoint, Vector3f armPosition) {
        GL11.glTranslatef((float)(-(armPosition.x - Math.abs(anim.lastPumped + (anim.pumped - anim.lastPumped) * smoothing) / model.pumpModifier)), (float)armPosition.y, (float)armPosition.z);
        RenderArms.handleRotate(rotationPoint, model);
    }

    public static void renderArmCharge(ModelGun model, GunAnimations anim, float smoothing, Vector3f rotationPoint, Vector3f armPosition) {
        RenderArms.handleRotate(rotationPoint, model);
        GL11.glTranslatef((float)(-(armPosition.x - Math.abs(anim.lastCharged + (anim.charged - anim.lastCharged) * smoothing) / model.chargeModifier.x)), (float)(-(armPosition.y - Math.abs(anim.lastCharged + (anim.charged - anim.lastCharged) * smoothing) / model.chargeModifier.y)), (float)(-(armPosition.z - Math.abs(anim.lastCharged + (anim.charged - anim.lastCharged) * smoothing) / model.chargeModifier.z)));
    }

    public static void renderArmBolt(ModelGun model, GunAnimations anim, float smoothing, Vector3f rotationPoint, Vector3f armPosition) {
        RenderArms.handleRotate(rotationPoint, model);
        GL11.glTranslatef((float)(armPosition.x + Math.abs(anim.lastPumped + (anim.pumped - anim.lastPumped) * smoothing) / model.chargeModifier.x), (float)(armPosition.y + Math.abs(anim.lastPumped + (anim.pumped - anim.lastPumped) * smoothing) / model.chargeModifier.y), (float)(-(armPosition.z - Math.abs(anim.lastCharged + (anim.charged - anim.lastCharged) * smoothing) / model.chargeModifier.z)));
    }

    public static void renderArmDefault(ModelGun model, GunAnimations anim, float smoothing, Vector3f rotationPoint, Vector3f armPosition) {
        RenderArms.handleRotate(rotationPoint, model);
        GL11.glTranslatef((float)armPosition.x, (float)armPosition.y, (float)armPosition.z);
    }

    public static void renderArmReload(ModelGun model, GunAnimations anim, float smoothing, Vector3f rotationPoint, Vector3f armPosition) {
        RenderArms.handleRotate(rotationPoint, model);
        GL11.glTranslatef((float)armPosition.x, (float)armPosition.y, (float)armPosition.z);
    }

    private static void handleRotate(Vector3f rotationPoint, ModelGun model) {
        if (model.easyArms) {
            GL11.glTranslatef((float)(0.4f * model.armScale.getX()), (float)(0.75f * model.armScale.getY()), (float)(-0.0f * model.armScale.getZ()));
        }
        GL11.glRotatef((float)rotationPoint.y, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotationPoint.z, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)rotationPoint.x, (float)1.0f, (float)0.0f, (float)0.0f);
        if (model.easyArms) {
            GL11.glTranslatef((float)(-0.4f * model.armScale.getX()), (float)(-0.75f * model.armScale.getY()), (float)(0.0f * model.armScale.getZ()));
        }
    }
}

