/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.pathfinder;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import noppes.npcs.ai.pathfinder.NodeProcessor;

public class WalkNodeProcessor
extends NodeProcessor {
    private boolean canEnterDoors;
    private boolean canBreakDoors;
    private boolean avoidsWater;
    private boolean canSwim;
    private boolean shouldAvoidWater;

    @Override
    public void initProcessor(IBlockAccess iblockaccessIn, Entity entityIn) {
        super.initProcessor(iblockaccessIn, entityIn);
        this.shouldAvoidWater = this.avoidsWater;
    }

    @Override
    public void postProcess() {
        super.postProcess();
        this.avoidsWater = this.shouldAvoidWater;
    }

    @Override
    public PathPoint getPathPointTo(Entity entityIn) {
        int i;
        if (this.canSwim && entityIn.func_70090_H()) {
            i = (int)entityIn.field_70121_D.field_72338_b;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)entityIn.field_70165_t), i, MathHelper.func_76128_c((double)entityIn.field_70161_v));
            Block block = this.blockaccess.func_147439_a(blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getY(), blockpos$mutableblockpos.getZ());
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                blockpos$mutableblockpos.set(MathHelper.func_76128_c((double)entityIn.field_70165_t), ++i, MathHelper.func_76128_c((double)entityIn.field_70161_v));
                block = this.blockaccess.func_147439_a(blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getY(), blockpos$mutableblockpos.getZ());
            }
            this.avoidsWater = false;
        } else {
            i = MathHelper.func_76128_c((double)(entityIn.field_70121_D.field_72338_b + 0.5));
        }
        return this.openPoint(MathHelper.func_76128_c((double)entityIn.field_70121_D.field_72340_a), i, MathHelper.func_76128_c((double)entityIn.field_70121_D.field_72339_c));
    }

    @Override
    public PathPoint getPathPointToCoords(Entity entityIn, double x, double y, double target) {
        return this.openPoint(MathHelper.func_76128_c((double)(x - (double)(entityIn.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)(target - (double)(entityIn.field_70130_N / 2.0f))));
    }

    @Override
    public int findPathOptions(PathPoint[] pathOptions, Entity entityIn, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        int i = 0;
        int j = 0;
        if (this.getVerticalOffset(entityIn, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c) == 1) {
            j = 1;
        }
        PathPoint pathpoint = this.getSafePoint(entityIn, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j);
        PathPoint pathpoint1 = this.getSafePoint(entityIn, currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j);
        PathPoint pathpoint2 = this.getSafePoint(entityIn, currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j);
        PathPoint pathpoint3 = this.getSafePoint(entityIn, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j);
        if (pathpoint != null && !pathpoint.field_75842_i && pathpoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint;
        }
        if (pathpoint1 != null && !pathpoint1.field_75842_i && pathpoint1.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint1;
        }
        if (pathpoint2 != null && !pathpoint2.field_75842_i && pathpoint2.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.field_75842_i && pathpoint3.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint3;
        }
        return i;
    }

    private PathPoint getSafePoint(Entity entityIn, int x, int y, int z, int p_176171_5_) {
        PathPoint pathpoint = null;
        int i = this.getVerticalOffset(entityIn, x, y, z);
        if (i == 2) {
            return this.openPoint(x, y, z);
        }
        if (i == 1) {
            pathpoint = this.openPoint(x, y, z);
        }
        if (pathpoint == null && p_176171_5_ > 0 && i != -3 && i != -4 && this.getVerticalOffset(entityIn, x, y + p_176171_5_, z) == 1) {
            pathpoint = this.openPoint(x, y + p_176171_5_, z);
            y += p_176171_5_;
        }
        if (pathpoint != null) {
            int j = 0;
            int k = 0;
            while (y > 0) {
                k = this.getVerticalOffset(entityIn, x, y - 1, z);
                if (this.avoidsWater && k == -1) {
                    return null;
                }
                if (k != 1) break;
                if (j++ >= entityIn.func_82143_as()) {
                    return null;
                }
                if (--y <= 0) {
                    return null;
                }
                pathpoint = this.openPoint(x, y, z);
            }
            if (k == -2) {
                return null;
            }
        }
        return pathpoint;
    }

    private int getVerticalOffset(Entity entityIn, int x, int y, int z) {
        return WalkNodeProcessor.func_176170_a(this.blockaccess, entityIn, x, y, z, this.entitySizeX, this.entitySizeY, this.entitySizeZ, this.avoidsWater, this.canBreakDoors, this.canEnterDoors);
    }

    public static int func_176170_a(IBlockAccess blockaccessIn, Entity entityIn, int x, int y, int z, int sizeX, int sizeY, int sizeZ, boolean avoidWater, boolean breakDoors, boolean enterDoors) {
        boolean flag = false;
        BlockPos blockpos = new BlockPos(entityIn);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = x; i < x + sizeX; ++i) {
            for (int j = y; j < y + sizeY; ++j) {
                for (int k = z; k < z + sizeZ; ++k) {
                    blockpos$mutableblockpos.set(i, j, k);
                    Block block = blockaccessIn.func_147439_a(blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getY(), blockpos$mutableblockpos.getZ());
                    if (block.func_149688_o() == Material.field_151579_a) continue;
                    if (block != Blocks.field_150415_aT) {
                        if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) {
                            if (!enterDoors && block instanceof BlockDoor && block.func_149688_o() == Material.field_151575_d) {
                                return 0;
                            }
                        } else {
                            if (avoidWater) {
                                return -1;
                            }
                            flag = true;
                        }
                    } else {
                        flag = true;
                    }
                    if (entityIn.field_70170_p.func_147439_a(blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getY(), blockpos$mutableblockpos.getZ()) instanceof BlockRailBase) {
                        if (entityIn.field_70170_p.func_147439_a(blockpos.getX(), blockpos.getY(), blockpos.getZ()) instanceof BlockRailBase || entityIn.field_70170_p.func_147439_a(blockpos.down().getX(), blockpos.down().getY(), blockpos.down().getZ()) instanceof BlockRailBase) continue;
                        return -3;
                    }
                    if (block.func_149655_b(blockaccessIn, blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getY(), blockpos$mutableblockpos.getZ()) || breakDoors && block instanceof BlockDoor && block.func_149688_o() == Material.field_151575_d) continue;
                    if (block instanceof BlockFence || block instanceof BlockFenceGate || block instanceof BlockWall) {
                        return -3;
                    }
                    if (block == Blocks.field_150415_aT) {
                        return -4;
                    }
                    Material material = block.func_149688_o();
                    if (material != Material.field_151587_i) {
                        return 0;
                    }
                    if (entityIn.func_70058_J()) continue;
                    return -2;
                }
            }
        }
        return flag ? 2 : 1;
    }

    public void setEnterDoors(boolean canEnterDoorsIn) {
        this.canEnterDoors = canEnterDoorsIn;
    }

    public void setBreakDoors(boolean canBreakDoorsIn) {
        this.canBreakDoors = canBreakDoorsIn;
    }

    public void setAvoidsWater(boolean avoidsWaterIn) {
        this.avoidsWater = avoidsWaterIn;
    }

    public void setCanSwim(boolean canSwimIn) {
        this.canSwim = canSwimIn;
    }

    public boolean getEnterDoors() {
        return this.canEnterDoors;
    }

    public boolean getCanSwim() {
        return this.canSwim;
    }

    public boolean getAvoidsWater() {
        return this.avoidsWater;
    }
}

