/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.paintjob.Paintjob;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PlayerClass
extends InfoType {
    public static List<PlayerClass> classes = new ArrayList<PlayerClass>();
    public List<String[]> startingItemStrings = new ArrayList<String[]>();
    public List<ItemStack> startingItems = new ArrayList<ItemStack>();
    public int lvl = 0;
    public ItemStack hat;
    public ItemStack chest;
    public ItemStack legs;
    public ItemStack shoes;

    public PlayerClass(TypeFile file) {
        super(file);
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        block20: {
            super.read(config, file);
            try {
                this.startingItemStrings = ConfigUtils.getSplitsFromKey(config, new String[]{"AddItem"});
                this.lvl = ConfigUtils.configInt(config, "UnlockLevel", this.lvl);
                this.texture = ConfigUtils.configString(config, "SkinOverride", this.texture);
                try {
                    String hatShortName = ConfigUtils.configString(config, new String[]{"Hat", "Helmet"}, null);
                    if (hatShortName != null && !hatShortName.equalsIgnoreCase("None")) {
                        ArmourType potentialHat = ArmourType.getArmourType(hatShortName);
                        if (potentialHat == null) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Hat type not found for PlayerClass", new String[]{"Hat/Helmet", hatShortName}, null);
                        } else {
                            this.hat = new ItemStack(potentialHat.item);
                        }
                    }
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding Helmet to player class", null, ex);
                }
                try {
                    String chestShortName = ConfigUtils.configString(config, new String[]{"Chest", "Top"}, null);
                    if (chestShortName != null && !chestShortName.equalsIgnoreCase("None")) {
                        ArmourType potentialChest = ArmourType.getArmourType(chestShortName);
                        if (potentialChest == null) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Chest/Top type not found for PlayerClass", new String[]{"Chest/Top", chestShortName}, null);
                        } else {
                            this.chest = new ItemStack(potentialChest.item);
                        }
                    }
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding Chest/Top to player class", null, ex);
                }
                try {
                    String legsShortName = ConfigUtils.configString(config, new String[]{"Legs", "Bottom"}, null);
                    if (legsShortName != null && !legsShortName.equalsIgnoreCase("None")) {
                        ArmourType potentialLegs = ArmourType.getArmourType(legsShortName);
                        if (potentialLegs == null) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Legs/Bottom type not found for PlayerClass", new String[]{"Legs/Bottom", legsShortName}, null);
                        } else {
                            this.legs = new ItemStack(potentialLegs.item);
                        }
                    }
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding Legs/Bottom to player class", null, ex);
                }
                try {
                    String shoesShortName = ConfigUtils.configString(config, new String[]{"Shoes", "Boots"}, null);
                    if (shoesShortName == null || shoesShortName.equalsIgnoreCase("None")) break block20;
                    ArmourType potentialShoes = ArmourType.getArmourType(shoesShortName);
                    if (potentialShoes == null) {
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Shoes/Boots type not found for PlayerClass", new String[]{"Shoes/Boots", shoesShortName}, null);
                        break block20;
                    }
                    this.shoes = new ItemStack(potentialShoes.item);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding Shoes/Boots to player class", null, ex);
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error thrown while reading player class", null, ex);
                this.isValid = false;
            }
        }
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    protected void postRead(TypeFile file) {
        if (this.shortName != null && this.isValid) {
            classes.add(this);
            this.onWorldLoad(null);
        }
    }

    @Override
    public void onWorldLoad(World world) {
        if (world != null && world.field_72995_K) {
            return;
        }
        try {
            this.startingItems.clear();
            long start = System.currentTimeMillis();
            for (String[] split : this.startingItemStrings) {
                Item matchingItem = null;
                int amount = 1;
                int damage = 0;
                String[] itemNames = split[1].split("\\+");
                Item vanillaMatch = (Item)Item.field_150901_e.func_82594_a(itemNames[0]);
                if (vanillaMatch != null) {
                    matchingItem = vanillaMatch;
                } else {
                    Item flansMatch = (Item)Item.field_150901_e.func_82594_a("flansmod:" + itemNames[0]);
                    if (flansMatch != null) {
                        matchingItem = flansMatch;
                    }
                }
                if (matchingItem == null) {
                    for (InfoType object : Item.field_150901_e) {
                        Item item = (Item)object;
                        if (item == null || item.func_77658_a() == null || !item.func_77658_a().equals(itemNames[0]) && (item.func_77658_a().split("\\.").length <= 1 || !item.func_77658_a().split("\\.")[1].equals(itemNames[0]))) continue;
                        matchingItem = item;
                    }
                }
                for (InfoType type : InfoType.infoTypes) {
                    if (!type.shortName.equals(itemNames[0]) || type.item == null) continue;
                    matchingItem = type.item;
                }
                if (matchingItem == null) {
                    FlansMod.log("Tried to add " + split[1] + " to player class " + this.shortName + " but the item did not exist");
                    return;
                }
                if (split.length > 2) {
                    amount = Integer.parseInt(split[2]);
                }
                if (split.length > 3) {
                    damage = Integer.parseInt(split[3]);
                }
                ItemStack stack = new ItemStack(matchingItem, amount, damage);
                if (itemNames.length > 1 && matchingItem instanceof ItemGun) {
                    ItemGun itemGun = (ItemGun)matchingItem;
                    GunType gunType = itemGun.type;
                    NBTTagCompound tags = new NBTTagCompound();
                    NBTTagCompound attachmentTags = new NBTTagCompound();
                    int genericID = 0;
                    for (int i = 0; i < itemNames.length - 1; ++i) {
                        AttachmentType attachment = AttachmentType.getAttachment(itemNames[i + 1]);
                        if (attachment != null) {
                            String tagName = null;
                            switch (attachment.type) {
                                case sights: {
                                    tagName = "scope";
                                    break;
                                }
                                case barrel: {
                                    tagName = "barrel";
                                    break;
                                }
                                case stock: {
                                    tagName = "stock";
                                    break;
                                }
                                case grip: {
                                    tagName = "grip";
                                    break;
                                }
                                case generic: {
                                    tagName = "generic_" + genericID++;
                                    break;
                                }
                                case accessory: {
                                    break;
                                }
                                case gadget: {
                                    break;
                                }
                                case pump: {
                                    break;
                                }
                            }
                            NBTTagCompound specificAttachmentTags = new NBTTagCompound();
                            new ItemStack(attachment.item).func_77955_b(specificAttachmentTags);
                            attachmentTags.func_74782_a(tagName, (NBTBase)specificAttachmentTags);
                            continue;
                        }
                        Paintjob paintjob = gunType.getPaintjob(itemNames[i + 1]);
                        if (paintjob == null) continue;
                        tags.func_74778_a("Paint", paintjob.iconName);
                    }
                    tags.func_74782_a("attachments", (NBTBase)attachmentTags);
                    stack.field_77990_d = tags;
                    ShootableType ammo = gunType.getDefaultAmmo();
                    if (ammo != null) {
                        ItemStack ammoStack = new ItemStack(ammo.item);
                        ammoStack.field_77994_a = 1;
                        itemGun.setBulletItemStack(stack, ammoStack, 0);
                    }
                }
                this.startingItems.add(stack);
            }
            long end = System.currentTimeMillis() - start;
            if (!this.startingItemStrings.isEmpty()) {
                FlansMod.log("Loaded PlayerClass for " + this.name + " (" + this.packName + ") in " + end + " ms");
            }
        }
        catch (Exception e) {
            FlansMod.log("Interpreting player class file failed.");
            FlansMod.logger.error((Object)e);
        }
    }

    public static PlayerClass getClass(String s) {
        for (PlayerClass playerClass : classes) {
            if (!playerClass.shortName.equals(s)) continue;
            return playerClass;
        }
        return null;
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }
}

