/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.client.model.ModelCustomArmour;
import com.flansmod.common.FlansMod;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;

public class ArmourType
extends InfoType {
    public static ArrayList<ArmourType> armours = new ArrayList();
    public int type;
    public double defence;
    public double bulletDefence;
    public float penetrationResistance = 0.0f;
    public String armourTextureName;
    public float moveSpeedModifier = 1.0f;
    public float knockbackModifier = 0.2f;
    public float jumpModifier = 1.0f;
    public boolean nightVision = false;
    public boolean invisible = false;
    public String overlay = null;
    public boolean smokeProtection = false;
    public boolean negateFallDamage = false;
    public boolean fireResistance = false;
    public boolean waterBreathing = false;
    public boolean onWaterWalking = false;
    public boolean hasDurability = false;
    public int durability = 0;
    public ModelCustomArmour model;

    public ArmourType(TypeFile file) {
        super(file);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    public void postRead(TypeFile file) {
        if (this.shortName != null && this.isValid) {
            armours.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            String typeName;
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelCustomArmour.class);
            }
            if (this.model != null) {
                this.model.type = this;
            }
            if ((typeName = ConfigUtils.configString(config, "Type", null)) == null) {
                this.type = 0;
                FlansMod.log("Armour %s in pack %s with unknown type detected. Assuming Helmet.", this.shortName, this.packName);
            } else {
                switch (typeName) {
                    case "Hat": 
                    case "Helmet": {
                        this.type = 0;
                        break;
                    }
                    case "Chest": 
                    case "Body": {
                        this.type = 1;
                        break;
                    }
                    case "Legs": 
                    case "Pants": {
                        this.type = 2;
                        break;
                    }
                    case "Shoes": 
                    case "Boots": {
                        this.type = 3;
                    }
                }
            }
            this.defence = ConfigUtils.configFloat(config, new String[]{"OtherDefence", "Defence", "DamageReduction"}, (float)this.defence);
            this.bulletDefence = ConfigUtils.configFloat(config, "BulletDefence", (float)this.defence);
            this.moveSpeedModifier = ConfigUtils.configFloat(config, new String[]{"MoveSpeedModifier", "Slowness"}, this.moveSpeedModifier);
            this.jumpModifier = ConfigUtils.configFloat(config, "JumpModifier", this.jumpModifier);
            this.knockbackModifier = ConfigUtils.configFloat(config, new String[]{"KnockbackReduction", "KnockbackModifier"}, this.knockbackModifier);
            this.penetrationResistance = ConfigUtils.configFloat(config, "PenetrationResistance", this.penetrationResistance);
            this.nightVision = ConfigUtils.configBool(config, "NightVision", this.nightVision);
            this.invisible = ConfigUtils.configBool(config, "Invisible", this.invisible);
            this.negateFallDamage = ConfigUtils.configBool(config, "NegateFallDamage", this.negateFallDamage);
            this.fireResistance = ConfigUtils.configBool(config, "FireResistance", this.fireResistance);
            this.waterBreathing = ConfigUtils.configBool(config, "WaterBreathing", this.waterBreathing);
            this.overlay = ConfigUtils.configString(config, "Overlay", this.overlay);
            this.smokeProtection = ConfigUtils.configBool(config, "SmokeProtection", this.smokeProtection);
            this.onWaterWalking = ConfigUtils.configBool(config, "OnWaterWalking", this.onWaterWalking);
            this.durability = ConfigUtils.configInt(config, "Durability", this.durability);
            this.hasDurability = this.durability > 0;
            this.armourTextureName = ConfigUtils.configString(config, new String[]{"ArmourTexture", "ArmorTexture"}, this.armourTextureName);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error occurred while reading armour file", null, ex);
            this.isValid = false;
        }
    }

    public static ArmourType getArmourType(String string) {
        for (ArmourType armour : armours) {
            if (!armour.shortName.equals(string)) continue;
            return armour;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelCustomArmour.class);
        if (this.model != null) {
            this.model.type = this;
        }
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }
}

