/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EnumHitPenetrationResult;
import com.flansmod.common.guns.raytracing.BlockHit;
import com.flansmod.common.guns.raytracing.BulletHit;
import com.flansmod.common.guns.raytracing.DriveableHit;
import com.flansmod.common.guns.raytracing.EntityHit;
import com.flansmod.common.guns.raytracing.EnumHitboxType;
import com.flansmod.common.guns.raytracing.PlayerBulletHit;
import com.flansmod.common.guns.raytracing.PlayerSnapshot;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldServer;

public class TEST_PacketClientBulletUpdate
extends PacketBase {
    private List<BulletHit> hits;
    private int bulletId;
    private EnumHitPenetrationResult penetrationResult;

    public TEST_PacketClientBulletUpdate() {
        this.penetrationResult = EnumHitPenetrationResult.PENETRATED;
    }

    public TEST_PacketClientBulletUpdate(List<BulletHit> hits, int bulletId, EnumHitPenetrationResult penetrationResult) {
        this.hits = hits;
        this.bulletId = bulletId;
        this.penetrationResult = penetrationResult;
    }

    public TEST_PacketClientBulletUpdate(List<BulletHit> hits, int bulletId) {
        this.penetrationResult = EnumHitPenetrationResult.PENETRATED;
        this.hits = hits;
        this.bulletId = bulletId;
    }

    public TEST_PacketClientBulletUpdate(BulletHit shotData) {
        this.penetrationResult = EnumHitPenetrationResult.PENETRATED;
        this.hits = new ArrayList<BulletHit>();
        this.hits.add(shotData);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.bulletId);
        data.writeByte(this.penetrationResult.ordinal());
        int numHits = Math.min(this.hits.size(), 120);
        data.writeByte(numHits);
        for (int i = 0; i < numHits; ++i) {
            BulletHit current = this.hits.get(i);
            TEST_PacketClientBulletUpdate.WriteToBuffer(current, data);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.bulletId = data.readInt();
        this.penetrationResult = EnumHitPenetrationResult.values()[data.readByte()];
        this.hits = new ArrayList<BulletHit>();
        int numEntries = data.readByte();
        for (int i = 0; i < numEntries; ++i) {
            BulletHit hit2 = TEST_PacketClientBulletUpdate.ReadFromBuffer(data);
            this.hits.add(hit2);
        }
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        if (player.func_70089_S()) {
            PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player, Side.SERVER);
            EntityBullet bullet = data.controllingBullets.get(this.bulletId);
            if (bullet != null && !bullet.field_70128_L) {
                bullet.handleClientCalculatedHits(data, this.hits);
                if (this.penetrationResult == EnumHitPenetrationResult.STOPPED) {
                    bullet.func_70106_y();
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
    }

    private static byte GetClassType(BulletHit hit) {
        if (hit instanceof BlockHit) {
            return 0;
        }
        if (hit instanceof EntityHit) {
            return 1;
        }
        if (hit instanceof DriveableHit) {
            return 2;
        }
        return (byte)(hit instanceof PlayerBulletHit ? 3 : -1);
    }

    public static void WriteToBuffer(BulletHit hit, ByteBuf buffer) {
        buffer.writeByte((int)TEST_PacketClientBulletUpdate.GetClassType(hit));
        if (hit != null) {
            buffer.writeFloat(hit.intersectTime);
            if (hit instanceof BlockHit) {
                BlockHit blockHit = (BlockHit)hit;
                buffer.writeInt(blockHit.raytraceResult.field_72310_e);
                buffer.writeInt(blockHit.raytraceResult.field_72311_b);
                buffer.writeInt(blockHit.raytraceResult.field_72312_c);
                buffer.writeInt(blockHit.raytraceResult.field_72309_d);
                new Vector3f(blockHit.raytraceResult.field_72307_f.field_72450_a, blockHit.raytraceResult.field_72307_f.field_72448_b, blockHit.raytraceResult.field_72307_f.field_72449_c).writeToBuffer(buffer);
            }
            if (hit instanceof EntityHit) {
                EntityHit entityHit = (EntityHit)hit;
                buffer.writeInt(entityHit.entity.func_145782_y());
            }
            if (hit instanceof DriveableHit) {
                DriveableHit driveableHit = (DriveableHit)hit;
                buffer.writeInt(driveableHit.driveable.func_145782_y());
                buffer.writeByte(driveableHit.part.ordinal());
            }
            if (hit instanceof PlayerBulletHit) {
                PlayerBulletHit playerBulletHit = (PlayerBulletHit)hit;
                buffer.writeInt(playerBulletHit.hitbox.player.func_145782_y());
                buffer.writeByte(playerBulletHit.hitbox.type.ordinal());
            }
        }
    }

    public static BulletHit ReadFromBuffer(ByteBuf buffer) {
        byte type = buffer.readByte();
        float intersectTime = buffer.readFloat();
        switch (type) {
            default: {
                return null;
            }
            case 0: {
                int facing = buffer.readInt();
                return new BlockHit(new MovingObjectPosition(buffer.readInt(), buffer.readInt(), buffer.readInt(), facing, Vector3f.readFromBuffer(buffer).toVec3()), intersectTime);
            }
            case 1: {
                Entity entity = TEST_PacketClientBulletUpdate.GetEntityByID(buffer.readInt());
                return new EntityHit(entity, intersectTime);
            }
            case 2: {
                Entity entity = TEST_PacketClientBulletUpdate.GetEntityByID(buffer.readInt());
                if (entity instanceof EntityDriveable) {
                    return new DriveableHit((EntityDriveable)entity, EnumDriveablePart.values()[buffer.readByte()], intersectTime);
                }
                FlansMod.log("Entity was not a driveable");
                return null;
            }
            case 3: 
        }
        Entity entity = TEST_PacketClientBulletUpdate.GetEntityByID(buffer.readInt());
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerSnapshot snapshot = new PlayerSnapshot(player);
            return new PlayerBulletHit(snapshot.getHitboxByType(EnumHitboxType.values()[buffer.readByte()]), intersectTime);
        }
        FlansMod.log("Entity was not a player");
        return null;
    }

    public static Entity GetEntityByID(int id) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                Entity entity = world.func_73045_a(id);
                if (entity == null) continue;
                return entity;
            }
            return null;
        }
        return Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
    }
}

