/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelVehicle;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import java.util.ArrayList;

public class VehicleType
extends DriveableType {
    public float turnLeftModifier = 1.0f;
    public float turnRightModifier = 1.0f;
    public boolean squashMobs = false;
    public boolean fourWheelDrive = false;
    public boolean rotateWheels = false;
    public boolean tank = false;
    public float throttleDecay = 0.0035f;
    public int vehicleShootDelay;
    public int vehicleShellDelay;
    public boolean hasDoor = false;
    public float mass = 1000.0f;
    public boolean useRealisticAcceleration = false;
    public float brakingModifier = 1.0f;
    public float maxFallSpeed = 0.85f;
    public float gravity = 0.175f;
    public Vector3f doorPos1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorPos2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRot1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRot2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRotRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f door2Pos1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f door2Pos2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f door2Rot1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f door2Rot2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f door2Rate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f door2RotRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean shootWithOpenDoor = false;
    public int trackLinkFix = 5;
    public ArrayList<SmokePoint> smokers = new ArrayList();
    public static ArrayList<VehicleType> types = new ArrayList();
    public String stompSoundFrontRight = null;
    public String stompSoundFrontLeft = null;
    public String stompSoundBackRight = null;
    public String stompSoundBackLeft = null;

    public VehicleType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
        this.wheelPositions = new DriveablePosition[4];
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        if (this.shortName != null && this.isValid) {
            types.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            this.turnLeftModifier = ConfigUtils.configFloat(config, "TurnLeftSpeed", this.turnLeftModifier);
            this.turnRightModifier = ConfigUtils.configFloat(config, "TurnRightSpeed", this.turnRightModifier);
            this.squashMobs = ConfigUtils.configBool(config, "SquashMobs", this.squashMobs);
            this.fourWheelDrive = ConfigUtils.configBool(config, "FourWheelDrive", this.fourWheelDrive);
            this.tank = ConfigUtils.configBool(config, new String[]{"Tank", "TankMode"}, this.tank);
            this.throttleDecay = ConfigUtils.configFloat(config, "ThrottleDecay", this.throttleDecay);
            this.mass = ConfigUtils.configFloat(config, "Mass", this.mass);
            this.useRealisticAcceleration = ConfigUtils.configBool(config, "UseRealisticAcceleration", this.useRealisticAcceleration);
            this.gravity = ConfigUtils.configFloat(config, "Gravity", this.gravity);
            this.maxFallSpeed = ConfigUtils.configFloat(config, "MaxFallSpeed", this.maxFallSpeed);
            this.brakingModifier = ConfigUtils.configFloat(config, "BrakingModifier", this.brakingModifier);
            this.hasDoor = ConfigUtils.configBool(config, "HasDoor", this.hasDoor);
            this.shootWithOpenDoor = ConfigUtils.configBool(config, "ShootWithOpenDoor", this.shootWithOpenDoor);
            this.rotateWheels = ConfigUtils.configBool(config, "RotateWheels", this.rotateWheels);
            this.trackLinkFix = ConfigUtils.configInt(config, "FixTrackLink", this.trackLinkFix);
            this.doorPos1 = ConfigUtils.configVector(config, "DoorPosition1", this.doorPos1);
            this.doorPos2 = ConfigUtils.configVector(config, "DoorPosition2", this.doorPos2);
            this.doorRot1 = ConfigUtils.configVector(config, "DoorRotation1", this.doorRot1);
            this.doorRot2 = ConfigUtils.configVector(config, "DoorRotation2", this.doorRot2);
            this.doorRate = ConfigUtils.configVector(config, "DoorRate", this.doorRate);
            this.doorRotRate = ConfigUtils.configVector(config, "DoorRotRate", this.doorRotRate);
            this.door2Pos1 = ConfigUtils.configVector(config, "Door2Position1", this.door2Pos1);
            this.door2Pos2 = ConfigUtils.configVector(config, "Door2Position2", this.door2Pos2);
            this.door2Rot1 = ConfigUtils.configVector(config, "Door2Rotation1", this.door2Rot1);
            this.door2Rot2 = ConfigUtils.configVector(config, "Door2Rotation2", this.door2Rot2);
            this.door2Rate = ConfigUtils.configVector(config, "Door2Rate", this.door2Rate);
            this.door2RotRate = ConfigUtils.configVector(config, "Door2RotRate", this.door2RotRate);
            this.vehicleShootDelay = ConfigUtils.configInt(config, "ShootDelay", this.vehicleShootDelay);
            this.vehicleShellDelay = ConfigUtils.configInt(config, "ShellDelay", this.vehicleShellDelay);
            this.shootSoundPrimary = ConfigUtils.configDriveableSound(this.packName, config, "ShootSound", this.shootSoundPrimary);
            this.shootSoundSecondary = ConfigUtils.configDriveableSound(this.packName, config, "ShellSound", this.shootSoundSecondary);
            ArrayList<String[]> splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddSmokePoint", "AddSmokeDispenser"});
            for (String[] split : splits) {
                try {
                    SmokePoint smoke = new SmokePoint();
                    smoke.position = new Vector3f(split[1]);
                    smoke.direction = new Vector3f(split[2]);
                    smoke.detTime = Integer.parseInt(split[3]);
                    smoke.part = split[4];
                    this.smokers.add(smoke);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding SmokePoint failed", split, ex);
                }
            }
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal Error! Reading VehicleType failed", null, ex);
            this.isValid = false;
        }
    }

    public static VehicleType getVehicle(String find) {
        for (VehicleType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelVehicle.class);
    }

    public class SmokePoint {
        public Vector3f position;
        public Vector3f direction;
        public int detTime;
        public String part;
    }
}

