/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.common.FlansMod;
import com.flansmod.common.IFlansContentProvider;
import com.flansmod.common.driveables.ItemPlane;
import com.flansmod.common.driveables.ItemVehicle;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.driveables.mechas.ItemMecha;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.AAGunType;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemAAGun;
import com.flansmod.common.guns.ItemAttachment;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGrenade;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.sync.Sync;
import com.flansmod.common.teams.ArmourBoxType;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.teams.BlockArmourBox;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.tools.ToolType;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;

public class ContentManager {
    public static final Pattern zipJar = Pattern.compile("(.+).(zip|jar)$");
    public static boolean DEV_ENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    private boolean loggedDeobf;
    private boolean reloadResources;
    private final HashMap<String, IFlansContentProvider> contentPacks = new HashMap();

    public void loadContent() {
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            for (ArtifactVersion requirements : modContainer.getRequirements()) {
                if (!requirements.getLabel().equals("flansmod") || !(modContainer.getMod() instanceof IFlansContentProvider)) continue;
                IFlansContentProvider provider = (IFlansContentProvider)modContainer.getMod();
                String directory = provider.getContentDirectory();
                File source = modContainer.getSource();
                if (DEV_ENV) {
                    if (!this.loggedDeobf) {
                        FlansMod.logger.warn("Detected deobfuscated Forge environment, content packs will be loaded from directories");
                        this.loggedDeobf = true;
                    }
                    this.contentPacks.put(directory, new ContentPackMod(modContainer, provider));
                    continue;
                }
                if (!zipJar.matcher(source.getName()).matches()) continue;
                this.contentPacks.put(directory, new ContentPackMod(modContainer, provider));
            }
        }
        for (File file : Objects.requireNonNull(FlansMod.flanDir.listFiles())) {
            if (!file.isDirectory() && !zipJar.matcher(file.getName()).matches()) continue;
            if (this.contentPacks.containsKey(file.getName())) {
                FlansMod.logger.warn("Skipping duplicated content pack {}", new Object[]{file.getName()});
            } else {
                this.contentPacks.put(file.getName(), new ContentPackFlans(file.getName(), file));
                FlansMod.logger.info("Loaded content pack : " + file.getName());
            }
            this.reloadResources = true;
        }
        for (IFlansContentProvider iFlansContentProvider : this.contentPacks.values()) {
            iFlansContentProvider.registerModelLocations();
        }
        for (Map.Entry entry : this.contentPacks.entrySet()) {
            String name = (String)entry.getKey();
            IFlansContentProvider provider = (IFlansContentProvider)entry.getValue();
            if (provider instanceof ContentPackFlans) {
                ContentPackFlans contentPack = (ContentPackFlans)provider;
                if (contentPack.source.isDirectory()) {
                    this.loadTypesDirectory(name, contentPack.source);
                    continue;
                }
                this.loadTypesArchive(name, contentPack.source);
                continue;
            }
            if (!(provider instanceof ContentPackMod)) continue;
            ContentPackMod mod = (ContentPackMod)provider;
            if (DEV_ENV) {
                this.loadTypesDirectory(name, new File(FlansMod.flanDir, provider.getContentDirectory()));
                continue;
            }
            if (!zipJar.matcher(mod.container.getSource().getName()).matches()) continue;
            this.loadTypesArchive(name, mod.container.getSource());
        }
    }

    public void createItems() {
        for (EnumType type : EnumType.values()) {
            Class<? extends InfoType> typeClass = type.getTypeClass();
            for (TypeFile typeFile : TypeFile.files.get((Object)type)) {
                try {
                    if (typeFile.lines.size() == 0) continue;
                    InfoType infoType = typeClass.getConstructor(TypeFile.class).newInstance(typeFile);
                    infoType.read(typeFile);
                    if (infoType.shortName == null || !infoType.isValid) continue;
                    switch (type) {
                        case bullet: {
                            FlansMod.bulletItems.add((ItemBullet)new ItemBullet((BulletType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case attachment: {
                            FlansMod.attachmentItems.add((ItemAttachment)new ItemAttachment((AttachmentType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case gun: {
                            FlansMod.gunItems.add((ItemGun)new ItemGun((GunType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case grenade: {
                            FlansMod.grenadeItems.add((ItemGrenade)new ItemGrenade((GrenadeType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case part: {
                            FlansMod.partItems.add((ItemPart)new ItemPart((PartType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case plane: {
                            FlansMod.planeItems.add((ItemPlane)new ItemPlane((PlaneType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case vehicle: {
                            FlansMod.vehicleItems.add((ItemVehicle)new ItemVehicle((VehicleType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case aa: {
                            FlansMod.aaGunItems.add((ItemAAGun)new ItemAAGun((AAGunType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case mechaItem: {
                            FlansMod.mechaToolItems.add((ItemMechaAddon)new ItemMechaAddon((MechaItemType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case mecha: {
                            FlansMod.mechaItems.add((ItemMecha)new ItemMecha((MechaType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case tool: {
                            FlansMod.toolItems.add((ItemTool)new ItemTool((ToolType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case box: {
                            FlansMod.gunBoxBlocks.add((BlockGunBox)new BlockGunBox((GunBoxType)infoType).func_149663_c(infoType.shortName));
                            break;
                        }
                        case armour: {
                            FlansMod.armourItems.add((ItemTeamArmour)new ItemTeamArmour((ArmourType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case armourBox: {
                            FlansMod.armourBoxBlocks.add((BlockArmourBox)new BlockArmourBox((ArmourBoxType)infoType).func_149663_c(infoType.shortName));
                            break;
                        }
                        case playerClass: 
                        case team: {
                            break;
                        }
                        default: {
                            FlansMod.logger.error("Unrecognized type for " + infoType.shortName);
                        }
                    }
                    Sync.addHash(typeFile.lines.toString(), infoType.shortName);
                }
                catch (Exception e) {
                    FlansMod.logger.error("Failed to add " + type.name() + " : " + typeFile.name, (Throwable)e);
                }
            }
            FlansMod.logger.info("Loaded " + type.folderNames[0] + ".");
        }
        Sync.getUnifiedHash();
        FlansMod.logger.info("Client Hash: " + Sync.getUnifiedHash());
    }

    private void loadTypesDirectory(String packName, File contentPack) {
        for (EnumType typeToCheckFor : EnumType.values()) {
            for (String folderName : typeToCheckFor.folderNames) {
                File typesDir = new File(contentPack, "/" + folderName + "/");
                if (!typesDir.exists()) continue;
                for (File file : FileUtils.listFiles((File)typesDir, null, (boolean)true)) {
                    if (file.isDirectory()) continue;
                    if (!file.getName().endsWith(".txt")) {
                        FlansMod.logger.warn("Type file {} does not have a recognized file extension", new Object[]{file.getName()});
                    }
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(file));
                        String[] splitName = file.getName().split("/");
                        TypeFile typeFile = new TypeFile(typeToCheckFor, splitName[splitName.length - 1].split("\\.")[0], packName);
                        while (true) {
                            String line;
                            try {
                                line = reader.readLine();
                            }
                            catch (Exception e) {
                                break;
                            }
                            if (line == null) break;
                            typeFile.lines.add(line);
                        }
                        reader.close();
                    }
                    catch (IOException e) {
                        FlansMod.logger.error("Could not read {}", new Object[]{file.getName(), e});
                    }
                }
            }
        }
    }

    private void loadTypesArchive(String packName, File contentPack) {
        try {
            ZipEntry zipEntry;
            ZipFile zip = new ZipFile(contentPack);
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(contentPack));
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipStream));
            block4: do {
                if ((zipEntry = zipStream.getNextEntry()) == null || zipEntry.isDirectory()) continue;
                TypeFile typeFile = null;
                for (EnumType type : EnumType.values()) {
                    if (!zipEntry.getName().startsWith(type.folderNames[0] + "/") || zipEntry.getName().split(type.folderNames[0] + "/").length <= 1 || zipEntry.getName().split(type.folderNames[0] + "/")[1].length() <= 0) continue;
                    String[] splitName = zipEntry.getName().split("/");
                    typeFile = new TypeFile(type, splitName[splitName.length - 1].split("\\.")[0], packName);
                }
                if (typeFile == null) continue;
                while (true) {
                    String line;
                    try {
                        line = reader.readLine();
                    }
                    catch (Exception e) {
                        continue block4;
                    }
                    if (line == null) continue block4;
                    typeFile.lines.add(line);
                }
            } while (zipEntry != null);
            reader.close();
            zip.close();
            zipStream.close();
        }
        catch (IOException e) {
            FlansMod.logger.error("Could not read zip archive {}", new Object[]{contentPack.getName(), e});
        }
    }

    public boolean reloadResources() {
        return this.reloadResources;
    }

    private static class ContentPackFlans
    implements IFlansContentProvider {
        public final String directory;
        public final File source;

        public ContentPackFlans(String directory, File source) {
            this.directory = directory;
            this.source = source;
        }

        @Override
        public String getContentDirectory() {
            return this.directory;
        }

        @Override
        public void registerModelLocations() {
            try {
                if (this.source.isDirectory()) {
                    File redirectFile = new File(this.source, "redirect.txt");
                    if (redirectFile.exists()) {
                        BufferedReader reader = new BufferedReader(new FileReader(redirectFile));
                        String src = reader.readLine();
                        String destination = reader.readLine();
                        if (src != null && destination != null) {
                            FlansMod.registerModelLocation(src, destination);
                        }
                    }
                } else if (zipJar.matcher(this.source.getName()).matches()) {
                    ZipFile zip = new ZipFile(this.source);
                    ZipEntry entry = zip.getEntry("redirect.txt");
                    if (entry != null && !entry.isDirectory()) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                        String src = reader.readLine();
                        String destination = reader.readLine();
                        if (src != null && destination != null) {
                            FlansMod.registerModelLocation(src, destination);
                        }
                        reader.close();
                    }
                    zip.close();
                }
            }
            catch (IOException ex) {
                FlansMod.logger.error("Could not register model locations", (Throwable)ex);
            }
        }
    }

    private static class ContentPackMod
    implements IFlansContentProvider {
        public final IFlansContentProvider provider;
        public final ModContainer container;

        public ContentPackMod(ModContainer container, IFlansContentProvider provider) {
            this.container = container;
            this.provider = provider;
        }

        @Override
        public String getContentDirectory() {
            return this.provider.getContentDirectory();
        }

        @Override
        public void registerModelLocations() {
            this.provider.registerModelLocations();
        }
    }
}

