/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.Color;
import java.awt.geom.Point2D;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.map.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DrawEntityStep
implements DrawStep {
    static final Color labelBg = Color.black;
    static final int labelBgAlpha = 180;
    static final Color labelFg = Color.white;
    static final int labelFgAlpha = 225;
    boolean hideSneaks;
    boolean showHeading;
    Minecraft minecraft;
    EntityDTO entityDTO;
    TextureImpl texture;
    TextureImpl locatorTexture;
    EntityLivingBase entityLiving;
    boolean flip;

    private DrawEntityStep(EntityDTO entityDTO) {
        this.hideSneaks = JourneyMap.getCoreProperties().hideSneakingEntities.get();
        this.showHeading = true;
        this.minecraft = Minecraft.func_71410_x();
        this.entityDTO = entityDTO;
        this.entityLiving = entityDTO.entityLiving;
    }

    public void update(boolean flip, TextureImpl locatorTexture, TextureImpl texture, boolean showHeading) {
        this.locatorTexture = locatorTexture;
        this.texture = texture;
        this.flip = flip;
        this.showHeading = showHeading;
    }

    @Override
    public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        if (this.entityLiving == null || this.entityLiving.field_70128_L || this.entityLiving.func_98034_c((EntityPlayer)this.minecraft.field_71439_g) || !this.entityLiving.field_70175_ag || this.hideSneaks && this.entityLiving.func_70093_af()) {
            return;
        }
        Point2D.Double pixel = gridRenderer.getPixel(this.entityDTO.entityLiving.field_70165_t, this.entityDTO.entityLiving.field_70161_v);
        if (pixel != null) {
            double heading = this.entityDTO.entityLiving.field_70759_as;
            double drawX = ((Point2D)pixel).getX() + xOffset;
            double drawY = ((Point2D)pixel).getY() + yOffset;
            float alpha = 1.0f;
            if (this.entityLiving.field_70163_u > this.minecraft.field_71439_g.field_70163_u) {
                alpha = 1.0f - Math.max(0.1f, (float)((this.entityLiving.field_70163_u - this.minecraft.field_71439_g.field_70163_u) / 32.0));
            }
            if (this.entityDTO.entityLiving instanceof EntityPlayer) {
                int blockSize = (int)Math.pow(2.0, gridRenderer.getZoom());
                float labelOffset = this.texture != null ? (float)(this.texture.getHeight() / blockSize) : 0.0f;
                this.drawPlayer(drawX, drawY, gridRenderer, alpha, heading, drawScale, fontScale, rotation);
            } else {
                this.drawCreature(drawX, drawY, gridRenderer, alpha, heading, drawScale, fontScale, rotation);
            }
        }
    }

    private void drawPlayer(double drawX, double drawY, GridRenderer gridRenderer, float alpha, double heading, float drawScale, double fontScale, double rotation) {
        if (this.locatorTexture != null && this.showHeading) {
            DrawUtil.drawEntity(drawX, drawY, heading, false, this.locatorTexture, alpha, drawScale, rotation);
        }
        if (this.texture != null) {
            DrawUtil.drawEntity(drawX, drawY, heading, true, this.texture, alpha, drawScale * 0.75f, rotation);
        }
        int labelOffset = this.texture == null ? 0 : (rotation == 0.0 ? -this.texture.getHeight() / 2 : this.texture.getHeight() / 2);
        Point2D labelPoint = gridRenderer.shiftWindowPosition(drawX, drawY, 0, -labelOffset);
        Team team = this.entityLiving.func_96124_cp();
        if (team == null || !(this.entityLiving instanceof EntityPlayer)) {
            DrawUtil.drawLabel(this.entityDTO.entityLiving.func_70005_c_(), labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, Color.black, 205, Color.green, 255, fontScale, false, rotation);
        } else {
            String playerName = ScorePlayerTeam.func_96667_a((Team)this.entityLiving.func_96124_cp(), (String)((EntityPlayer)this.entityLiving).getDisplayName());
            DrawUtil.drawLabel(playerName, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, Color.black, 205, Color.white, 255, fontScale, false, rotation);
        }
    }

    private void drawCreature(double drawX, double drawY, GridRenderer gridRenderer, float alpha, double heading, float drawScale, double fontScale, double rotation) {
        int labelOffset;
        Math.min(1.0f, Math.max(0.0f, (float)(16.0 - (this.entityLiving.field_70163_u - this.minecraft.field_71439_g.field_70163_u))));
        if (this.locatorTexture != null && this.showHeading) {
            DrawUtil.drawEntity(drawX, drawY, heading, false, this.locatorTexture, alpha, drawScale, rotation);
        }
        int n = this.texture == null ? 8 : (labelOffset = rotation == 0.0 ? this.texture.getHeight() : -this.texture.getHeight());
        if (this.entityDTO.customName != null) {
            Point2D labelPoint = gridRenderer.shiftWindowPosition(drawX, drawY, 0, labelOffset);
            DrawUtil.drawCenteredLabel(this.entityDTO.customName, labelPoint.getX(), labelPoint.getY(), labelBg, 180, Color.white, 225, fontScale, rotation);
        }
        if (this.texture != null) {
            DrawUtil.drawEntity(drawX, drawY, heading, true, this.texture, alpha, drawScale, rotation);
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<EntityDTO, DrawEntityStep> {
        public DrawEntityStep load(EntityDTO entityDTO) throws Exception {
            return new DrawEntityStep(entityDTO);
        }
    }
}

