/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.EnumSkyBlock;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;

public class Stratum {
    private static AtomicInteger IDGEN = new AtomicInteger(0);
    private final int id = IDGEN.incrementAndGet();
    private ChunkMD chunkMd;
    private BlockMD blockMD;
    private int x;
    private int y;
    private int z;
    private int lightLevel;
    private int lightOpacity;
    private boolean isWater;
    private Integer dayColor;
    private Integer nightColor;
    private Integer caveColor;
    private boolean uninitialized = true;

    Stratum() {
    }

    Stratum set(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z, Integer lightLevel) {
        if (chunkMd == null || blockMD == null) {
            throw new IllegalStateException(String.format("Can't have nulls: %s, %s", chunkMd, blockMD));
        }
        this.setChunkMd(chunkMd);
        this.setBlockMD(blockMD);
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setWater(blockMD.isWater());
        if (blockMD.isLava()) {
            this.setLightLevel(14);
        } else {
            this.setLightLevel(lightLevel != null ? lightLevel.intValue() : chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, y + 1, z));
        }
        this.setLightOpacity(chunkMd.getLightOpacity(blockMD, x, y, z));
        this.setDayColor(null);
        this.setNightColor(null);
        this.setCaveColor(null);
        this.uninitialized = false;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stratum that = (Stratum)o;
        if (this.getY() != that.getY()) {
            return false;
        }
        return !(this.getBlockMD() != null ? !this.getBlockMD().equals(that.getBlockMD()) : that.getBlockMD() != null);
    }

    public int hashCode() {
        int result = this.getBlockMD() != null ? this.getBlockMD().hashCode() : 0;
        result = 31 * result + this.getY();
        return result;
    }

    public String toString() {
        String common = "Stratum{id=" + this.id + ", uninitialized=" + this.uninitialized + "%s}";
        if (!this.uninitialized) {
            return String.format(common, ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", lightLevel=" + this.getLightLevel() + ", lightOpacity=" + this.getLightOpacity() + ", isWater=" + this.isWater() + ", dayColor=" + (this.getDayColor() == null ? null : new Color(this.getDayColor())) + ", nightColor=" + (this.getNightColor() == null ? null : new Color(this.getNightColor())) + ", caveColor=" + (this.getCaveColor() == null ? null : new Color(this.getCaveColor())));
        }
        return String.format(common, "");
    }

    public ChunkMD getChunkMd() {
        return this.chunkMd;
    }

    public void setChunkMd(ChunkMD chunkMd) {
        this.chunkMd = chunkMd;
    }

    public BlockMD getBlockMD() {
        return this.blockMD;
    }

    public void setBlockMD(BlockMD blockMD) {
        this.blockMD = blockMD;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
    }

    public int getLightOpacity() {
        return this.lightOpacity;
    }

    public void setLightOpacity(int lightOpacity) {
        this.lightOpacity = lightOpacity;
    }

    public boolean isWater() {
        return this.isWater;
    }

    public void setWater(boolean isWater) {
        this.isWater = isWater;
    }

    public Integer getDayColor() {
        return this.dayColor;
    }

    public void setDayColor(Integer dayColor) {
        this.dayColor = dayColor;
    }

    public Integer getNightColor() {
        return this.nightColor;
    }

    public void setNightColor(Integer nightColor) {
        this.nightColor = nightColor;
    }

    public Integer getCaveColor() {
        return this.caveColor;
    }

    public void setCaveColor(Integer caveColor) {
        this.caveColor = caveColor;
    }

    public boolean isUninitialized() {
        return this.uninitialized;
    }

    public void clear() {
        this.uninitialized = true;
        this.setChunkMd(null);
        this.setBlockMD(null);
        this.setX(0);
        this.setY(-1);
        this.setZ(0);
        this.setWater(false);
        this.setLightLevel(-1);
        this.setLightOpacity(-1);
        this.setDayColor(null);
        this.setNightColor(null);
        this.setCaveColor(null);
    }
}

