/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Since;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockMD;

public class ColorPalette {
    public static final String HELP_PAGE = "http://journeymap.info/help/wiki/Color_Palette";
    public static final String SAMPLE_STANDARD_PATH = ".minecraft/journeymap/";
    public static final String SAMPLE_WORLD_PATH = ".minecraft/journeymap/data/*/worldname/";
    public static final String JSON_FILENAME = "colorpalette.json";
    public static final String HTML_FILENAME = "colorpalette.html";
    public static final String VARIABLE = "var colorpalette=";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final int VERSION = 2;
    public static final Gson GSON = new GsonBuilder().setVersion(2.0).setPrettyPrinting().create();
    @Since(value=1.0)
    String name;
    @Since(value=1.0)
    String generated;
    @Since(value=1.0)
    String[] description;
    @Since(value=1.0)
    boolean permanent;
    @Since(value=1.0)
    String resourcePacks;
    @Since(value=2.0)
    String modNames;
    @Since(value=1.0)
    ArrayList<BlockColor> basicColors = new ArrayList(0);
    @Since(value=1.0)
    LinkedHashMap<String, ArrayList<BlockColor>> biomeColors = new LinkedHashMap(60);
    private transient File origin;

    ColorPalette() {
    }

    ColorPalette(String resourcePacks, String modNames, HashMap<BlockMD, Color> basicColorMap, HashMap<String, HashMap<BlockMD, Color>> biomeColorMap) {
        this.name = Constants.getString("jm.colorpalette.file_title");
        this.generated = String.format("Generated using %s for %s on %s", JourneyMap.MOD_NAME, "1.7.10", new Date());
        this.resourcePacks = resourcePacks;
        this.modNames = modNames;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(Constants.getString("jm.colorpalette.file_header_1"));
        lines.add(Constants.getString("jm.colorpalette.file_header_2", HTML_FILENAME));
        lines.add(Constants.getString("jm.colorpalette.file_header_3", JSON_FILENAME, SAMPLE_WORLD_PATH));
        lines.add(Constants.getString("jm.colorpalette.file_header_4", JSON_FILENAME, SAMPLE_STANDARD_PATH));
        lines.add(Constants.getString("jm.config.file_header_5", HELP_PAGE));
        this.description = lines.toArray(new String[4]);
        this.basicColors = this.toList(basicColorMap);
        ArrayList<String> biomeNames = new ArrayList<String>(biomeColorMap.keySet());
        Collections.sort(biomeNames);
        for (String biomeName : biomeNames) {
            ArrayList<BlockColor> list = this.toList(biomeColorMap.get(biomeName));
            this.biomeColors.put(biomeName, list);
        }
    }

    public static ColorPalette getActiveColorPalette() {
        ColorPalette palette;
        ColorPalette palette2;
        String resourcePacks = Constants.getResourcePackNames();
        String modNames = Constants.getModNames();
        File worldPaletteFile = ColorPalette.getWorldPaletteFile();
        if (worldPaletteFile.canRead() && (palette2 = ColorPalette.loadFromFile(worldPaletteFile)) != null) {
            return palette2;
        }
        File standardPaletteFile = ColorPalette.getStandardPaletteFile();
        if (standardPaletteFile.canRead() && (palette = ColorPalette.loadFromFile(standardPaletteFile)) != null) {
            if (palette.isPermanent()) {
                JourneyMap.getLogger().info("Existing color palette is set to be permanent.");
                return palette;
            }
            if (resourcePacks.equals(palette.resourcePacks)) {
                if (modNames.equals(palette.modNames)) {
                    JourneyMap.getLogger().info("Existing color palette's resource packs and mod names match current loadout.");
                    return palette;
                }
                JourneyMap.getLogger().warn("Existing color palette's mods no longer match current loadout.");
                JourneyMap.getLogger().info(String.format("WAS: %s\nNOW: %s", palette.modNames, modNames));
            } else {
                JourneyMap.getLogger().warn("Existing color palette's resource packs no longer match current loadout.");
                JourneyMap.getLogger().info(String.format("WAS: %s\nNOW: %s", palette.resourcePacks, resourcePacks));
            }
        }
        return null;
    }

    static File getWorldPaletteFile() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        return new File(FileHandler.getJMWorldDir(mc), JSON_FILENAME);
    }

    static File getStandardPaletteFile() {
        return new File(FileHandler.getJourneyMapDir(), JSON_FILENAME);
    }

    protected static ColorPalette loadFromFile(File file) {
        String jsonString = null;
        try {
            jsonString = Files.toString((File)file, (Charset)UTF8).replaceFirst(VARIABLE, "");
            ColorPalette palette = (ColorPalette)GSON.fromJson(jsonString, ColorPalette.class);
            palette.origin = file;
            palette.getOriginHtml(true, true);
            return palette;
        }
        catch (Throwable e) {
            ChatLog.announceError(Constants.getString("jm.colorpalette.file_error", file.getPath()));
            try {
                file.renameTo(new File(file.getParentFile(), file.getName() + ".bad"));
            }
            catch (Exception e2) {
                JourneyMap.getLogger().error("Couldn't rename bad palette file: " + e2);
            }
            return null;
        }
    }

    private String substituteValueInContents(String contents, String key, Object ... params) {
        String token = String.format("\\$%s\\$", key);
        return contents.replaceAll(token, Matcher.quoteReplacement(Constants.getString(key, params)));
    }

    private ArrayList<BlockColor> toList(HashMap<BlockMD, Color> map) {
        ArrayList<BlockColor> list = new ArrayList<BlockColor>(map.size());
        for (Map.Entry<BlockMD, Color> entry : map.entrySet()) {
            list.add(new BlockColor(entry.getKey(), entry.getValue()));
        }
        Collections.sort(list);
        return list;
    }

    public boolean writeToFile(boolean standard) {
        File palleteFile = null;
        try {
            palleteFile = standard ? ColorPalette.getStandardPaletteFile() : ColorPalette.getWorldPaletteFile();
            Files.write((CharSequence)(VARIABLE + GSON.toJson((Object)this)), (File)palleteFile, (Charset)UTF8);
            this.origin = palleteFile;
            this.getOriginHtml(true, true);
            return true;
        }
        catch (Exception e) {
            JourneyMap.getLogger().error(String.format("Can't save color pallete file %s: %s", palleteFile, LogFormatter.toString(e)));
            return false;
        }
    }

    private HashMap<BlockMD, Color> listToMap(ArrayList<BlockColor> list) {
        HashMap<BlockMD, Color> map = new HashMap<BlockMD, Color>(list.size());
        for (BlockColor blockColor : list) {
            GameRegistry.UniqueIdentifier uid = new GameRegistry.UniqueIdentifier(blockColor.uid);
            Block block = GameRegistry.findBlock((String)uid.modId, (String)uid.name);
            if (block == null) {
                JourneyMap.getLogger().warn("Block referenced in Color Palette is not registered: " + uid);
                continue;
            }
            BlockMD blockMD = DataCache.instance().getBlockMD(block, blockColor.meta);
            if (blockMD.hasFlag(BlockMD.Flag.Transparency)) {
                Float alpha = blockColor.alpha;
                blockMD.setAlpha(alpha != null ? alpha.floatValue() : 1.0f);
            }
            int color = Integer.parseInt(blockColor.color.replaceFirst("#", ""), 16);
            map.put(blockMD, new Color(color));
        }
        return map;
    }

    public HashMap<BlockMD, Color> getBasicColorMap() {
        return this.listToMap(this.basicColors);
    }

    public HashMap<String, HashMap<BlockMD, Color>> getBiomeColorMap() {
        HashMap<String, HashMap<BlockMD, Color>> map = new HashMap<String, HashMap<BlockMD, Color>>();
        for (String biome : this.biomeColors.keySet()) {
            map.put(biome, this.listToMap(this.biomeColors.get(biome)));
        }
        return map;
    }

    public File getOrigin() {
        return this.origin;
    }

    public File getOriginHtml(boolean createIfMissing, boolean overwriteExisting) {
        try {
            if (this.origin == null) {
                return null;
            }
            File htmlFile = new File(this.origin.getParentFile(), HTML_FILENAME);
            if (!htmlFile.exists() && createIfMissing || overwriteExisting) {
                htmlFile = FileHandler.copyColorPaletteHtmlFile(this.origin.getParentFile(), HTML_FILENAME);
                String htmlString = Files.toString((File)htmlFile, (Charset)UTF8);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.file_title", new Object[0]);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.file_missing_data", JSON_FILENAME);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.resource_packs", new Object[0]);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.mods", new Object[0]);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.basic_colors", new Object[0]);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.biome_colors", new Object[0]);
                Files.write((CharSequence)htmlString, (File)htmlFile, (Charset)UTF8);
            }
            return htmlFile;
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Can't get colorpalette.html: " + t);
            return null;
        }
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public boolean isStandard() {
        return this.origin != null && this.origin.getParentFile().getAbsoluteFile().equals(FileHandler.getJourneyMapDir().getAbsoluteFile());
    }

    public int size() {
        int count = this.basicColors.size();
        if (this.biomeColors.size() > 0) {
            count += this.biomeColors.size() * this.biomeColors.entrySet().iterator().next().getValue().size();
        }
        return count;
    }

    public String toString() {
        return "ColorPalette[" + this.resourcePacks + "]";
    }

    class BlockColor
    implements Comparable<BlockColor> {
        @Since(value=1.0)
        String name;
        @Since(value=1.0)
        String uid;
        @Since(value=1.0)
        int meta;
        @Since(value=1.0)
        String color;
        @Since(value=1.0)
        Float alpha;

        BlockColor(BlockMD blockMD, Color awtColor) {
            this.name = blockMD.getName();
            this.uid = GameData.getBlockRegistry().func_148750_c((Object)blockMD.getBlock());
            this.meta = blockMD.meta;
            this.color = String.format("#%02x%02x%02x", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
            if (blockMD.getAlpha() < 1.0f) {
                this.alpha = Float.valueOf(blockMD.getAlpha());
            }
        }

        @Override
        public int compareTo(BlockColor o) {
            int result = this.name.compareTo(o.name);
            if (result != 0) {
                return result;
            }
            result = this.uid.compareTo(o.uid);
            if (result != 0) {
                return result;
            }
            return Integer.compare(this.meta, o.meta);
        }
    }
}

