/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.Version;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.thread.JMThreadFactory;

public class VersionCheck {
    private static volatile ExecutorService executorService;
    private static volatile Boolean updateCheckEnabled;
    private static volatile Boolean versionIsCurrent;
    private static volatile Boolean versionIsChecked;
    private static volatile String versionAvailable;

    public static Boolean getVersionIsCurrent() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsCurrent;
    }

    public static Boolean getVersionIsChecked() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsChecked;
    }

    public static String getVersionAvailable() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionAvailable;
    }

    private static synchronized void checkVersion() {
        versionIsChecked = false;
        versionIsCurrent = true;
        versionAvailable = "0";
        if (!updateCheckEnabled.booleanValue()) {
            JourneyMap.getLogger().info("Update check disabled in properties file.");
        } else {
            executorService = Executors.newSingleThreadExecutor(new JMThreadFactory("VersionCheck"));
            executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JourneyMap.getLogger().info("Checking for updated version: https://dl.dropboxusercontent.com/u/38077766/JourneyMap/journeymap-versions.json");
                    InputStreamReader in = null;
                    HttpsURLConnection connection = null;
                    String rawResponse = null;
                    try {
                        URL uri = URI.create("https://dl.dropboxusercontent.com/u/38077766/JourneyMap/journeymap-versions.json").toURL();
                        connection = (HttpsURLConnection)uri.openConnection();
                        connection.setConnectTimeout(6000);
                        connection.setReadTimeout(6000);
                        connection.setRequestMethod("GET");
                        connection.setRequestProperty("User-Agent", VersionCheck.createUserAgent());
                        in = new InputStreamReader(uri.openStream());
                        rawResponse = CharStreams.toString((Readable)in);
                        Gson gson = new GsonBuilder().create();
                        VersionData versionData = (VersionData)gson.fromJson(rawResponse, VersionData.class);
                        if (versionData.versions != null) {
                            for (VersionLine versionLine : versionData.versions) {
                                if (!"1.7.10".equals(versionLine.minecraft)) continue;
                                versionAvailable = versionLine.journeymap;
                                versionIsCurrent = VersionCheck.isCurrent(JourneyMap.JM_VERSION.toString(), versionAvailable);
                                versionIsChecked = true;
                                break;
                            }
                        } else {
                            JourneyMap.getLogger().warn("Version URL had no data!");
                        }
                        JourneyMap.getLogger().info(String.format("Current version online: JourneyMap %s for Minecraft %s on %s", versionAvailable, "1.7.10", "http://journeymap.info/download"));
                    }
                    catch (Throwable e) {
                        JourneyMap.getLogger().error("Could not check version URL", e);
                        updateCheckEnabled = false;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                                executorService.shutdown();
                                executorService = null;
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (!versionIsCurrent.booleanValue()) {
                        // empty if block
                    }
                }
            });
        }
    }

    private static boolean isCurrent(String thisVersionStr, String availableVersionStr) {
        if (thisVersionStr.equals(availableVersionStr)) {
            return true;
        }
        Version thisVersion = Version.from(thisVersionStr, null);
        Version availableVersion = Version.from(availableVersionStr, null);
        return !availableVersion.isNewerThan(thisVersion);
    }

    private static String createUserAgent() {
        String agent = null;
        try {
            String lang;
            String arch;
            String version;
            String os = System.getProperty("os.name");
            if (os == null) {
                os = "";
            }
            if ((version = System.getProperty("os.version")) == null) {
                version = "";
            }
            if ((arch = System.getProperty("os.arch")) == null) {
                arch = "";
            }
            if (arch.equals("amd64")) {
                arch = "WOW64";
            }
            if ((lang = String.format("%s_%s", System.getProperty("user.language"), System.getProperty("user.country"))).contains("null")) {
                lang = FMLClientHandler.instance().getCurrentLanguage();
            }
            if (os.startsWith("Mac")) {
                version = version.replace(".", "_");
                agent = String.format("Mozilla/5.0 (Macintosh; U; Intel Mac OS X %s; %s)", version, lang);
            } else {
                agent = os.startsWith("Win") ? String.format("Mozilla/5.0 (Windows; U; Windows NT %s; %s; %s)", version, arch, lang) : (os.startsWith("Linux") ? String.format("Mozilla/5.0 (Linux; U; Linux %s; %s; %s)", version, arch, lang) : String.format("Mozilla/5.0 (%s; U; %s %s; %s, %s)", os, os, version, arch, lang));
            }
        }
        catch (Throwable t) {
            agent = "Mozilla/5.0 (Unknown)";
        }
        return agent;
    }

    public static void launchWebsite() {
        String url = "http://journeymap.info/download";
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Throwable e) {
            JourneyMap.getLogger().error("Could not launch browser with URL: " + url, new Object[]{LogFormatter.toString(e)});
        }
    }

    static {
        updateCheckEnabled = JourneyMap.getCoreProperties().checkUpdates.get();
        versionIsCurrent = true;
    }

    class VersionLine {
        String minecraft;
        String journeymap;

        VersionLine() {
        }
    }

    class VersionData {
        VersionLine[] versions;

        VersionData() {
        }
    }
}

