/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util;

import cpw.mods.fml.client.FMLClientHandler;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TextureHelper {
    private static TextureHelper INSTANCE;

    private TextureHelper() {
    }

    public static TextureHelper instance() {
        return INSTANCE == null ? (INSTANCE = new TextureHelper()) : INSTANCE;
    }

    public ResourceLocation getHeldBlockTexture(EntityPlayer player, World worldIn, int x, int y, int z) {
        try {
            Vec3 look = player.func_70040_Z();
            int side = TextureHelper.getFacingFromVector((float)(-look.field_72450_a), (float)(-look.field_72448_b), (float)(-look.field_72449_c));
            Block block = Block.func_149634_a((Item)player.func_70694_bm().func_77973_b());
            String textureName = block.func_149733_h(side).func_94215_i();
            String resourceName = this.textureNameToResourceName(textureName);
            ResourceLocation ret = new ResourceLocation(resourceName);
            FMLClientHandler.instance().getClient().func_110442_L().func_110536_a(ret);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getFacingFromVector(float x, float y, float z) {
        EnumFacing enumfacing = EnumFacing.NORTH;
        float f = Float.MIN_VALUE;
        for (EnumFacing enumfacing1 : EnumFacing.values()) {
            float f1 = x * (float)enumfacing1.func_82601_c() + y * (float)enumfacing1.func_96559_d() + z * (float)enumfacing1.func_82599_e();
            if (!(f1 > f)) continue;
            f = f1;
            enumfacing = enumfacing1;
        }
        return enumfacing.ordinal();
    }

    private String textureNameToResourceName(String textureName) {
        String[] split;
        if (textureName.equals("missingno")) {
            return null;
        }
        if (textureName.contains(":")) {
            split = textureName.split(":");
            if (split.length != 2) {
                return null;
            }
        } else {
            split = new String[]{"minecraft", textureName};
        }
        if (!split[1].startsWith("textures/blocks/")) {
            if (!split[1].startsWith("blocks/")) {
                split[1] = "blocks/" + split[1];
            }
            split[1] = "textures/" + split[1];
        }
        if (!TextureHelper.endsWithIgnoreCase(split[1], ".png")) {
            split[1] = split[1] + ".png";
        }
        return split[0] + ":" + split[1];
    }

    public boolean setTexture(int x, int y, int z) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        ResourceLocation texture = this.getHeldBlockTexture((EntityPlayer)player, (World)world, x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (texture == null || !(tileEntity instanceof SuperPostPostTile)) {
            return false;
        }
        SuperPostPostTile superTile = (SuperPostPostTile)tileEntity;
        superTile.getPaintObject().setTexture(texture);
        superTile.setPaintObject(null);
        superTile.setAwaitingPaint(false);
        ((SuperPostPost)superTile.func_145838_q()).sendPostBasesToServer(superTile);
        return true;
    }

    private static boolean endsWithIgnoreCase(String str1, String str2) {
        return str1.length() < str2.length() || str1.substring(str1.length() - str2.length()).equalsIgnoreCase(str2);
    }
}

