/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.modIntegration;

import cpw.mods.fml.common.Loader;
import gollorum.signpost.modIntegration.ModHandler;
import gollorum.signpost.modIntegration.WaystonesModHandler;
import gollorum.signpost.util.StonedHashSet;
import gollorum.signpost.util.collections.Lurchsauna;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;

public class SignpostAdapter {
    public static final SignpostAdapter INSTANCE = new SignpostAdapter();
    public static final String WAYSTONES_MOD_ID = "waystones";
    private final Set<ModHandler> handlers = new Lurchsauna<ModHandler>();

    private SignpostAdapter() {
        if (Loader.isModLoaded((String)WAYSTONES_MOD_ID)) {
            this.registerModHandler(new WaystonesModHandler());
        }
    }

    public boolean registerModHandler(ModHandler handler) {
        return this.handlers.add(handler);
    }

    public boolean removeModHandler(ModHandler handler) {
        return this.handlers.remove(handler);
    }

    public StonedHashSet getExternalBaseInfos() {
        StonedHashSet ret = new StonedHashSet();
        for (ModHandler now : this.handlers) {
            ret.addAll(now.getAllBaseInfos());
        }
        return ret;
    }

    public StonedHashSet getExternalPlayerBaseInfos(EntityPlayer player) {
        StonedHashSet ret = new StonedHashSet();
        for (ModHandler now : this.handlers) {
            ret.addAll(now.getAllBaseInfosByPlayer(player));
        }
        return ret;
    }
}

