/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.api.ElegantPacket;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.impl.Config;
import hohserg.elegant.networking.impl.IPacketProvider;
import hohserg.elegant.networking.impl.ISerializerBase;
import hohserg.elegant.networking.impl.InvalidPacketProviderException;
import hohserg.elegant.networking.impl.MultipleRuntimeException;
import hohserg.elegant.networking.impl.Registry;
import hohserg.elegant.networking.impl.SerializerMark;
import hohserg.elegant.networking.utils.ChannelValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public class Init {
    private final Consumer<String> msgPrintln;
    private final Consumer<String> warnPrintln;
    private final Consumer<String> channelNameConsumer;

    public static void initPackets(Consumer<String> msgPrintln, Consumer<String> warnPrintln, Consumer<String> channelNameConsumer, Config config) {
        msgPrintln.accept("Used " + config.getBackgroundPacketSystem().name() + " as background packet system");
        Init instance = new Init(msgPrintln, warnPrintln, channelNameConsumer);
        instance.registerAllSerializers();
        instance.registerAllPackets();
    }

    private Init(Consumer<String> msgPrintln, Consumer<String> warnPrintln, Consumer<String> channelNameConsumer) {
        this.msgPrintln = msgPrintln;
        this.warnPrintln = warnPrintln;
        this.channelNameConsumer = channelNameConsumer;
    }

    private static void handleErrors(String msg, Consumer<List<Throwable>> f) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        f.accept(errors);
        if (errors.size() > 0) {
            throw new MultipleRuntimeException(msg, errors);
        }
    }

    private void registerAllSerializers() {
        Init.handleErrors("Trouble while indexing serializers", errors -> {
            Iterator<ISerializerBase> iterator = ServiceLoader.load(ISerializerBase.class).iterator();
            while (iterator.hasNext()) {
                try {
                    ISerializerBase serializer = iterator.next();
                    Registry.registerSerializer(this.getPacketClass(serializer), serializer);
                }
                catch (TypeNotPresentException e) {
                    this.warnPrintln.accept("Broken serializer. It's normal in dev environment. Caused by: " + e.toString());
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        });
    }

    private void registerAllPackets() {
        HashMap<String, List> channelToPackets = new HashMap<String, List>();
        Init.handleErrors("Trouble while indexing elegant packets", errors -> {
            Iterator<IPacketProvider> iterator = ServiceLoader.load(IPacketProvider.class).iterator();
            while (iterator.hasNext()) {
                try {
                    IPacketProvider packetProvider = iterator.next();
                    Class<? extends IByteBufSerializable> packetClass = packetProvider.getPacketClass();
                    if (packetClass == null) {
                        throw new InvalidPacketProviderException(packetProvider, "Provided class is null");
                    }
                    if (!IByteBufSerializable.class.isAssignableFrom(packetClass)) {
                        throw new InvalidPacketProviderException(packetProvider, "Provided class is not implementation of IByteBufSerializable");
                    }
                    channelToPackets.computeIfAbsent(this.getPacketChannel(packetProvider), __ -> new ArrayList(3)).add(packetClass);
                }
                catch (InvalidPacketProviderException | NoClassDefFoundError | TypeNotPresentException e) {
                    this.warnPrintln.accept("Broken packet provider. It's normal in dev environment. Caused by: " + e.toString());
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        });
        channelToPackets.forEach((channel, packets) -> {
            String actualChannel = ChannelValidator.validateChannel(channel, this.warnPrintln);
            this.printStarted(actualChannel);
            Init.handleErrors("Failed to register packets for channel " + actualChannel, errors -> {
                try {
                    for (int i = 0; i < packets.size(); ++i) {
                        Class packetClass = (Class)packets.get(i);
                        int packetId = i + 1;
                        Registry.register(actualChannel, packetId, packetClass);
                        this.printRegistered(actualChannel, packetClass, packetId);
                    }
                    this.channelNameConsumer.accept(actualChannel);
                    this.printSuccessfully(actualChannel);
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            });
        });
    }

    private void printStarted(String channel) {
        this.msgPrintln.accept("Starting registration of elegant packets for channel " + channel);
    }

    private void printRegistered(String channel, Class<? extends IByteBufSerializable> packetClass, int packetId) {
        this.msgPrintln.accept("Registered packet " + packetClass.getSimpleName() + " for channel " + channel + " with id " + packetId);
    }

    private void printSuccessfully(String channel) {
        this.msgPrintln.accept("Successfully registered packets for channel " + channel);
    }

    private String getPacketChannel(IPacketProvider packetProvider) {
        ElegantPacket annotation = packetProvider.getPacketClass().getAnnotation(ElegantPacket.class);
        if (annotation == null) {
            throw new InvalidPacketProviderException(packetProvider, "Provided packet class is not marked by @ElegantPacket");
        }
        String annotatedChannel = annotation.channel();
        return this.trimChannel(annotatedChannel.equals("$modid") ? packetProvider.modid() : annotatedChannel, packetProvider.getPacketClass().getSimpleName());
    }

    private String trimChannel(String channel, String packetSimpleName) {
        if (channel.length() > 20) {
            this.warnPrintln.accept("Channel '" + channel + "' of packet '" + packetSimpleName + "' is longer that 20. Trimming");
            return channel.substring(0, 20);
        }
        return channel;
    }

    private Class<? extends IByteBufSerializable> getPacketClass(ISerializerBase serializer) {
        return Objects.requireNonNull(serializer.getClass().getAnnotation(SerializerMark.class), "Missed annotation @SerializerMark at serializer " + serializer).packetClass();
    }
}

