/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model.mod;

import com.google.common.base.Joiner;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.IIcon;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.mod.CarpentersBlocks;
import org.apache.logging.log4j.Logger;

public class ModBlockDelegate {
    public static final HashMap<GameRegistry.UniqueIdentifier, IModBlockHandler> Blocks = new HashMap();
    private static final HashMap<GameRegistry.UniqueIdentifier, AtomicInteger> Errors = new HashMap();
    private static final int ERROR_LIMIT = 25;
    private static Logger logger = JourneyMap.getLogger();

    private static void register(IModBlockHandler handler) {
        try {
            ArrayList<GameRegistry.UniqueIdentifier> success = new ArrayList<GameRegistry.UniqueIdentifier>();
            for (GameRegistry.UniqueIdentifier uid : handler.getBlockUids()) {
                if (uid == null || !ModBlockDelegate.register(handler, uid)) continue;
                success.add(uid);
            }
            if (success.size() > 0) {
                logger.info(String.format("Registered IModBlockHandler for: '%s'.", Joiner.on((String)", ").join(success)));
            }
        }
        catch (Throwable t) {
            String message = String.format("Couldn't register IModBlockHandler '%s': %s", Joiner.on((String)", ").join(handler.getBlockUids()), LogFormatter.toString(t));
            logger.error(message);
        }
    }

    private static boolean register(IModBlockHandler handler, GameRegistry.UniqueIdentifier uid) {
        if (uid == null) {
            throw new IllegalStateException("UID cannot be null");
        }
        if (Blocks.containsKey(uid)) {
            throw new IllegalStateException("UID already registered to " + Blocks.get(uid));
        }
        Blocks.put(uid, handler);
        Errors.put(uid, new AtomicInteger(0));
        return true;
    }

    public boolean canHandle(BlockMD blockMD) {
        return Blocks.containsKey(blockMD.uid);
    }

    public BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, int localX, int y, int localZ) {
        BlockMD delegatedBlockMD;
        block4: {
            delegatedBlockMD = null;
            try {
                IModBlockHandler handler = Blocks.get(blockMD.uid);
                if (handler != null) {
                    delegatedBlockMD = handler.handleBlock(chunkMD, blockMD, localX, y, localZ);
                }
            }
            catch (Throwable t) {
                int count = Errors.get(blockMD.uid).incrementAndGet();
                String message = String.format("Error (%s) handling block '%s': %s", count, blockMD.uid, LogFormatter.toString(t));
                logger.error(message);
                if (count < 25) break block4;
                logger.warn(String.format("Deregistering problematic IModBlockHandler for '%s'.", blockMD.uid));
                Blocks.remove(blockMD.uid);
            }
        }
        if (delegatedBlockMD == null) {
            delegatedBlockMD = blockMD;
        }
        return delegatedBlockMD;
    }

    public IIcon getIcon(BlockMD blockMD) {
        block3: {
            try {
                IModBlockHandler handler = Blocks.get(blockMD.uid);
                if (handler != null) {
                    return handler.getIcon(blockMD);
                }
            }
            catch (Throwable t) {
                int count = Errors.get(blockMD.uid).incrementAndGet();
                String message = String.format("Error (%s) from getIcon() on block '%s': %s", count, blockMD.uid, LogFormatter.toString(t));
                logger.error(message);
                if (count < 25) break block3;
                logger.warn(String.format("Deregistering problematic IModBlockHandler for '%s'.", blockMD.uid));
                Blocks.remove(blockMD.uid);
            }
        }
        return null;
    }

    static {
        ModBlockDelegate.register(new CarpentersBlocks.CommonHandler());
    }

    public static interface IModBlockHandler {
        public Collection<GameRegistry.UniqueIdentifier> getBlockUids();

        public IIcon getIcon(BlockMD var1);

        public BlockMD handleBlock(ChunkMD var1, BlockMD var2, int var3, int var4, int var5);
    }
}

