/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.cache.Cache;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.ChunkCoordIntPair;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.model.ChunkCoord;
import net.techbrew.journeymap.model.MapType;

public class RegionCoord
implements Comparable<RegionCoord> {
    public static final transient int SIZE = 5;
    private static final transient int chunkSqRt = (int)Math.pow(2.0, 5.0);
    private static final Cache<Integer, RegionCoord> cache = DataCache.instance().getRegionCoords();
    public final File worldDir;
    public final Path dimDir;
    public final int regionX;
    public final int regionZ;
    public final int dimension;

    public RegionCoord(File worldDir, int regionX, int regionZ, int dimension) {
        this.worldDir = worldDir;
        this.dimDir = RegionCoord.getDimPath(worldDir, dimension);
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.dimension = dimension;
    }

    public static RegionCoord fromChunkPos(File worldDir, MapType mapType, int chunkX, int chunkZ) {
        int regionX = RegionCoord.getRegionPos(chunkX);
        int regionZ = RegionCoord.getRegionPos(chunkZ);
        return RegionCoord.fromRegionPos(worldDir, regionX, regionZ, mapType.dimension);
    }

    public static RegionCoord fromRegionPos(File worldDir, int regionX, int regionZ, int dimension) {
        RegionCoord regionCoord = (RegionCoord)cache.getIfPresent((Object)RegionCoord.toHash(RegionCoord.getDimPath(worldDir, dimension), regionX, regionZ));
        if (regionCoord == null || regionX != regionCoord.regionX || regionZ != regionCoord.regionZ || dimension != regionCoord.dimension) {
            regionCoord = new RegionCoord(worldDir, regionX, regionZ, dimension);
            cache.put((Object)regionCoord.hashCode(), (Object)regionCoord);
        }
        return regionCoord;
    }

    public static Path getDimPath(File worldDir, int dimension) {
        return new File(worldDir, "DIM" + dimension).toPath();
    }

    public static int getMinChunkX(int rX) {
        return rX << 5;
    }

    public static int getMaxChunkX(int rX) {
        return RegionCoord.getMinChunkX(rX) + (int)Math.pow(2.0, 5.0) - 1;
    }

    public static int getMinChunkZ(int rZ) {
        return rZ << 5;
    }

    public static int getMaxChunkZ(int rZ) {
        return RegionCoord.getMinChunkZ(rZ) + (int)Math.pow(2.0, 5.0) - 1;
    }

    public static int getRegionPos(int chunkPos) {
        return chunkPos >> 5;
    }

    public static int toHash(Path dimDir, int regionX, int regionZ) {
        int result = dimDir.hashCode();
        result = 31 * result + regionX;
        result = 31 * result + regionZ;
        return result;
    }

    public int getXOffset(int chunkX) {
        if (chunkX >> 5 != this.regionX) {
            throw new IllegalArgumentException("chunkX " + chunkX + " out of bounds for regionX " + this.regionX);
        }
        int offset = chunkX % chunkSqRt * 16;
        if (offset < 0) {
            offset = chunkSqRt * 16 + offset;
        }
        return offset;
    }

    public int getZOffset(int chunkZ) {
        if (RegionCoord.getRegionPos(chunkZ) != this.regionZ) {
            throw new IllegalArgumentException("chunkZ " + chunkZ + " out of bounds for regionZ " + this.regionZ);
        }
        int offset = chunkZ % chunkSqRt * 16;
        if (offset < 0) {
            offset = chunkSqRt * 16 + offset;
        }
        return offset;
    }

    public int getMinChunkX() {
        return RegionCoord.getMinChunkX(this.regionX);
    }

    public int getMaxChunkX() {
        return RegionCoord.getMaxChunkX(this.regionX);
    }

    public int getMinChunkZ() {
        return RegionCoord.getMinChunkZ(this.regionZ);
    }

    public int getMaxChunkZ() {
        return RegionCoord.getMaxChunkZ(this.regionZ);
    }

    public ChunkCoord getMinChunkCoord(Integer vSlice) {
        return ChunkCoord.fromChunkPos(this.worldDir, MapType.from(vSlice, this.dimension), this.getMinChunkX(), this.getMinChunkZ());
    }

    public ChunkCoord getMaxChunkCoord(Integer vSlice) {
        return ChunkCoord.fromChunkPos(this.worldDir, MapType.from(vSlice, this.dimension), this.getMaxChunkX(), this.getMaxChunkZ());
    }

    public List<ChunkCoordIntPair> getChunkCoordsInRegion(Integer vSlice) {
        ArrayList<ChunkCoordIntPair> list = new ArrayList<ChunkCoordIntPair>(1024);
        ChunkCoord min = this.getMinChunkCoord(vSlice);
        ChunkCoord max = this.getMaxChunkCoord(vSlice);
        for (int x = min.chunkX; x <= max.chunkX; ++x) {
            for (int z = min.chunkZ; z <= max.chunkZ; ++z) {
                list.add(new ChunkCoordIntPair(x, z));
            }
        }
        return list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegionCoord [");
        builder.append(this.regionX);
        builder.append(",");
        builder.append(this.regionZ);
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionCoord that = (RegionCoord)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        if (this.regionX != that.regionX) {
            return false;
        }
        if (this.regionZ != that.regionZ) {
            return false;
        }
        if (!this.dimDir.equals(that.dimDir)) {
            return false;
        }
        return this.worldDir.equals(that.worldDir);
    }

    public int hashCode() {
        return RegionCoord.toHash(this.dimDir, this.regionX, this.regionZ);
    }

    @Override
    public int compareTo(RegionCoord o) {
        int cx = Double.compare(this.regionX, o.regionX);
        return cx == 0 ? Double.compare(this.regionZ, o.regionZ) : cx;
    }
}

