/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.forge.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.forge.event.EventHandlerManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.properties.WaypointProperties;
import net.techbrew.journeymap.waypoint.WaypointStore;

@SideOnly(value=Side.CLIENT)
public class StateTickHandler
implements EventHandlerManager.EventHandler {
    static boolean javaChecked = false;
    Minecraft mc = FMLClientHandler.instance().getClient();
    int counter = 0;
    private boolean deathpointCreated;

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumSet<EventHandlerManager.BusType> getBus() {
        return EnumSet.of(EventHandlerManager.BusType.FMLCommonHandlerBus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.mc.field_71424_I.func_76320_a("journeymap");
        if (this.mc.field_71439_g != null && this.mc.field_71439_g.field_70128_L) {
            if (!this.deathpointCreated) {
                this.deathpointCreated = true;
                this.createDeathpoint();
            }
        } else {
            this.deathpointCreated = false;
        }
        if (!javaChecked && this.mc.field_71439_g != null && !this.mc.field_71439_g.field_70128_L) {
            this.checkJava();
        }
        try {
            if (this.counter == 20) {
                this.mc.field_71424_I.func_76320_a("mainTasks");
                JourneyMap.getInstance().performMainThreadTasks();
                this.counter = 0;
                this.mc.field_71424_I.func_76319_b();
            } else if (this.counter == 10) {
                this.mc.field_71424_I.func_76320_a("multithreadTasks");
                if (JourneyMap.getInstance().isMapping().booleanValue() && this.mc.field_71441_e != null) {
                    JourneyMap.getInstance().performMultithreadTasks();
                }
                ++this.counter;
                this.mc.field_71424_I.func_76319_b();
            } else {
                ++this.counter;
            }
        }
        catch (Exception e) {
            JourneyMap.getLogger().warn("Error during performMainThreadTasks: " + e);
        }
        finally {
            this.mc.field_71424_I.func_76319_b();
        }
    }

    private void createDeathpoint() {
        try {
            boolean doCreate;
            EntityClientPlayerMP player = this.mc.field_71439_g;
            if (player == null) {
                JourneyMap.getLogger().error("Lost reference to player before Deathpoint could be created");
                return;
            }
            WaypointProperties waypointProperties = JourneyMap.getWaypointProperties();
            boolean bl = doCreate = waypointProperties.managerEnabled.get() && waypointProperties.createDeathpoints.get();
            if (doCreate) {
                ChunkCoordinates cc = new ChunkCoordinates(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
                Waypoint deathpoint = Waypoint.at(cc, Waypoint.Type.Death, player.field_70170_p.field_73011_w.field_76574_g);
                WaypointStore.instance().save(deathpoint);
            }
            JourneyMap.getLogger().info(String.format("%s died at x:%s, y:%s, z:%s. Deathpoint created: %s", player.func_70005_c_(), MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v), doCreate));
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Unexpected Error in createDeathpoint(): " + LogFormatter.toString(t));
        }
    }

    private void checkJava() {
        javaChecked = true;
        try {
            Class.forName("java.util.Objects");
        }
        catch (ClassNotFoundException e) {
            try {
                String error = I18n.func_135052_a((String)"jm.error.java6", (Object[])new Object[0]);
                FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(error));
                JourneyMap.getLogger().fatal("JourneyMap requires Java 7 or Java 8. Update your launcher profile to use a newer version of Java.");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            JourneyMap.disable();
        }
    }
}

