/*
 * Decompiled with CFR 0.152.
 */
package tennox.keyandcodelock.connection;

import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import tennox.keyandcodelock.IKeyAndCodeLockPacket;
import tennox.keyandcodelock.KeyAndCodeLock;
import tennox.keyandcodelock.blocks.BlockDoorLockedKey;
import tennox.keyandcodelock.blocks.BlockRedstoneLockKey;
import tennox.keyandcodelock.blocks.TileEntityKeyLocked;
import tennox.keyandcodelock.connection.PacketKeyNameAnswer;

public class PacketKeyNameChange
implements IKeyAndCodeLockPacket {
    int x;
    int y;
    int z;
    String name;
    int hash;

    public PacketKeyNameChange() {
    }

    public PacketKeyNameChange(TileEntity tile, String name, int hash) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.name = name;
        this.hash = hash;
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        int l = buffer.readShort();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < l; ++i) {
            builder.append(buffer.readChar());
        }
        this.name = builder.toString();
        this.hash = buffer.readInt();
        KeyAndCodeLock.debug("Read PacketKeyNameChange: " + this.x + "," + this.y + "," + this.z + "_" + this.name + "_" + this.hash);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        KeyAndCodeLock.debug("Writing PacketKeyNameChange... " + this.x + "," + this.y + "," + this.z + "_" + this.name + "_" + this.hash);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeShort(this.name.length());
        for (int i = 0; i < this.name.length(); ++i) {
            buffer.writeChar((int)Character.valueOf(this.name.charAt(i)).charValue());
        }
        buffer.writeInt(this.hash);
    }

    @Override
    public void executeServer(EntityPlayerMP player) {
        TileEntity t = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (t != null && t instanceof TileEntityKeyLocked) {
            TileEntityKeyLocked tile = (TileEntityKeyLocked)t;
            if (this.name == null || this.name.length() == 0 || this.hash <= 0) {
                KeyAndCodeLock.logger.warn("Recieved KeyNameChange with wrong data!");
                this.sendKeyNameAnswer(this.x, this.y, this.z, this.name, this.hash, false, (EntityPlayer)player);
                return;
            }
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            if (itemstack != null && itemstack.func_77973_b() == KeyAndCodeLock.key) {
                if (tile.name != null || tile.hash > 0) {
                    this.sendKeyNameAnswer(this.x, this.y, this.z, this.name, this.hash, false, (EntityPlayer)player);
                    player.field_70170_p.func_147471_g(this.x, this.y, this.z);
                    KeyAndCodeLock.logger.warn("Client tried setting a key to an already set door...");
                } else {
                    if (itemstack.field_77990_d == null) {
                        itemstack.func_77982_d(new NBTTagCompound());
                    }
                    itemstack.field_77990_d.func_74768_a("hash", this.hash);
                    itemstack.field_77990_d.func_74778_a("name", this.name);
                    tile.name = this.name;
                    tile.hash = this.hash;
                    EntityPlayerMP player2 = player;
                    if (player2.field_70170_p.func_147439_a(this.x, this.y, this.z) == KeyAndCodeLock.codelockeddoor) {
                        ((BlockDoorLockedKey)KeyAndCodeLock.keylockeddoor).flipDoor(player2.field_70170_p, this.x, this.y, this.z, (EntityPlayer)player2);
                    } else if (player2.field_70170_p.func_147439_a(this.x, this.y, this.z) == KeyAndCodeLock.coderedstonelock) {
                        ((BlockRedstoneLockKey)KeyAndCodeLock.keyredstonelock).changePowerState(player2.field_70170_p, this.x, this.y, this.z);
                    }
                    player.field_71135_a.func_147359_a(tile.func_145844_m());
                    this.sendKeyNameAnswer(this.x, this.y, this.z, this.name, this.hash, true, (EntityPlayer)player);
                    KeyAndCodeLock.debug("KeyName updated! name=" + this.name);
                }
            } else {
                KeyAndCodeLock.logger.warn("Recieved KeyNameChange packet but Player has no key?!");
                this.sendKeyNameAnswer(this.x, this.y, this.z, this.name, this.hash, false, (EntityPlayer)player);
                return;
            }
        }
    }

    private void sendKeyNameAnswer(int x, int y, int z, String name, int hash, boolean answer, EntityPlayer player) {
        KeyAndCodeLock.debug("Sending KeyNameAnswer... (" + answer + ")");
        KeyAndCodeLock.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        KeyAndCodeLock.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        KeyAndCodeLock.channels.get(Side.SERVER).writeOutbound(new Object[]{new PacketKeyNameAnswer(x, y, z, name, hash, answer)});
        KeyAndCodeLock.debug("KeyNameAnswer sent!");
    }

    @Override
    public void executeClient() {
    }
}

