/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages.signpost;

import gollorum.signpost.Signpost;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.code.MinecraftDependent;
import gollorum.signpost.worldGen.villages.GenerateStructureHelper;
import gollorum.signpost.worldGen.villages.VillageLibrary;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

@MinecraftDependent
public class VillageComponentSignpost
extends StructureVillagePieces.Village {
    private boolean built = false;
    private StructureVillagePieces.Start start;
    private int facing;

    public VillageComponentSignpost() {
    }

    public VillageComponentSignpost(StructureVillagePieces.Start start, int type, StructureBoundingBox boundingBox, int facing) {
        super(start, type);
        this.field_74887_e = boundingBox;
        this.start = start;
        this.facing = facing;
    }

    @Nullable
    public static StructureVillagePieces.Village buildComponent(StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int x, int y, int z, int facing, int type) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)3, (int)3, (int)facing);
        if (VillageComponentSignpost.func_74895_a((StructureBoundingBox)boundingBox) && VillageComponentSignpost.func_74883_a(pieces, (StructureBoundingBox)boundingBox) == null) {
            return new VillageComponentSignpost(startPiece, type, boundingBox, facing);
        }
        return null;
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox boundingBox) {
        int y;
        if (this.built || this.start == null) {
            return true;
        }
        this.built = true;
        int x = this.field_74887_e.func_78881_e();
        int z = this.field_74887_e.func_78891_g();
        try {
            y = GenerateStructureHelper.getInstance().getTopSolidOrLiquidBlock(world, x, z);
        }
        catch (Exception e) {
            y = this.field_74887_e.func_78879_f();
        }
        world.func_147449_b(x, y, z, (Block)Signpost.proxy.blockHandler.post_oak);
        world.func_147449_b(x, y + 1, z, (Block)Signpost.proxy.blockHandler.post_oak);
        if (world.func_147439_a(x, y - 1, z).func_149688_o().func_76224_d()) {
            Block block = this.func_151558_b(Blocks.field_150344_f, 0);
            world.func_147449_b(x, y - 1, z, block);
            world.func_147449_b(x - 1, y - 1, z - 1, block);
            world.func_147449_b(x - 1, y - 1, z, block);
            world.func_147449_b(x - 1, y - 1, z + 1, block);
            world.func_147449_b(x, y - 1, z - 1, block);
            world.func_147449_b(x, y - 1, z + 1, block);
            world.func_147449_b(x + 1, y - 1, z - 1, block);
            world.func_147449_b(x + 1, y - 1, z, block);
            world.func_147449_b(x + 1, y - 1, z + 1, block);
        }
        StructureBoundingBox villageBox = this.start.func_74874_b();
        MyBlockPos villagePos = new MyBlockPos(world, villageBox.field_78897_a, 0, villageBox.field_78896_c);
        MyBlockPos blockPos = new MyBlockPos(world, x, y + 1, z);
        VillageLibrary.getInstance().putSignpost(villagePos, blockPos, this.optimalRot(this.facing));
        return true;
    }

    private double optimalRot(int facing) {
        switch (facing) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return 4.71238898038469;
            }
            case 2: {
                return Math.PI;
            }
            case 3: {
                return 1.5707963267948966;
            }
        }
        return 0.0;
    }
}

