/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.ScriptBlockPos;
import noppes.npcs.scripted.ScriptTileEntity;
import noppes.npcs.scripted.interfaces.IBlock;
import noppes.npcs.scripted.interfaces.IContainer;
import noppes.npcs.scripted.interfaces.INbt;
import noppes.npcs.scripted.interfaces.IPos;
import noppes.npcs.scripted.interfaces.ITileEntity;
import noppes.npcs.scripted.interfaces.IWorld;
import noppes.npcs.util.LRUHashMap;

public class ScriptBlock
implements IBlock {
    private static final Map<String, IBlock> blockCache = new LRUHashMap<String, IBlock>(400);
    protected final IWorld world;
    protected final Block block;
    protected final BlockPos pos;
    protected final ScriptBlockPos bPos;
    protected TileEntity tile;

    public ScriptBlock(World world, Block block, BlockPos pos) {
        this.world = NpcAPI.Instance().getIWorld((World)((WorldServer)world));
        this.block = block;
        this.pos = pos;
        this.bPos = new ScriptBlockPos(pos);
        this.setTile(world.func_147438_o(pos.getX(), pos.getY(), pos.getZ()));
    }

    protected void setTile(TileEntity tile) {
        this.world.setTileEntity(this.pos.getX(), this.pos.getY(), this.pos.getZ(), new ScriptTileEntity<TileEntity>(tile));
        this.tile = tile;
    }

    @Override
    public IPos getPos() {
        return this.bPos;
    }

    @Override
    public int getX() {
        return this.pos.getX();
    }

    @Override
    public int getY() {
        return this.pos.getY();
    }

    @Override
    public int getZ() {
        return this.pos.getZ();
    }

    @Override
    public void remove() {
        this.world.getMCWorld().func_147468_f(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean isAir() {
        return this.block.isAir((IBlockAccess)this.world.getMCWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public IBlock setBlock(String blockName) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
        if (block == null) {
            return this;
        }
        this.world.getMCWorld().func_147449_b(this.getX(), this.getY(), this.getZ(), block);
        return NpcAPI.Instance().getIBlock((World)this.world.getMCWorld(), block, new BlockPos(this.getX(), this.getY(), this.getZ()));
    }

    @Override
    public IBlock setBlock(IBlock block) {
        this.world.getMCWorld().func_147449_b(this.getX(), this.getY(), this.getZ(), block.getMCBlock());
        return NpcAPI.Instance().getIBlock((World)this.world.getMCWorld(), block.getMCBlock(), new BlockPos(this.getX(), this.getY(), this.getZ()));
    }

    @Override
    public boolean isContainer() {
        return this.tile != null && this.tile instanceof IInventory && ((IInventory)this.tile).func_70302_i_() > 0;
    }

    @Override
    public IContainer getContainer() {
        if (!this.isContainer()) {
            throw new CustomNPCsException("This block is not a container", new Object[0]);
        }
        return NpcAPI.Instance().getIContainer((IInventory)this.tile);
    }

    @Override
    public String getName() {
        return Block.field_149771_c.func_148750_c((Object)this.block) + "";
    }

    @Override
    public String getDisplayName() {
        return this.tile == null ? this.getName() : this.tile.field_145854_h.func_149702_O();
    }

    @Override
    public IWorld getWorld() {
        return this.world;
    }

    @Override
    public Block getMCBlock() {
        return this.block;
    }

    public static void clearCache() {
        blockCache.clear();
    }

    @Override
    public boolean hasTileEntity() {
        return this.tile != null;
    }

    @Override
    public ITileEntity getTileEntity() {
        return new ScriptTileEntity<TileEntity>(this.tile);
    }

    @Override
    public void setTileEntity(ITileEntity tileEntity) {
        this.world.setTileEntity(this.pos.getX(), this.pos.getY(), this.pos.getZ(), tileEntity);
        this.tile = tileEntity.getMCTileEntity();
    }

    @Override
    public TileEntity getMCTileEntity() {
        return this.tile;
    }

    @Override
    public INbt getTileEntityNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        this.tile.func_145841_b(compound);
        return NpcAPI.Instance().getINbt(compound);
    }
}

