/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.quests.QuestItem;
import noppes.npcs.scripted.interfaces.handler.IPlayerQuestData;
import noppes.npcs.scripted.interfaces.handler.data.IQuest;

public class PlayerQuestData
implements IPlayerQuestData {
    private final PlayerData parent;
    public IQuest trackedQuest = null;
    public HashMap<Integer, QuestData> activeQuests = new HashMap();
    public HashMap<Integer, Long> finishedQuests = new HashMap();

    public PlayerQuestData(PlayerData parent) {
        this.parent = parent;
    }

    public void loadNBTData(NBTTagCompound mainCompound) {
        NBTTagList list2;
        if (mainCompound == null) {
            return;
        }
        NBTTagCompound compound = mainCompound.func_74775_l("QuestData");
        NBTTagList list = compound.func_150295_c("CompletedQuests", 10);
        if (list != null) {
            HashMap<Integer, Long> finishedQuests = new HashMap<Integer, Long>();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = list.func_150305_b(i);
                finishedQuests.put(nbttagcompound.func_74762_e("Quest"), nbttagcompound.func_74763_f("Date"));
            }
            this.finishedQuests = finishedQuests;
        }
        if ((list2 = compound.func_150295_c("ActiveQuests", 10)) != null) {
            HashMap<Integer, QuestData> activeQuests = new HashMap<Integer, QuestData>();
            for (int i = 0; i < list2.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = list2.func_150305_b(i);
                int id = nbttagcompound.func_74762_e("Quest");
                Quest quest = QuestController.instance.quests.get(id);
                if (quest == null) continue;
                QuestData data = new QuestData(quest);
                data.readEntityFromNBT(nbttagcompound);
                activeQuests.put(id, data);
            }
            this.activeQuests = activeQuests;
        }
        this.trackedQuest = QuestController.instance.get(mainCompound.func_74762_e("TrackedQuestID"));
    }

    public void saveNBTData(NBTTagCompound maincompound) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int quest : this.finishedQuests.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Quest", quest);
            nbttagcompound.func_74772_a("Date", this.finishedQuests.get(quest).longValue());
            list.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("CompletedQuests", (NBTBase)list);
        NBTTagList list2 = new NBTTagList();
        for (int quest : this.activeQuests.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Quest", quest);
            this.activeQuests.get(quest).writeEntityToNBT(nbttagcompound);
            list2.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("ActiveQuests", (NBTBase)list2);
        maincompound.func_74782_a("QuestData", (NBTBase)compound);
        if (this.trackedQuest != null) {
            maincompound.func_74768_a("TrackedQuestID", this.trackedQuest.getId());
        } else {
            maincompound.func_74768_a("TrackedQuestID", -1);
        }
    }

    public QuestData getQuestCompletion(EntityPlayer player, EntityNPCInterface npc) {
        PlayerData playerData = PlayerDataController.instance.getPlayerData(player);
        for (QuestData data : this.activeQuests.values()) {
            Quest quest = data.quest;
            if (quest == null || quest.completion != EnumQuestCompletion.Npc || !quest.completerNpc.equals(npc.func_70005_c_()) || !quest.questInterface.isCompleted(playerData)) continue;
            return data;
        }
        return null;
    }

    public boolean checkQuestCompletion(PlayerData playerData, EnumQuestType type) {
        boolean bo = false;
        EntityPlayer player = playerData.player;
        for (QuestData data : this.activeQuests.values()) {
            if (data.quest.type != type && type != null) continue;
            NoppesUtilPlayer.sendTrackedQuestData((EntityPlayerMP)player, data.quest);
            QuestInterface inter = data.quest.questInterface;
            if (inter.isCompleted(playerData)) {
                if (data.isCompleted) continue;
                if (!data.quest.complete(player, data) || data.quest.completeText.isEmpty()) {
                    Server.sendData((EntityPlayerMP)player, EnumPacketClient.MESSAGE, "quest.completed", data.quest.title);
                    Server.sendData((EntityPlayerMP)player, EnumPacketClient.CHAT, "quest.completed", ": ", data.quest.title);
                }
                data.isCompleted = true;
                bo = true;
                EventHooks.onQuestFinished(player, data.quest);
                continue;
            }
            data.isCompleted = false;
        }
        QuestItem.pickedUp = null;
        return bo;
    }

    @Override
    public IQuest getTrackedQuest() {
        return this.trackedQuest;
    }

    @Override
    public void startQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        if (this.activeQuests.containsKey(id)) {
            return;
        }
        QuestData questdata = new QuestData(quest);
        this.activeQuests.put(id, questdata);
        Server.sendData((EntityPlayerMP)this.parent.player, EnumPacketClient.MESSAGE, "quest.newquest", quest.title);
        Server.sendData((EntityPlayerMP)this.parent.player, EnumPacketClient.CHAT, "quest.newquest", ": ", quest.title);
    }

    @Override
    public void finishQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        this.finishedQuests.put(id, System.currentTimeMillis());
    }

    @Override
    public void stopQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        this.activeQuests.remove(id);
    }

    @Override
    public void removeQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        this.activeQuests.remove(id);
        this.finishedQuests.remove(id);
    }

    @Override
    public boolean hasFinishedQuest(int id) {
        return this.finishedQuests.containsKey(id);
    }

    @Override
    public boolean hasActiveQuest(int id) {
        return this.activeQuests.containsKey(id);
    }

    @Override
    public IQuest[] getActiveQuests() {
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : this.activeQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[0]);
    }

    @Override
    public IQuest[] getFinishedQuests() {
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : this.finishedQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[0]);
    }
}

