/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.roles.JobItemGiver;

public class GlobalDataController {
    public static GlobalDataController instance;
    private int itemGiverId = 0;
    public HashMap<Integer, JobItemGiver> itemGivers = new HashMap();

    public GlobalDataController() {
        instance = this;
        this.load();
    }

    private void load() {
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        try {
            File file = new File(saveDir, "global.dat");
            if (file.exists()) {
                this.loadData(file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(saveDir, "global.dat_old");
                if (file.exists()) {
                    this.loadData(file);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void loadData(File file) throws Exception {
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        this.itemGiverId = nbttagcompound1.func_74762_e("itemGiverId");
        NBTTagList jobList = nbttagcompound1.func_150295_c("ItemGivers", 10);
        for (int i = 0; i < jobList.func_74745_c(); ++i) {
            NBTTagCompound compound = jobList.func_150305_b(i);
            JobItemGiver jobItemGiver = new JobItemGiver();
            jobItemGiver.readFromNBT(compound);
            this.itemGivers.put(jobItemGiver.itemGiverId, jobItemGiver);
        }
    }

    public void saveData() {
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("itemGiverId", this.itemGiverId);
            NBTTagList jobList = new NBTTagList();
            for (JobItemGiver jobItemGiver : this.itemGivers.values()) {
                NBTTagCompound compound = new NBTTagCompound();
                jobItemGiver.writeToNBT(compound);
                jobList.func_74742_a((NBTBase)compound);
            }
            nbttagcompound.func_74782_a("ItemGivers", (NBTBase)jobList);
            File file = new File(saveDir, "global.dat_new");
            File file1 = new File(saveDir, "global.dat_old");
            File file2 = new File(saveDir, "global.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int incrementItemGiverId() {
        ++this.itemGiverId;
        return this.itemGiverId;
    }
}

