/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.event.ItemEvent;
import noppes.npcs.scripted.interfaces.entity.IPlayer;
import noppes.npcs.scripted.interfaces.item.IItemCustom;
import noppes.npcs.scripted.interfaces.item.IItemStack;
import noppes.npcs.scripted.item.ScriptCustomItem;

public class ScriptItemEventHandler {
    @SubscribeEvent
    public void invoke(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving == null || event.entityLiving.field_70170_p == null || event.entityLiving instanceof EntityPlayer) {
            return;
        }
        if (event.entityLiving instanceof EntityCustomNpc) {
            HashMap[] inventories;
            HashMap<Integer, ItemStack> armor = ((EntityCustomNpc)event.entityLiving).inventory.armor;
            HashMap<Integer, ItemStack> items = ((EntityCustomNpc)event.entityLiving).inventory.items;
            HashMap<Integer, ItemStack> weapons = ((EntityCustomNpc)event.entityLiving).inventory.weapons;
            for (HashMap inventory : inventories = new HashMap[]{armor, items, weapons}) {
                for (ItemStack stack : inventory.values()) {
                    if (stack == null || stack.func_77973_b() != CustomItems.scripted_item) continue;
                    IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
                    EventHooks.onScriptItemUpdate((IItemCustom)istack, event.entityLiving);
                }
            }
        } else if (event.entityLiving.func_70694_bm() != null && event.entityLiving.func_70694_bm().func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
            IItemStack itemStack = NpcAPI.Instance().getIItemStack(event.entityLiving.func_70694_bm());
            EventHooks.onScriptItemUpdate((IItemCustom)itemStack, event.entityLiving);
        }
    }

    @SubscribeEvent
    public void invoke(ItemTossEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer) {
            try {
                if (event.entityItem.func_92059_d().func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
                    ScriptCustomItem isw = ItemScripted.GetWrapper(event.entityItem.func_92059_d());
                    EventHooks.onScriptItemTossed(isw, event.player, event.entityItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.ItemPickupEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer) {
            try {
                if (event.player.func_70694_bm().func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
                    ScriptCustomItem isw = ItemScripted.GetWrapper(event.player.func_70694_bm());
                    EventHooks.onScriptItemPickedUp(isw, event.player);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void invoke(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityItem) {
            EntityItem entity = (EntityItem)event.entity;
            ItemStack stack = entity.func_92059_d();
            try {
                if (stack.field_77994_a > 0 && stack.func_77973_b() == CustomItems.scripted_item && EventHooks.onScriptItemSpawn(ItemScripted.GetWrapper(stack), entity)) {
                    event.setCanceled(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void invoke(EntityInteractEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer.field_70170_p instanceof WorldServer) {
            try {
                if (event.entityPlayer.func_70694_bm().func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
                    ScriptCustomItem isw = ItemScripted.GetWrapper(event.entityPlayer.func_70694_bm());
                    ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, (IPlayer)NpcAPI.Instance().getIEntity((Entity)event.entityPlayer), 2, NpcAPI.Instance().getIBlock(event.entityPlayer.field_70170_p, new BlockPos(event.entityPlayer.field_70165_t, event.entityPlayer.field_70163_u, event.entityPlayer.field_70161_v)));
                    event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void invoke(PlayerUseItemEvent.Start event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            ScriptCustomItem handler = ItemScripted.GetWrapper(event.item);
            IPlayer IPlayer2 = (IPlayer)NpcAPI.Instance().getIEntity((Entity)event.entityPlayer);
            event.setCanceled(EventHooks.onStartUsingCustomItem(handler, IPlayer2, event.duration));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerUseItemEvent.Tick event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer && event.item.func_77973_b() == CustomItems.scripted_item) {
            ScriptCustomItem handler = ItemScripted.GetWrapper(event.item);
            IPlayer IPlayer2 = (IPlayer)NpcAPI.Instance().getIEntity((Entity)event.entityPlayer);
            event.setCanceled(EventHooks.onUsingCustomItem(handler, IPlayer2, event.duration));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerUseItemEvent.Stop event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer && event.item.func_77973_b() == CustomItems.scripted_item) {
            ScriptCustomItem handler = ItemScripted.GetWrapper(event.item);
            IPlayer IPlayer2 = (IPlayer)NpcAPI.Instance().getIEntity((Entity)event.entityPlayer);
            event.setCanceled(EventHooks.onStopUsingCustomItem(handler, IPlayer2, event.duration));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerUseItemEvent.Finish event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer && event.item.func_77973_b() == CustomItems.scripted_item) {
            ScriptCustomItem handler = ItemScripted.GetWrapper(event.item);
            IPlayer IPlayer2 = (IPlayer)NpcAPI.Instance().getIEntity((Entity)event.entityPlayer);
            EventHooks.onFinishUsingCustomItem(handler, IPlayer2, event.duration);
        }
    }
}

