/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.superckl.api.superscript.APIInfo;
import me.superckl.api.superscript.ScriptHandler;
import me.superckl.api.superscript.object.ScriptObject;
import me.superckl.api.superscript.util.CollectionHelper;
import me.superckl.api.superscript.util.ConstructorListing;
import me.superckl.api.superscript.util.ParameterTypes;
import me.superckl.api.superscript.util.ParameterWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class ScriptParser {
    private static final Map<String, ConstructorListing<ScriptObject>> validObjects = Maps.newHashMap();

    public static void registerValidObjectInst(String name, ConstructorListing<ScriptObject> listing) {
        validObjects.put(name, listing);
    }

    public static void parseScriptFile(File file) {
        try {
            List<String> scriptLines = ScriptParser.parseScriptLines(file);
            new ScriptHandler(scriptLines).parse();
        }
        catch (Exception e) {
            APIInfo.log.error("Failed to parse a script file: " + file.getPath());
            e.printStackTrace();
        }
    }

    public static List<String> parseScriptLines(File file) throws IOException {
        ArrayList<String> array = new ArrayList<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            while ((line = r.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                array.add(line);
            }
        }
        return array;
    }

    public static boolean isStringArg(String arg) {
        return arg.trim().startsWith("\"") && arg.endsWith("\"");
    }

    public static boolean isPositiveInteger(String arg) {
        return arg.matches("[0-9]+");
    }

    public static String getCommandCalled(String command) {
        if (!command.endsWith(")") || !command.contains("(")) {
            return "";
        }
        return command.substring(0, command.indexOf("("));
    }

    public static String[] parseArguments(String script) {
        if (!script.endsWith(")") || !script.contains("(")) {
            APIInfo.log.error("Tried to parse an invalid argument array!");
            return new String[0];
        }
        String args = script.substring(script.indexOf("(") + 1, script.length() - 1).trim();
        String[] split = args.isEmpty() ? new String[]{} : args.split(",");
        return split;
    }

    public static Map<String, Object> parseAssignment(String script, ScriptHandler handler) throws Exception {
        String[] split = script.split("=");
        if (split.length != 2) {
            APIInfo.log.error("Failed to parse object assignment: " + script);
            return null;
        }
        String var = split[0].trim();
        String assign = split[1].trim();
        if (assign.startsWith("\"") && assign.endsWith("\"")) {
            String shortcut = (String)ParameterTypes.STRING.tryParse(assign, handler);
            return CollectionHelper.linkedMapWithEntry(var, shortcut);
        }
        String called = ScriptParser.getCommandCalled(assign);
        if (validObjects.containsKey(called)) {
            ConstructorListing<ScriptObject> listing = validObjects.get(called);
            String[] arguments = CollectionHelper.trimAll(ScriptParser.parseArguments(assign));
            for (Map.Entry<List<ParameterWrapper>, Constructor<ScriptObject>> entry : listing.getConstructors().entrySet()) {
                ArrayList objs = Lists.newArrayList();
                ArrayList params = Lists.newArrayList((Iterable)entry.getKey());
                Iterator it = params.iterator();
                while (it.hasNext()) {
                    ParameterWrapper wrap = (ParameterWrapper)it.next();
                    Pair<Object[], String[]> parsed = wrap.parseArgs(handler, arguments);
                    Collections.addAll(objs, (Object[])parsed.getKey());
                    arguments = (String[])parsed.getValue();
                    it.remove();
                }
                if (!params.isEmpty() || arguments.length != 0) continue;
                Object[] args = new Object[objs.size()];
                System.arraycopy(objs.toArray(), 0, args, 0, objs.size());
                ScriptObject obj = entry.getValue().getDeclaringClass().newInstance();
                obj.readArgs(args);
                return CollectionHelper.linkedMapWithEntry(var, obj);
            }
        }
        APIInfo.log.error("Failed to find meaning in object assignment " + script + ". It will be ignored.");
        return null;
    }

    public static Map<String, ConstructorListing<ScriptObject>> getValidobjects() {
        return validObjects;
    }
}

