/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import reifnsk.minimap.GuiScreenInterface;
import reifnsk.minimap.GuiScrollbar;
import reifnsk.minimap.GuiSimpleButton;
import reifnsk.minimap.GuiWaypoint;
import reifnsk.minimap.GuiWaypointEditorScreen;
import reifnsk.minimap.ReiMinimap;
import reifnsk.minimap.Waypoint;

public class GuiWaypointScreen
extends GuiScreen
implements GuiScreenInterface {
    protected static final int MIN_STRING_WIDTH = 64;
    protected static final int MAX_STRING_WIDTH = 160;
    protected static final int LIST_SIZE = 9;
    private ReiMinimap rmm = ReiMinimap.instance;
    private List<Waypoint> wayPts = this.rmm.getWaypoints();
    private GuiWaypoint[] guiWaypoints = new GuiWaypoint[9];
    private GuiScrollbar scrollbar = new GuiScrollbar(0, 0, 0, 12, 90);
    private GuiSimpleButton backButton;
    private GuiSimpleButton addButton;
    private GuiSimpleButton removeFlagButton;
    private GuiSimpleButton removeApplyButton;
    private GuiSimpleButton removeCancelButton;
    private GuiSimpleButton prevDimension;
    private GuiSimpleButton nextDimension;
    private ConcurrentHashMap<Waypoint, Object> deleteObject = new ConcurrentHashMap();
    private int scroll;
    private boolean removeMode;
    private int maxStringWidth;
    private GuiScreen parent;

    public GuiWaypointScreen(GuiScreen parent) {
        this.parent = parent;
        for (int i = 0; i < 9; ++i) {
            this.guiWaypoints[i] = new GuiWaypoint(i, this);
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        for (GuiWaypoint gpt : this.guiWaypoints) {
            this.field_146292_n.add(gpt);
        }
        this.field_146292_n.add(this.scrollbar);
        this.updateWaypoints();
        int centerX = this.field_146294_l / 2;
        int bottom = this.field_146295_m + 90 >> 1;
        this.backButton = new GuiSimpleButton(0, centerX - 65, bottom + 7, 40, 14, this.parent == null ? "\u0417\u0430\u043a\u0440\u044b\u0442\u044c" : "\u041d\u0430\u0437\u0430\u0434");
        this.field_146292_n.add(this.backButton);
        this.addButton = new GuiSimpleButton(0, centerX - 20, bottom + 7, 40, 14, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        this.field_146292_n.add(this.addButton);
        this.removeFlagButton = new GuiSimpleButton(0, centerX + 25, bottom + 7, 40, 14, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        this.field_146292_n.add(this.removeFlagButton);
        this.removeApplyButton = new GuiSimpleButton(0, centerX - 65, bottom + 7, 60, 14, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        this.field_146292_n.add(this.removeApplyButton);
        this.removeCancelButton = new GuiSimpleButton(0, centerX + 5, bottom + 7, 60, 14, "\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u0442\u044c");
        this.field_146292_n.add(this.removeCancelButton);
        this.prevDimension = new GuiSimpleButton(0, 0, 0, 14, 14, "<");
        this.field_146292_n.add(this.prevDimension);
        this.nextDimension = new GuiSimpleButton(0, 0, 0, 14, 14, ">");
        this.field_146292_n.add(this.nextDimension);
        this.setRemoveMode(this.removeMode);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.backButton.field_146125_m = !this.removeMode;
        this.backButton.field_146124_l = this.backButton.field_146125_m;
        this.addButton.field_146125_m = !this.removeMode;
        this.addButton.field_146124_l = this.addButton.field_146125_m;
        this.removeFlagButton.field_146125_m = !this.removeMode;
        this.removeFlagButton.field_146124_l = this.removeFlagButton.field_146125_m;
        this.removeApplyButton.field_146124_l = this.removeApplyButton.field_146125_m = this.removeMode;
        this.removeCancelButton.field_146124_l = this.removeCancelButton.field_146125_m = this.removeMode;
        this.addButton.field_146124_l = this.rmm.getCurrentDimension() == this.rmm.getWaypointDimension();
        int gwpWidth = Math.min(160, this.maxStringWidth) + 16;
        int top = this.field_146295_m - 90 >> 1;
        int bottom = this.field_146295_m + 90 >> 1;
        int left = this.field_146294_l - gwpWidth - 45 - 10 >> 1;
        int right = this.field_146294_l + gwpWidth + 45 + 10 >> 1;
        GuiWaypointScreen.func_73734_a((int)(left - 2), (int)(top - 2), (int)(right + 2), (int)(bottom + 2), (int)-1610612736);
        String title = String.format("\u0422\u043e\u0447\u043a\u0438 [%s]", ReiMinimap.instance.getDimensionName(ReiMinimap.instance.getWaypointDimension()));
        int titleWidth = this.field_146289_q.func_78256_a(title);
        int titleLeft = this.field_146294_l - titleWidth >> 1;
        int titleRight = this.field_146294_l + titleWidth >> 1;
        this.prevDimension.field_146128_h = titleLeft - 18;
        this.prevDimension.field_146129_i = top - 22;
        this.nextDimension.field_146128_h = titleRight + 4;
        this.nextDimension.field_146129_i = top - 22;
        GuiWaypointScreen.func_73734_a((int)(titleLeft - 2), (int)(top - 22), (int)(titleRight + 2), (int)(top - 8), (int)-1610612736);
        this.func_73732_a(this.field_146289_q, title, this.field_146294_l / 2, top - 19, -1);
        super.func_73863_a(mouseX, mouseY, f);
    }

    public void func_73876_c() {
        int temp = (int)this.scrollbar.getValue();
        if (this.scroll != temp) {
            this.scroll = temp;
            this.setWaypoints();
        }
    }

    protected void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        switch (i) {
            case 199: {
                this.scrollbar.setValue(this.scrollbar.getMinimum());
                break;
            }
            case 200: {
                this.scrollbar.unitDecrement();
                break;
            }
            case 201: {
                this.scrollbar.blockDecrement();
            }
            default: {
                break;
            }
            case 207: {
                this.scrollbar.setValue(this.scrollbar.getMaximum());
                break;
            }
            case 208: {
                this.scrollbar.unitIncrement();
                break;
            }
            case 209: {
                this.scrollbar.blockIncrement();
            }
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getDWheel();
        if (i != 0) {
            i = i < 0 ? 3 : -3;
            this.scrollbar.setValue(this.scrollbar.getValue() + (float)i);
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.backButton) {
            this.field_146297_k.func_147108_a(this.parent);
        }
        if (guibutton == this.removeFlagButton) {
            this.setRemoveMode(true);
        }
        if (guibutton == this.removeCancelButton) {
            this.setRemoveMode(false);
        }
        if (guibutton == this.removeApplyButton) {
            boolean remove = false;
            for (Waypoint wp : this.deleteObject.keySet()) {
                remove |= this.wayPts.remove(wp);
            }
            if (remove) {
                this.rmm.saveWaypoints();
                this.updateWaypoints();
            }
            this.setRemoveMode(false);
        }
        if (guibutton == this.addButton && this.rmm.getCurrentDimension() == this.rmm.getWaypointDimension()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiWaypointEditorScreen(this, (Waypoint)null));
        }
        if (guibutton == this.prevDimension) {
            this.setRemoveMode(false);
            this.rmm.prevDimension();
            this.wayPts = this.rmm.getWaypoints();
            this.updateWaypoints();
        }
        if (guibutton == this.nextDimension) {
            this.setRemoveMode(false);
            this.rmm.nextDimension();
            this.wayPts = this.rmm.getWaypoints();
            this.updateWaypoints();
        }
    }

    protected void setRemoveMode(boolean b) {
        this.removeMode = b;
        this.deleteObject.clear();
    }

    protected boolean getRemoveMode() {
        return this.removeMode;
    }

    protected boolean isRemove(Waypoint wp) {
        return this.deleteObject.containsKey(wp);
    }

    protected void addWaypoint(Waypoint wp) {
        if (!this.wayPts.contains(wp)) {
            this.wayPts.add(wp);
            this.rmm.saveWaypoints();
            this.updateWaypoints();
            this.scrollbar.setValue(this.scrollbar.getMaximum());
        }
    }

    protected void removeWaypoint(Waypoint wp) {
        if (this.removeMode) {
            if (this.deleteObject.remove(wp) == null) {
                this.deleteObject.put(wp, wp);
            }
        } else if (this.wayPts.remove(wp)) {
            this.rmm.saveWaypoints();
            this.updateWaypoints();
        }
    }

    protected void updateWaypoint(Waypoint wp) {
        if (this.wayPts.contains(wp)) {
            this.rmm.saveWaypoints();
            this.updateWaypoints();
        }
    }

    private void updateWaypoints() {
        this.maxStringWidth = 64;
        int j = this.wayPts.size();
        for (int i = 0; i < j; ++i) {
            Waypoint pt = this.wayPts.get(i);
            this.maxStringWidth = Math.max(this.maxStringWidth, this.field_146289_q.func_78256_a(i + 1 + ") " + pt.name));
        }
        this.scrollbar.setMinimum(0.0f);
        this.scrollbar.setMaximum(this.wayPts.size());
        this.scrollbar.setVisibleAmount(Math.min(9, this.wayPts.size()));
        this.scroll = (int)this.scrollbar.getValue();
        this.updateGui();
        this.setWaypoints();
    }

    private void updateGui() {
        int gwpWidth = Math.min(160, this.maxStringWidth) + 16;
        int top = this.field_146295_m - 90 - 4 >> 1;
        int left = this.field_146294_l - gwpWidth - 45 - 12 >> 1;
        int right = this.field_146294_l + gwpWidth + 45 + 12 >> 1;
        for (int i = 0; i < 9; ++i) {
            this.guiWaypoints[i].bounds(left + 2, top + 2 + 10 * i, gwpWidth + 45, 9);
        }
        this.scrollbar.field_146128_h = right - 12;
        this.scrollbar.field_146129_i = top + 2;
    }

    private void setWaypoints() {
        for (int i = 0; i < 9; ++i) {
            int num = i + this.scroll;
            this.guiWaypoints[i].setWaypoint(num + 1, num < this.wayPts.size() ? this.wayPts.get(num) : null);
        }
    }

    protected Minecraft getMinecraft() {
        return this.field_146297_k;
    }
}

