/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.model.EnumAnimationType;
import com.flansmod.client.model.EnumMeleeAnimation;
import com.flansmod.client.model.ModelCasing;
import com.flansmod.client.model.ModelFlash;
import com.flansmod.client.model.ModelGun;
import com.flansmod.client.model.ModelMG;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.EnumSecondaryFunction;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGrenade;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.paintjob.Paintjob;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GunType
extends PaintableType
implements IScope {
    public static final Random rand = new Random();
    public ShootableType defaultAmmo = null;
    public GunRecoil recoil = new GunRecoil();
    public boolean useFancyRecoil = false;
    public float recoilPitch = 0.0f;
    public float recoilYaw = 0.0f;
    public float rndRecoilPitchRange = 0.5f;
    public float rndRecoilYawRange = 0.3f;
    public float decreaseRecoilPitch = 0.0f;
    public float decreaseRecoilYaw = 0.0f;
    public float recoilSneakingMultiplier = -1.0f;
    public float recoilSprintingMultiplier = 1.0f;
    public float recoilSneakingMultiplierYaw = 0.8f;
    public float recoilSprintingMultiplierYaw = 1.2f;
    public float recoilCounterCoefficient = 0.8f;
    public float recoilCounterCoefficientSprinting = 0.9f;
    public float recoilCounterCoefficientSneaking = 0.7f;
    public List<ShootableType> ammo = new ArrayList<ShootableType>();
    public boolean canForceReload = true;
    public boolean allowRearm = true;
    public int reloadTime;
    public int numPrimaryAmmoItems = 1;
    public float bulletSpread;
    public float sneakSpreadMultiplier = 0.63f;
    public float sprintSpreadMultiplier = 1.75f;
    public boolean allowSpreadByBullet = false;
    public float damage = 0.0f;
    public float meleeDamage = 1.0f;
    public float meleeDamageDriveableModifier = 1.0f;
    public float bulletSpeed = 5.0f;
    public int numBullets = 1;
    public boolean allowNumBulletsByBulletType = false;
    public float shootDelay = 0.0f;
    public float roundsPerMin = 0.0f;
    public EnumFireMode mode = EnumFireMode.FULLAUTO;
    public EnumFireMode[] submode = new EnumFireMode[]{EnumFireMode.FULLAUTO};
    public EnumFireMode defaultmode = this.mode;
    public int numBurstRounds = 3;
    public float minigunStartSpeed = 15.0f;
    public boolean canShootUnderwater = true;
    public EnumSecondaryFunction secondaryFunction = EnumSecondaryFunction.ADS_ZOOM;
    public EnumSecondaryFunction secondaryFunctionWhenShoot = null;
    public boolean oneHanded = false;
    public boolean consumeGunUponUse = false;
    public boolean showCrosshair = true;
    public String dropItemOnShoot = null;
    public boolean usableByPlayers = true;
    public boolean usableByMechas = true;
    public EnumAction itemUseAction = EnumAction.bow;
    public int hipFireWhileSprinting = 0;
    public int canLockOnAngle = 5;
    public int lockOnSoundTime = 0;
    public String lockOnSound = "";
    public int maxRangeLockOn = 80;
    public boolean canSetPosition = false;
    public boolean lockOnToPlanes = false;
    public boolean lockOnToVehicles = false;
    public boolean lockOnToMechas = false;
    public boolean lockOnToPlayers = false;
    public boolean lockOnToLivings = false;
    public boolean shield = false;
    public Vector3f shieldOrigin;
    public Vector3f shieldDimensions;
    public float shieldDamageAbsorption = 0.0f;
    public String shootSound;
    public String bulletInsert = "defaultshellinsert";
    public String actionSound;
    public String lastShootSound;
    public String suppressedShootSound;
    public int shootSoundLength;
    public String reloadSound;
    public String reloadSoundOnEmpty;
    public String clickSoundOnEmpty;
    public String clickSoundOnEmptyRepeated;
    public String idleSound;
    public boolean distortSound = true;
    public int idleSoundLength;
    public int idleSoundRange = 50;
    public int meleeSoundRange = 50;
    public int reloadSoundRange = 50;
    public int gunSoundRange = 50;
    public String distantShootSound = "";
    public int distantSoundRange = 100;
    public boolean useLoopingSounds = false;
    public String warmupSound;
    public int warmupSoundLength = 20;
    public String loopedSound;
    public int loopedSoundLength = 20;
    public String cooldownSound;
    public String meleeSound;
    public int meleeTime = 1;
    public ArrayList<Vector3f> meleePath = new ArrayList();
    public ArrayList<Vector3f> meleePathAngles = new ArrayList();
    public ArrayList<Vector3f> meleeDamagePoints = new ArrayList();
    public boolean deployable = false;
    public ModelMG deployableModel;
    public String deployableModelString;
    public String deployableTexture;
    public float standBackDist = 1.5f;
    public float topViewLimit = -60.0f;
    public float bottomViewLimit = 30.0f;
    public float sideViewLimit = 45.0f;
    public float pivotHeight = 0.375f;
    public String defaultScopeTexture;
    public boolean hasScopeOverlay = false;
    public float zoomLevel = 1.0f;
    public float FOVFactor = 1.5f;
    public boolean allowNightVision = false;
    public ModelGun model;
    public float modelScale = 1.0f;
    public ModelCasing casingModel;
    public String casingModelString;
    public ModelFlash flashModel;
    public String flashModelString;
    public String casingTexture;
    public String flashTexture;
    public String hitTexture;
    public String muzzleFlashParticle = "flansmod.muzzleflash";
    public float muzzleFlashParticleSize = 1.0f;
    private Boolean useMuzzleFlashDefaults = true;
    private Boolean showMuzzleFlashParticles = true;
    public Boolean showMuzzleFlashParticlesFirstPerson = false;
    public Vector3f muzzleFlashParticlesHandOffset = new Vector3f();
    public Vector3f muzzleFlashParticlesShoulderOffset = new Vector3f();
    public boolean allowAllAttachments = false;
    public ArrayList<AttachmentType> allowedAttachments = new ArrayList();
    public boolean allowBarrelAttachments = false;
    public boolean allowScopeAttachments = false;
    public boolean allowStockAttachments = false;
    public boolean allowGripAttachments = false;
    public boolean allowGadgetAttachments = false;
    public boolean allowSlideAttachments = false;
    public boolean allowPumpAttachments = false;
    public boolean allowAccessoryAttachments = false;
    public int numGenericAttachmentSlots = 0;
    public static HashMap<String, GunType> guns = new HashMap();
    public static ArrayList<GunType> gunList = new ArrayList();
    public float moveSpeedModifier = 1.0f;
    public float knockbackModifier = 0.0f;
    private float defaultSpread = 0.0f;
    public float adsSpreadModifier = -1.0f;
    public float adsSpreadModifierShotgun = -1.0f;
    public float switchDelay = 0.0f;

    public GunType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        gunList.add(this);
        guns.put(this.shortName, this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        block261: {
            super.read(split, file);
            try {
                if (split[0].equals("Damage")) {
                    this.damage = Float.parseFloat(split[1]);
                    break block261;
                }
                if (split[0].equals("MeleeDamage")) {
                    this.meleeDamage = Float.parseFloat(split[1]);
                    if (this.meleeDamage > 0.0f) {
                        this.secondaryFunction = EnumSecondaryFunction.MELEE;
                    }
                    break block261;
                }
                if (split[0].equals("MeleeDamageDriveableModifier")) {
                    this.meleeDamageDriveableModifier = Float.parseFloat(split[1]);
                    break block261;
                }
                if (split[0].equals("CounterRecoilForce")) {
                    this.recoilCounterCoefficient = Float.parseFloat(split[1]);
                    break block261;
                }
                if (split[0].equals("CounterRecoilForceSneaking")) {
                    this.recoilCounterCoefficientSneaking = Float.parseFloat(split[1]);
                    break block261;
                }
                if (split[0].equals("CounterRecoilForceSprinting")) {
                    this.recoilCounterCoefficientSprinting = Float.parseFloat(split[1]);
                    break block261;
                }
                if (split[0].equals("SneakSpreadModifier")) {
                    this.sneakSpreadMultiplier = Float.parseFloat(split[1]);
                    break block261;
                }
                if (split[0].equals("SprintSpreadModifier")) {
                    this.sprintSpreadMultiplier = Float.parseFloat(split[1]);
                    break block261;
                }
                if (split[0].equals("CanForceReload")) {
                    this.canForceReload = Boolean.parseBoolean(split[1].toLowerCase());
                    break block261;
                }
                if (split[0].equals("AllowRearm")) {
                    this.allowRearm = Boolean.parseBoolean(split[1].toLowerCase());
                    break block261;
                }
                if (split[0].equals("ReloadTime")) {
                    this.reloadTime = Integer.parseInt(split[1]);
                    break block261;
                }
                if (split[0].equals("Recoil")) {
                    this.recoilPitch = Float.parseFloat(split[1]);
                    break block261;
                }
                if (split[0].equals("FancyRecoil")) {
                    try {
                        if (split.length > 1) {
                            this.recoil.read(split);
                            this.useFancyRecoil = true;
                        }
                        break block261;
                    }
                    catch (Exception e) {
                        this.useFancyRecoil = false;
                        FlansMod.log("Failed to read fancy recoil for " + this.shortName);
                        e.printStackTrace();
                    }
                    break block261;
                }
                if (split[0].equals("RecoilYaw")) {
                    this.recoilYaw = Float.parseFloat(split[1]) / 10.0f;
                } else if (split[0].equals("RandomRecoilRange")) {
                    this.rndRecoilPitchRange = Float.parseFloat(split[1]);
                } else if (split[0].equals("RandomRecoilYawRange")) {
                    this.rndRecoilYawRange = Float.parseFloat(split[1]);
                } else if (split[0].equals("DecreaseRecoil")) {
                    this.decreaseRecoilPitch = Float.parseFloat(split[1]);
                } else if (split[0].equals("DecreaseRecoilYaw")) {
                    this.decreaseRecoilYaw = Float.parseFloat(split[1]) > 0.0f ? Float.parseFloat(split[1]) : 0.5f;
                } else if (split[0].equals("RecoilSneakingMultiplier")) {
                    this.recoilSneakingMultiplier = Float.parseFloat(split[1]);
                } else if (split[0].equals("RecoilSprintingMultiplier")) {
                    this.recoilSprintingMultiplier = Float.parseFloat(split[1]);
                } else if (split[0].equals("RecoilSneakingMultiplierYaw")) {
                    this.recoilSneakingMultiplierYaw = Float.parseFloat(split[1]);
                } else if (split[0].equals("RecoilSprintingMultiplierYaw")) {
                    this.recoilSprintingMultiplierYaw = Float.parseFloat(split[1]);
                } else if (split[0].equals("Accuracy") || split[0].equals("Spread")) {
                    this.defaultSpread = this.bulletSpread = Float.parseFloat(split[1]);
                } else if (split[0].equals("ADSSpreadModifier")) {
                    this.adsSpreadModifier = Float.parseFloat(split[1]);
                } else if (split[0].equals("ADSSpreadModifierShotgun")) {
                    this.adsSpreadModifierShotgun = Float.parseFloat(split[1]);
                } else if (split[0].equals("NumBullets")) {
                    this.numBullets = Integer.parseInt(split[1]);
                } else if (split[0].equals("AllowNumBulletsByBulletType")) {
                    this.allowNumBulletsByBulletType = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("AllowSpreadByBullet")) {
                    this.allowSpreadByBullet = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("CanLockAngle")) {
                    this.canLockOnAngle = Integer.parseInt(split[1]);
                } else if (split[0].equals("LockOnSoundTime")) {
                    this.lockOnSoundTime = Integer.parseInt(split[1]);
                } else if (split[0].equals("LockOnToDriveables")) {
                    this.lockOnToVehicles = this.lockOnToMechas = Boolean.parseBoolean(split[1].toLowerCase());
                    this.lockOnToPlanes = this.lockOnToMechas;
                } else if (split[0].equals("LockOnToVehicles")) {
                    this.lockOnToVehicles = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToPlanes")) {
                    this.lockOnToPlanes = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToMechas")) {
                    this.lockOnToMechas = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToPlayers")) {
                    this.lockOnToPlayers = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToLivings")) {
                    this.lockOnToLivings = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("ConsumeGunOnUse")) {
                    this.consumeGunUponUse = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("ShowCrosshair")) {
                    this.showCrosshair = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("DropItemOnShoot")) {
                    this.dropItemOnShoot = split[1];
                } else if (split[0].equals("NumBurstRounds")) {
                    this.numBurstRounds = Integer.parseInt(split[1]);
                } else if (split[0].equals("MinigunStartSpeed")) {
                    this.minigunStartSpeed = Float.parseFloat(split[1]);
                } else if (split[0].equals("ItemUseAction")) {
                    this.itemUseAction = EnumAction.valueOf((String)split[1].toLowerCase());
                } else if (split[0].equals("HipFireWhileSprinting")) {
                    this.hipFireWhileSprinting = Boolean.parseBoolean(split[1].toLowerCase()) ? 1 : 2;
                } else if (split[0].equals("MaxRangeLockOn")) {
                    this.maxRangeLockOn = Integer.parseInt(split[1]);
                } else if (split[0].equals("ShootDelay")) {
                    this.shootDelay = Float.parseFloat(split[1]);
                } else if (split[0].equals("RoundsPerMin")) {
                    this.roundsPerMin = Float.parseFloat(split[1]);
                } else if (split[0].equals("SoundLength")) {
                    this.shootSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("DistortSound")) {
                    this.distortSound = split[1].equals("True");
                } else if (split[0].equals("IdleSoundRange")) {
                    this.idleSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("MeleeSoundRange")) {
                    this.meleeSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("ReloadSoundRange")) {
                    this.reloadSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("GunSoundRange")) {
                    this.gunSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("ShootSound")) {
                    this.shootSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("BulletInsertSound")) {
                    this.bulletInsert = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("ActionSound")) {
                    this.actionSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("LastShootSound")) {
                    this.lastShootSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("SuppressedShootSound")) {
                    this.suppressedShootSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("ReloadSound")) {
                    this.reloadSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("EmptyReloadSound")) {
                    this.reloadSoundOnEmpty = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("EmptyClickSound")) {
                    this.clickSoundOnEmpty = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("EmptyClickSoundRepeated")) {
                    this.clickSoundOnEmptyRepeated = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("IdleSound")) {
                    this.idleSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("IdleSoundLength")) {
                    this.idleSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("MeleeSound")) {
                    this.meleeSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("WarmupSound")) {
                    this.warmupSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("WarmupSoundLength")) {
                    this.warmupSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("LoopedSound") || split[0].equals("SpinSound")) {
                    this.loopedSound = split[1];
                    this.useLoopingSounds = true;
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("LoopedSoundLength") || split[0].equals("SpinSoundLength")) {
                    this.loopedSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("CooldownSound")) {
                    this.cooldownSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("LockOnSound")) {
                    this.lockOnSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("DistantSound")) {
                    this.distantShootSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("DistantSoundRange")) {
                    this.distantSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("Mode")) {
                    this.defaultmode = this.mode = EnumFireMode.getFireMode(split[1]);
                    this.submode = new EnumFireMode[split.length - 1];
                    for (int i = 0; i < this.submode.length; ++i) {
                        this.submode[i] = EnumFireMode.getFireMode(split[1 + i]);
                    }
                } else if (split[0].equals("Scope")) {
                    this.hasScopeOverlay = true;
                    if (split[1].equals("None")) {
                        this.hasScopeOverlay = false;
                    } else {
                        this.defaultScopeTexture = split[1];
                    }
                } else if (split[0].equals("AllowNightVision")) {
                    this.allowNightVision = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("ZoomLevel")) {
                    this.zoomLevel = Float.parseFloat(split[1]);
                    if (this.zoomLevel > 1.0f) {
                        this.secondaryFunction = EnumSecondaryFunction.ZOOM;
                    }
                } else if (split[0].equals("FOVZoomLevel")) {
                    this.FOVFactor = Float.parseFloat(split[1]);
                    if (this.FOVFactor > 1.0f) {
                        this.secondaryFunction = EnumSecondaryFunction.ADS_ZOOM;
                    }
                } else if (split[0].equals("Deployable")) {
                    this.deployable = split[1].equals("True");
                } else if (FMLCommonHandler.instance().getSide().isClient() && this.deployable && split[0].equals("DeployedModel")) {
                    this.deployableModel = FlansMod.proxy.loadModel(split[1], this.shortName, ModelMG.class);
                    this.deployableModelString = split[1];
                } else if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                    this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelGun.class);
                } else if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("CasingModel")) {
                    this.casingModel = FlansMod.proxy.loadModel(split[1], this.shortName, ModelCasing.class);
                    this.casingModelString = split[1];
                } else if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("FlashModel")) {
                    this.flashModel = FlansMod.proxy.loadModel(split[1], this.shortName, ModelFlash.class);
                    this.flashModelString = split[1];
                } else if (split[0].equals("CasingTexture")) {
                    this.casingTexture = split[1];
                } else if (split[0].equals("FlashTexture")) {
                    this.flashTexture = split[1];
                } else if (split[0].equals("MuzzleFlashParticle")) {
                    this.muzzleFlashParticle = split[1];
                } else if (split[0].equals("MuzzleFlashParticleSize")) {
                    this.muzzleFlashParticleSize = Float.parseFloat(split[1]);
                } else if (split[0].equals("ShowMuzzleFlashParticle")) {
                    this.showMuzzleFlashParticles = Boolean.parseBoolean(split[1]);
                    this.useMuzzleFlashDefaults = false;
                } else if (split[0].equals("ShowMuzzleFlashParticleFirstPerson")) {
                    this.showMuzzleFlashParticlesFirstPerson = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("MuzzleFlashParticleShoulderOffset")) {
                    this.muzzleFlashParticlesShoulderOffset = new Vector3f(split[1], null);
                } else if (split[0].equals("MuzzleFlashParticleHandOffset")) {
                    this.muzzleFlashParticlesHandOffset = new Vector3f(split[1], null);
                } else if (split[0].equals("ModelScale")) {
                    this.modelScale = Float.parseFloat(split[1]);
                } else if (split[0].equals("Texture")) {
                    this.texture = split[1];
                } else if (split[0].equals("HitTexture")) {
                    this.hitTexture = split[1];
                } else if (split[0].equals("DeployedTexture")) {
                    this.deployableTexture = split[1];
                } else if (split[0].equals("StandBackDistance")) {
                    this.standBackDist = Float.parseFloat(split[1]);
                } else if (split[0].equals("TopViewLimit")) {
                    this.topViewLimit = -Float.parseFloat(split[1]);
                } else if (split[0].equals("BottomViewLimit")) {
                    this.bottomViewLimit = Float.parseFloat(split[1]);
                } else if (split[0].equals("SideViewLimit")) {
                    this.sideViewLimit = Float.parseFloat(split[1]);
                } else if (split[0].equals("PivotHeight")) {
                    this.pivotHeight = Float.parseFloat(split[1]);
                } else if (split[0].equals("Ammo")) {
                    ShootableType type = ShootableType.getShootableType(split[1]);
                    if (type != null) {
                        this.ammo.add(type);
                        if (this.defaultAmmo == null) {
                            this.defaultAmmo = type;
                        }
                    }
                } else if (split[0].equals("NumAmmoSlots") || split[0].equals("NumAmmoItemsInGun") || split[0].equals("LoadIntoGun")) {
                    this.numPrimaryAmmoItems = Integer.parseInt(split[1]);
                } else if (split[0].equals("BulletSpeed")) {
                    this.bulletSpeed = Float.parseFloat(split[1]);
                } else if (split[0].equals("CanShootUnderwater")) {
                    this.canShootUnderwater = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("CanSetPosition")) {
                    this.canSetPosition = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("OneHanded")) {
                    this.oneHanded = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("SecondaryFunction")) {
                    this.secondaryFunction = EnumSecondaryFunction.get(split[1]);
                } else if (split[0].equals("UsableByPlayers")) {
                    this.usableByPlayers = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("UsableByMechas")) {
                    this.usableByMechas = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("UseCustomMelee") && Boolean.parseBoolean(split[1])) {
                    this.secondaryFunction = EnumSecondaryFunction.CUSTOM_MELEE;
                } else if (split[0].equals("UseCustomMeleeWhenShoot") && Boolean.parseBoolean(split[1])) {
                    this.secondaryFunctionWhenShoot = EnumSecondaryFunction.CUSTOM_MELEE;
                } else if (split[0].equals("MeleeTime")) {
                    this.meleeTime = Integer.parseInt(split[1]);
                } else if (split[0].equals("AddNode")) {
                    this.meleePath.add(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f));
                    this.meleePathAngles.add(new Vector3f(Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6])));
                } else if (split[0].equals("MeleeDamagePoint") || split[0].equals("MeleeDamageOffset")) {
                    this.meleeDamagePoints.add(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f));
                } else if (split[0].equals("MoveSpeedModifier") || split[0].equals("Slowness")) {
                    this.moveSpeedModifier = Float.parseFloat(split[1]);
                } else if (split[0].equals("KnockbackReduction") || split[0].equals("KnockbackModifier")) {
                    this.knockbackModifier = Float.parseFloat(split[1]);
                } else if (split[0].equals("SwitchDelay")) {
                    this.switchDelay = Float.parseFloat(split[1]);
                } else if (split[0].equals("AllowAllAttachments")) {
                    this.allowAllAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("AllowAttachments")) {
                    for (int i = 1; i < split.length; ++i) {
                        this.allowedAttachments.add(AttachmentType.getAttachment(split[i]));
                    }
                } else if (split[0].equals("AllowBarrelAttachments")) {
                    this.allowBarrelAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("AllowScopeAttachments")) {
                    this.allowScopeAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("AllowStockAttachments")) {
                    this.allowStockAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("AllowGripAttachments")) {
                    this.allowGripAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("AllowGadgetAttachments")) {
                    this.allowGadgetAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("AllowSlideAttachments")) {
                    this.allowSlideAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("AllowPumpAttachments")) {
                    this.allowPumpAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("AllowAccessoryAttachments")) {
                    this.allowAccessoryAttachments = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("NumGenericAttachmentSlots")) {
                    this.numGenericAttachmentSlots = Integer.parseInt(split[1]);
                } else if (split[0].equalsIgnoreCase("shield")) {
                    this.shield = true;
                    this.shieldDamageAbsorption = Float.parseFloat(split[1]);
                    this.shieldOrigin = new Vector3f(Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f, Float.parseFloat(split[4]) / 16.0f);
                    this.shieldDimensions = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
                } else if (FMLCommonHandler.instance().getSide().isClient()) {
                    this.processAnimationConfigs(split);
                }
            }
            catch (Exception e) {
                if (split != null) {
                    StringBuilder msg = new StringBuilder(" : ");
                    for (String s : split) {
                        msg.append(" ").append(s);
                    }
                    FlansMod.log("Reading gun file failed. " + file.name + msg);
                } else {
                    FlansMod.log("Reading gun file failed. " + file.name);
                }
                if (!FlansMod.printStackTrace) break block261;
                e.printStackTrace();
            }
        }
    }

    public void processAnimationConfigs(String[] split) {
        if (split[0].equals("animMinigunBarrelOrigin")) {
            this.model.minigunBarrelOrigin = this.parseVector3f(split);
        } else if (split[0].equals("animBarrelAttachPoint")) {
            this.model.barrelAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animScopeAttachPoint")) {
            this.model.scopeAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animStockAttachPoint")) {
            this.model.stockAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animGripAttachPoint")) {
            this.model.gripAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animGadgetAttachPoint")) {
            this.model.gadgetAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animSlideAttachPoint")) {
            this.model.slideAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animPumpAttachPoint")) {
            this.model.pumpAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animAccessoryAttachPoint")) {
            this.model.accessoryAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animDefaultBarrelFlashPoint")) {
            this.model.defaultBarrelFlashPoint = this.parseVector3f(split);
        } else if (split[0].equals("animMuzzleFlashPoint")) {
            this.model.muzzleFlashPoint = this.parseVector3f(split);
        } else if (split[0].equals("animHasFlash")) {
            this.model.hasFlash = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animHasArms")) {
            this.model.hasArms = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animLeftArmPos")) {
            this.model.leftArmPos = this.parseVector3f(split);
        } else if (split[0].equals("animLeftArmRot")) {
            this.model.leftArmRot = this.parseVector3f(split);
        } else if (split[0].equals("animLeftArmScale")) {
            this.model.leftArmScale = this.parseVector3f(split);
        } else if (split[0].equals("animRightArmPos")) {
            this.model.rightArmPos = this.parseVector3f(split);
        } else if (split[0].equals("animRightArmRot")) {
            this.model.rightArmRot = this.parseVector3f(split);
        } else if (split[0].equals("animRightArmScale")) {
            this.model.rightArmScale = this.parseVector3f(split);
        } else if (split[0].equals("animRightArmReloadPos")) {
            this.model.rightArmReloadPos = this.parseVector3f(split);
        } else if (split[0].equals("animRightArmReloadRot")) {
            this.model.rightArmReloadRot = this.parseVector3f(split);
        } else if (split[0].equals("animLeftArmReloadPos")) {
            this.model.leftArmReloadPos = this.parseVector3f(split);
        } else if (split[0].equals("animLeftArmReloadRot")) {
            this.model.leftArmReloadRot = this.parseVector3f(split);
        } else if (split[0].equals("animRightArmChargePos")) {
            this.model.rightArmChargePos = this.parseVector3f(split);
        } else if (split[0].equals("animRightArmChargeRot")) {
            this.model.rightArmChargeRot = this.parseVector3f(split);
        } else if (split[0].equals("animLeftArmChargePos")) {
            this.model.leftArmChargePos = this.parseVector3f(split);
        } else if (split[0].equals("animLeftArmChargeRot")) {
            this.model.leftArmChargeRot = this.parseVector3f(split);
        } else if (split[0].equals("animStagedRightArmReloadPos")) {
            this.model.stagedrightArmReloadPos = this.parseVector3f(split);
        } else if (split[0].equals("animStagedRightArmReloadRot")) {
            this.model.stagedrightArmReloadRot = this.parseVector3f(split);
        } else if (split[0].equals("animStagedLeftArmReloadPos")) {
            this.model.stagedleftArmReloadPos = this.parseVector3f(split);
        } else if (split[0].equals("animStagedLeftArmReloadRot")) {
            this.model.stagedleftArmReloadRot = this.parseVector3f(split);
        } else if (split[0].equals("animRightHandAmmo")) {
            this.model.rightHandAmmo = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animLeftHandAmmo")) {
            this.model.leftHandAmmo = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animGunSlideDistance")) {
            this.model.gunSlideDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animAltGunSlideDistance")) {
            this.model.altgunSlideDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animRecoilSlideDistance")) {
            this.model.RecoilSlideDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animRotatedSlideDistance")) {
            this.model.RotateSlideDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animShakeDistance")) {
            this.model.ShakeDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animRecoilAmount")) {
            this.model.recoilAmount = Float.parseFloat(split[1]);
        } else if (split[0].equals("animCasingAnimDistance")) {
            this.model.casingAnimDistance = this.parseVector3f(split);
        } else if (split[0].equals("animCasingAnimSpread")) {
            this.model.casingAnimSpread = this.parseVector3f(split);
        } else if (split[0].equals("animCasingAnimTime")) {
            this.model.casingAnimTime = Integer.parseInt(split[1]);
        } else if (split[0].equals("animCasingRotateVector")) {
            this.model.casingRotateVector = this.parseVector3f(split);
        } else if (split[0].equals("animCasingAttachPoint")) {
            this.model.casingAttachPoint = this.parseVector3f(split);
        } else if (split[0].equals("animCasingDelay")) {
            this.model.casingDelay = Integer.parseInt(split[1]);
        } else if (split[0].equals("animCasingScale")) {
            this.model.caseScale = Float.parseFloat(split[1]);
        } else if (split[0].equals("animFlashScale")) {
            this.model.flashScale = Float.parseFloat(split[1]);
        } else if (split[0].equals("animChargeHandleDistance")) {
            this.model.chargeHandleDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animChargeDelay")) {
            this.model.chargeDelay = Integer.parseInt(split[1]);
        } else if (split[0].equals("animChargeDelayAfterReload")) {
            this.model.chargeDelayAfterReload = Integer.parseInt(split[1]);
        } else if (split[0].equals("animChargeTime")) {
            this.model.chargeTime = Integer.parseInt(split[1]);
        } else if (split[0].equals("animCountOnRightHandSide")) {
            this.model.countOnRightHandSide = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animIsBulletCounterActive")) {
            this.model.isBulletCounterActive = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animIsAdvBulletCounterActive")) {
            this.model.isAdvBulletCounterActive = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animAnimationType")) {
            if (split[1].equals("NONE")) {
                this.model.animationType = EnumAnimationType.NONE;
            } else if (split[1].equals("BOTTOM_CLIP")) {
                this.model.animationType = EnumAnimationType.BOTTOM_CLIP;
            } else if (split[1].equals("CUSTOMBOTTOM_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMBOTTOM_CLIP;
            } else if (split[1].equals("PISTOL_CLIP")) {
                this.model.animationType = EnumAnimationType.PISTOL_CLIP;
            } else if (split[1].equals("CUSTOMPISTOL_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMPISTOL_CLIP;
            } else if (split[1].equals("TOP_CLIP")) {
                this.model.animationType = EnumAnimationType.TOP_CLIP;
            } else if (split[1].equals("CUSTOMTOP_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMTOP_CLIP;
            } else if (split[1].equals("SIDE_CLIP")) {
                this.model.animationType = EnumAnimationType.SIDE_CLIP;
            } else if (split[1].equals("CUSTOMSIDE_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMSIDE_CLIP;
            } else if (split[1].equals("P90")) {
                this.model.animationType = EnumAnimationType.P90;
            } else if (split[1].equals("CUSTOMP90")) {
                this.model.animationType = EnumAnimationType.CUSTOMP90;
            } else if (split[1].equals("SHOTGUN")) {
                this.model.animationType = EnumAnimationType.SHOTGUN;
            } else if (split[1].equals("CUSTOMSHOTGUN")) {
                this.model.animationType = EnumAnimationType.CUSTOMSHOTGUN;
            } else if (split[1].equals("RIFLE")) {
                this.model.animationType = EnumAnimationType.RIFLE;
            } else if (split[1].equals("CUSTOMRIFLE")) {
                this.model.animationType = EnumAnimationType.CUSTOMRIFLE;
            } else if (split[1].equals("REVOLVER")) {
                this.model.animationType = EnumAnimationType.REVOLVER;
            } else if (split[1].equals("CUSTOMREVOLVER")) {
                this.model.animationType = EnumAnimationType.CUSTOMREVOLVER;
            } else if (split[1].equals("REVOLVER2")) {
                this.model.animationType = EnumAnimationType.REVOLVER;
            } else if (split[1].equals("CUSTOMREVOLVER2")) {
                this.model.animationType = EnumAnimationType.CUSTOMREVOLVER;
            } else if (split[1].equals("END_LOADED")) {
                this.model.animationType = EnumAnimationType.END_LOADED;
            } else if (split[1].equals("CUSTOMEND_LOADED")) {
                this.model.animationType = EnumAnimationType.CUSTOMEND_LOADED;
            } else if (split[1].equals("RIFLE_TOP")) {
                this.model.animationType = EnumAnimationType.RIFLE_TOP;
            } else if (split[1].equals("CUSTOMRIFLE_TOP")) {
                this.model.animationType = EnumAnimationType.CUSTOMRIFLE_TOP;
            } else if (split[1].equals("BULLPUP")) {
                this.model.animationType = EnumAnimationType.BULLPUP;
            } else if (split[1].equals("CUSTOMBULLPUP")) {
                this.model.animationType = EnumAnimationType.CUSTOMBULLPUP;
            } else if (split[1].equals("ALT_PISTOL_CLIP")) {
                this.model.animationType = EnumAnimationType.ALT_PISTOL_CLIP;
            } else if (split[1].equals("CUSTOMALT_PISTOL_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMALT_PISTOL_CLIP;
            } else if (split[1].equals("GENERIC")) {
                this.model.animationType = EnumAnimationType.GENERIC;
            } else if (split[1].equals("CUSTOMGENERIC")) {
                this.model.animationType = EnumAnimationType.CUSTOMGENERIC;
            } else if (split[1].equals("BACK_LOADED")) {
                this.model.animationType = EnumAnimationType.BACK_LOADED;
            } else if (split[1].equals("CUSTOMBACK_LOADED")) {
                this.model.animationType = EnumAnimationType.CUSTOMBACK_LOADED;
            } else if (split[1].equals("STRIKER")) {
                this.model.animationType = EnumAnimationType.STRIKER;
            } else if (split[1].equals("CUSTOMSTRIKER")) {
                this.model.animationType = EnumAnimationType.CUSTOMSTRIKER;
            } else if (split[1].equals("BREAK_ACTION")) {
                this.model.animationType = EnumAnimationType.BREAK_ACTION;
            } else if (split[1].equals("CUSTOMBREAK_ACTION")) {
                this.model.animationType = EnumAnimationType.CUSTOMBREAK_ACTION;
            } else if (split[1].equals("CUSTOM")) {
                this.model.animationType = EnumAnimationType.CUSTOM;
            }
        } else if (split[0].equals("animMeleeAnimation")) {
            if (split[1].equals("DEFAULT")) {
                this.model.meleeAnimation = EnumMeleeAnimation.DEFAULT;
            } else if (split[1].equals("NONE")) {
                this.model.meleeAnimation = EnumMeleeAnimation.NONE;
            } else if (split[1].equals("BLUNT_SWING")) {
                this.model.meleeAnimation = EnumMeleeAnimation.BLUNT_SWING;
            } else if (split[1].equals("BLUNT_BASH")) {
                this.model.meleeAnimation = EnumMeleeAnimation.BLUNT_BASH;
            } else if (split[1].equals("STAB_UNDERARM")) {
                this.model.meleeAnimation = EnumMeleeAnimation.STAB_UNDERARM;
            } else if (split[1].equals("STAB_OVERARM")) {
                this.model.meleeAnimation = EnumMeleeAnimation.STAB_OVERARM;
            }
        } else if (split[0].equals("animTiltGunTime")) {
            this.model.tiltGunTime = Float.parseFloat(split[1]);
        } else if (split[0].equals("animUnloadClipTime")) {
            this.model.unloadClipTime = Float.parseFloat(split[1]);
        } else if (split[0].equals("animLoadClipTime")) {
            this.model.loadClipTime = Float.parseFloat(split[1]);
        } else if (split[0].equals("animScopeIsOnSlide")) {
            this.model.scopeIsOnSlide = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animScopeIsOnBreakAction")) {
            this.model.scopeIsOnBreakAction = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animNumBulletsInReloadAnimation")) {
            this.model.numBulletsInReloadAnimation = Float.parseFloat(split[1]);
        } else if (split[0].equals("animPumpDelay")) {
            this.model.pumpDelay = Integer.parseInt(split[1]);
        } else if (split[0].equals("animPumpDelayAfterReload")) {
            this.model.pumpDelayAfterReload = Integer.parseInt(split[1]);
        } else if (split[0].equals("animPumpTime")) {
            this.model.pumpTime = Integer.parseInt(split[1]);
        } else if (split[0].equals("animHammerDelay")) {
            this.model.hammerDelay = Integer.parseInt(split[1]);
        } else if (split[0].equals("animPumpHandleDistance")) {
            this.model.pumpHandleDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animEndLoadedAmmoDistance")) {
            this.model.endLoadedAmmoDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animBreakActionAmmoDistance")) {
            this.model.breakActionAmmoDistance = Float.parseFloat(split[1]);
        } else if (split[0].equals("animScopeIsOnBreakAction")) {
            this.model.scopeIsOnBreakAction = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animGripIsOnPump")) {
            this.model.gripIsOnPump = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animGadgetsOnPump")) {
            this.model.gripIsOnPump = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animBarrelBreakPoint")) {
            this.model.barrelBreakPoint = this.parseVector3f(split);
        } else if (split[0].equals("animAltBarrelBreakPoint")) {
            this.model.altbarrelBreakPoint = this.parseVector3f(split);
        } else if (split[0].equals("animRevolverFlipAngle")) {
            this.model.revolverFlipAngle = Float.parseFloat(split[1]);
        } else if (split[0].equals("animRevolver2FlipAngle")) {
            this.model.revolver2FlipAngle = Float.parseFloat(split[1]);
        } else if (split[0].equals("animRevolverFlipPoint")) {
            this.model.revolverFlipPoint = this.parseVector3f(split);
        } else if (split[0].equals("animRevolver2FlipPoint")) {
            this.model.revolver2FlipPoint = this.parseVector3f(split);
        } else if (split[0].equals("animBreakAngle")) {
            this.model.breakAngle = Float.parseFloat(split[1]);
        } else if (split[0].equals("animAltBreakAngle")) {
            this.model.altbreakAngle = Float.parseFloat(split[1]);
        } else if (split[0].equals("animSpinningCocking")) {
            this.model.spinningCocking = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animSpinPoint")) {
            this.model.spinPoint = this.parseVector3f(split);
        } else if (split[0].equals("animHammerSpinPoint")) {
            this.model.hammerSpinPoint = this.parseVector3f(split);
        } else if (split[0].equals("animAltHammerSpinPoint")) {
            this.model.althammerSpinPoint = this.parseVector3f(split);
        } else if (split[0].equals("animHammerAngle")) {
            this.model.hammerAngle = Float.parseFloat(split[1]);
        } else if (split[0].equals("animAltHammerAngle")) {
            this.model.althammerAngle = Float.parseFloat(split[1]);
        } else if (split[0].equals("animIsSingleAction")) {
            this.model.isSingleAction = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animSlideLockOnEmpty")) {
            this.model.slideLockOnEmpty = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animLeftHandPump")) {
            this.model.lefthandPump = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animRightHandPump")) {
            this.model.righthandPump = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animLeftHandCharge")) {
            this.model.leftHandCharge = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animRightHandCharge")) {
            this.model.rightHandCharge = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animLeftHandBolt")) {
            this.model.leftHandBolt = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animRightHandBolt")) {
            this.model.rightHandBolt = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animPumpModifier")) {
            this.model.pumpModifier = Float.parseFloat(split[1]);
        } else if (split[0].equals("animChargeModifier")) {
            this.model.chargeModifier = this.parseVector3f(split);
        } else if (split[0].equals("animGunOffset")) {
            this.model.gunOffset = Float.parseFloat(split[1]);
        } else if (split[0].equals("animCrouchZoom")) {
            this.model.crouchZoom = Float.parseFloat(split[1]);
        } else if (split[0].equals("animFancyStance")) {
            this.model.fancyStance = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animStanceTranslate")) {
            this.model.stanceTranslate = this.parseVector3f(split);
        } else if (split[0].equals("animStanceRotate")) {
            this.model.stanceRotate = this.parseVector3f(split);
        } else if (split[0].equals("animRotateGunVertical")) {
            this.model.rotateGunVertical = Float.parseFloat(split[1]);
        } else if (split[0].equals("animRotateGunHorizontal")) {
            this.model.rotateGunHorizontal = Float.parseFloat(split[1]);
        } else if (split[0].equals("animTiltGun")) {
            this.model.tiltGun = Float.parseFloat(split[1]);
        } else if (split[0].equals("animTranslateGun")) {
            this.model.translateGun = this.parseVector3f(split);
        } else if (split[0].equals("animRotateClipVertical")) {
            this.model.rotateClipVertical = Float.parseFloat(split[1]);
        } else if (split[0].equals("animStagedRotateClipVertical")) {
            this.model.stagedrotateClipVertical = Float.parseFloat(split[1]);
        } else if (split[0].equals("animRotateClipHorizontal")) {
            this.model.rotateClipVertical = Float.parseFloat(split[1]);
        } else if (split[0].equals("animStagedRotateClipHorizontal")) {
            this.model.stagedrotateClipVertical = Float.parseFloat(split[1]);
        } else if (split[0].equals("animTiltClip")) {
            this.model.tiltClip = Float.parseFloat(split[1]);
        } else if (split[0].equals("animStagedTiltClip")) {
            this.model.stagedtiltClip = Float.parseFloat(split[1]);
        } else if (split[0].equals("animTranslateClip")) {
            this.model.translateClip = this.parseVector3f(split);
        } else if (split[0].equals("animStagedTranslateClip")) {
            this.model.stagedtranslateClip = this.parseVector3f(split);
        } else if (split[0].equals("animStagedReload")) {
            this.model.stagedReload = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animThirdPersonOffset")) {
            this.model.thirdPersonOffset = this.parseVector3f(split);
        } else if (split[0].equals("animItemFrameOffset")) {
            this.model.itemFrameOffset = this.parseVector3f(split);
        } else if (split[0].equals("animStillRenderGunWhenScopedOverlay")) {
            this.model.stillRenderGunWhenScopedOverlay = Boolean.parseBoolean(split[1]);
        } else if (split[0].equals("animAdsEffectMultiplier")) {
            this.model.adsEffectMultiplier = Float.parseFloat(split[1]);
        }
    }

    public boolean isAmmo(ShootableType type) {
        return this.ammo.contains(type);
    }

    public boolean isAmmo(ShootableType type, ItemStack stack) {
        boolean result = this.ammo.contains(type);
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            ArrayList<ShootableType> t = new ArrayList<ShootableType>();
            for (String s : this.getGrip((ItemStack)stack).secondaryAmmo) {
                ShootableType shoot = ShootableType.getShootableType(s);
                if (type == null) continue;
                t.add(shoot);
            }
            result = t.contains(type);
        }
        return result;
    }

    public Vector3f parseVector3f(String[] inp) {
        return new Vector3f(Float.parseFloat(inp[1]), Float.parseFloat(inp[2]), Float.parseFloat(inp[3]));
    }

    public boolean isAmmo(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBullet) {
            return this.isAmmo(((ItemBullet)stack.func_77973_b()).type, stack);
        }
        if (stack.func_77973_b() instanceof ItemGrenade) {
            return this.isAmmo(((ItemGrenade)stack.func_77973_b()).type, stack);
        }
        return false;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelGun.class);
        this.deployableModel = FlansMod.proxy.loadModel(this.deployableModelString, this.shortName, ModelMG.class);
        this.casingModel = FlansMod.proxy.loadModel(this.casingModelString, this.shortName, ModelCasing.class);
        this.flashModel = FlansMod.proxy.loadModel(this.flashModelString, this.shortName, ModelFlash.class);
    }

    @Override
    public float getZoomFactor() {
        return this.zoomLevel;
    }

    @Override
    public boolean hasZoomOverlay() {
        return this.hasScopeOverlay;
    }

    @Override
    public String getZoomOverlay() {
        return this.defaultScopeTexture;
    }

    @Override
    public float getFOVFactor() {
        return this.FOVFactor;
    }

    public IScope getCurrentScope(ItemStack gunStack) {
        AttachmentType attachedScope = this.getScope(gunStack);
        return attachedScope == null ? this : attachedScope;
    }

    public ArrayList<AttachmentType> getCurrentAttachments(ItemStack gun) {
        this.checkForTags(gun);
        ArrayList<AttachmentType> attachments = new ArrayList<AttachmentType>();
        NBTTagCompound attachmentTags = gun.field_77990_d.func_74775_l("attachments");
        NBTTagList genericsList = attachmentTags.func_150295_c("generics", 10);
        for (int i = 0; i < this.numGenericAttachmentSlots; ++i) {
            this.appendToList(gun, "generic_" + i, attachments);
        }
        this.appendToList(gun, "barrel", attachments);
        this.appendToList(gun, "scope", attachments);
        this.appendToList(gun, "stock", attachments);
        this.appendToList(gun, "grip", attachments);
        this.appendToList(gun, "gadget", attachments);
        this.appendToList(gun, "slide", attachments);
        this.appendToList(gun, "pump", attachments);
        this.appendToList(gun, "accessory", attachments);
        return attachments;
    }

    private void appendToList(ItemStack gun, String name, ArrayList<AttachmentType> attachments) {
        AttachmentType type = this.getAttachment(gun, name);
        if (type != null) {
            attachments.add(type);
        }
    }

    public AttachmentType getBarrel(ItemStack gun) {
        return this.getAttachment(gun, "barrel");
    }

    public AttachmentType getScope(ItemStack gun) {
        return this.getAttachment(gun, "scope");
    }

    public AttachmentType getStock(ItemStack gun) {
        return this.getAttachment(gun, "stock");
    }

    public AttachmentType getGrip(ItemStack gun) {
        return this.getAttachment(gun, "grip");
    }

    public AttachmentType getGadget(ItemStack gun) {
        return this.getAttachment(gun, "gadget");
    }

    public AttachmentType getSlide(ItemStack gun) {
        return this.getAttachment(gun, "slide");
    }

    public AttachmentType getPump(ItemStack gun) {
        return this.getAttachment(gun, "pump");
    }

    public AttachmentType getAccessory(ItemStack gun) {
        return this.getAttachment(gun, "accessory");
    }

    public AttachmentType getGeneric(ItemStack gun, int i) {
        return this.getAttachment(gun, "generic_" + i);
    }

    public ItemStack getBarrelItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "barrel");
    }

    public ItemStack getScopeItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "scope");
    }

    public ItemStack getStockItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "stock");
    }

    public ItemStack getGripItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "grip");
    }

    public ItemStack getGadgetItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "gadget");
    }

    public ItemStack getSlideItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "slide");
    }

    public ItemStack getPumpItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "pump");
    }

    public ItemStack getAccessoryItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "accessory");
    }

    public ItemStack getGenericItemStack(ItemStack gun, int i) {
        return this.getAttachmentItemStack(gun, "generic_" + i);
    }

    public AttachmentType getAttachment(ItemStack gun, String name) {
        if (gun == null || !(gun.func_77973_b() instanceof ItemGun)) {
            return null;
        }
        this.checkForTags(gun);
        return AttachmentType.getFromNBT(gun.field_77990_d.func_74775_l("attachments").func_74775_l(name));
    }

    public ItemStack getAttachmentItemStack(ItemStack gun, String name) {
        this.checkForTags(gun);
        return ItemStack.func_77949_a((NBTTagCompound)gun.field_77990_d.func_74775_l("attachments").func_74775_l(name));
    }

    public void checkForTags(ItemStack gun) {
        if (!gun.func_77942_o()) {
            gun.field_77990_d = new NBTTagCompound();
        }
        if (!gun.field_77990_d.func_74764_b("attachments")) {
            NBTTagCompound attachmentTags = new NBTTagCompound();
            for (int i = 0; i < this.numGenericAttachmentSlots; ++i) {
                attachmentTags.func_74782_a("generic_" + i, (NBTBase)new NBTTagCompound());
            }
            attachmentTags.func_74782_a("barrel", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("scope", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("stock", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("grip", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("gadget", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("slide", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("pump", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("accessory", (NBTBase)new NBTTagCompound());
            gun.field_77990_d.func_74782_a("attachments", (NBTBase)attachmentTags);
        }
    }

    public float getMeleeDamage(ItemStack stack, boolean driveable) {
        float stackMeleeDamage = this.meleeDamage;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackMeleeDamage *= attachment.meleeDamageMultiplier;
        }
        return stackMeleeDamage * (driveable ? this.meleeDamageDriveableModifier : 1.0f);
    }

    public float getDamage(ItemStack stack) {
        float stackDamage = this.damage;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackDamage = this.getGrip((ItemStack)stack).secondaryDamage;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackDamage *= attachment.damageMultiplier;
        }
        return stackDamage;
    }

    public float getSpread(ItemStack stack, boolean sneaking, boolean sprinting) {
        float stackSpread = this.bulletSpread;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackSpread = this.getGrip((ItemStack)stack).secondarySpread;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackSpread *= attachment.spreadMultiplier;
        }
        if (sprinting) {
            stackSpread *= this.sprintSpreadMultiplier;
        } else if (sneaking) {
            stackSpread *= this.sneakSpreadMultiplier;
        }
        return stackSpread;
    }

    public float getDefaultSpread(ItemStack stack) {
        float stackSpread = this.defaultSpread;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackSpread = this.getGrip((ItemStack)stack).secondaryDefaultSpread;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackSpread *= attachment.spreadMultiplier;
        }
        return stackSpread;
    }

    public float getRecoilDisplay(ItemStack stack) {
        float stackRecoil = this.recoilPitch;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoil *= attachment.recoilMultiplier;
        }
        return stackRecoil;
    }

    public float getRecoilPitch(ItemStack stack, boolean sneaking, boolean sprinting) {
        float stackRecoil = this.recoilPitch + rand.nextFloat() * this.rndRecoilPitchRange;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoil *= attachment.recoilMultiplier;
        }
        if (sneaking) {
            stackRecoil = this.decreaseRecoilPitch != 0.0f ? (stackRecoil -= this.decreaseRecoilPitch) : (this.recoilSneakingMultiplier == -1.0f ? (stackRecoil < 0.5f ? 0.0f : stackRecoil - 0.5f) : (stackRecoil *= this.recoilSneakingMultiplier));
        } else if (sprinting) {
            stackRecoil *= this.recoilSprintingMultiplier;
        }
        return stackRecoil;
    }

    public float getRecoilYaw(ItemStack stack, boolean sneaking, boolean sprinting) {
        float stackRecoilYaw = this.recoilYaw + (rand.nextFloat() - 0.5f) * this.rndRecoilYawRange;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoilYaw *= attachment.recoilMultiplier;
        }
        if (sneaking) {
            stackRecoilYaw = this.decreaseRecoilYaw < 0.0f ? (stackRecoilYaw /= this.decreaseRecoilYaw) : (stackRecoilYaw *= this.recoilSneakingMultiplierYaw);
        } else if (sprinting) {
            stackRecoilYaw *= this.recoilSprintingMultiplierYaw;
        }
        return stackRecoilYaw;
    }

    public float getBulletSpeed(ItemStack stack, ItemStack bulletStack) {
        float stackBulletSpeed = bulletStack != null && bulletStack.func_77973_b() != null && bulletStack.func_77973_b() instanceof ItemBullet ? this.bulletSpeed * ((ItemBullet)bulletStack.func_77973_b()).type.speedMultiplier : this.bulletSpeed;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackBulletSpeed = this.getGrip((ItemStack)stack).secondarySpeed;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackBulletSpeed *= attachment.bulletSpeedMultiplier;
        }
        return stackBulletSpeed;
    }

    public float getBulletSpeed(ItemStack stack) {
        float stackBulletSpeed = this.bulletSpeed;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackBulletSpeed = this.getGrip((ItemStack)stack).secondarySpeed;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackBulletSpeed *= attachment.bulletSpeedMultiplier;
        }
        return stackBulletSpeed;
    }

    public float getReloadTime(ItemStack stack) {
        float stackReloadTime = this.reloadTime;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackReloadTime = this.getGrip((ItemStack)stack).secondaryReloadTime;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackReloadTime *= attachment.reloadTimeMultiplier;
        }
        return stackReloadTime;
    }

    public float getShootDelay(ItemStack stack) {
        float fireTicks;
        if (this.shootDelay != 0.0f) {
            float fireRate = this.shootDelay;
            if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
                fireRate = this.getGrip((ItemStack)stack).secondaryShootDelay;
            }
            return fireRate;
        }
        float fireRate = this.roundsPerMin;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            fireRate = this.getGrip((ItemStack)stack).secondaryShootDelay;
        }
        fireRate = fireTicks = 1200.0f / fireRate;
        return fireRate;
    }

    public float getShootDelay() {
        if (this.shootDelay != 0.0f) {
            return this.shootDelay;
        }
        return 1200.0f / this.roundsPerMin;
    }

    public int getNumBullets(ItemStack stack) {
        int amount = this.numBullets;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            amount = this.getGrip((ItemStack)stack).secondaryNumBullets;
        }
        return amount;
    }

    public float getMovementSpeed(ItemStack stack) {
        float stackMovement = this.moveSpeedModifier;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackMovement *= attachment.moveSpeedMultiplier;
        }
        return stackMovement;
    }

    public float getRecoilControl(ItemStack stack, boolean isSprinting, boolean isSneaking) {
        float control = isSprinting ? this.recoilCounterCoefficientSprinting : (isSneaking ? this.recoilCounterCoefficientSneaking : this.recoilCounterCoefficient);
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            if (isSprinting) {
                control *= attachment.recoilControlMultiplierSprinting;
                continue;
            }
            if (isSneaking) {
                control *= attachment.recoilControlMultiplierSneaking;
                continue;
            }
            control *= attachment.recoilControlMultiplier;
        }
        return Math.max(0.0f, Math.min(1.0f, control));
    }

    public void setFireMode(ItemStack stack, int fireMode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (fireMode < EnumFireMode.values().length) {
            stack.func_77978_p().func_74774_a("GunMode", (byte)fireMode);
        } else {
            stack.func_77978_p().func_74774_a("GunMode", (byte)this.mode.ordinal());
        }
    }

    public EnumFireMode getFireMode(ItemStack stack) {
        byte gm;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            return this.getGrip((ItemStack)stack).secondaryFireMode;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            if (attachment.modeOverride == null) continue;
            return attachment.modeOverride;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("GunMode") && (gm = stack.func_77978_p().func_74771_c("GunMode")) < EnumFireMode.values().length) {
            for (EnumFireMode enumFireMode : this.submode) {
                if (gm != enumFireMode.ordinal()) continue;
                return EnumFireMode.values()[gm];
            }
        }
        this.setFireMode(stack, this.mode.ordinal());
        return this.mode;
    }

    public void setSecondaryFire(ItemStack stack, boolean mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a("secondaryFire", mode);
    }

    public boolean getSecondaryFire(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("secondaryFire")) {
            stack.field_77990_d.func_74757_a("secondaryFire", false);
            return stack.func_77978_p().func_74767_n("secondaryFire");
        }
        return stack.func_77978_p().func_74767_n("secondaryFire");
    }

    public int getNumAmmoItemsInGun(ItemStack stack) {
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            return this.getGrip((ItemStack)stack).numSecAmmoItems;
        }
        return this.numPrimaryAmmoItems;
    }

    public static GunType getGun(String s) {
        return guns.get(s);
    }

    public Paintjob getPaintjob(String s) {
        for (Paintjob paintjob : this.paintjobs) {
            if (!paintjob.iconName.equals(s)) continue;
            return paintjob;
        }
        return this.defaultPaintjob;
    }

    public boolean getShouldShowMuzzleFlash() {
        return this.useMuzzleFlashDefaults != false ? FlansMod.showMuzzleFlashParticlesDefault : this.showMuzzleFlashParticles;
    }

    @Override
    public float GetRecommendedScale() {
        return 60.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }

    public GunRecoil getRecoil(ItemStack stack) {
        GunRecoil stackRecoil = this.recoil.copy();
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoil.applyModifier(attachment.recoilMultiplier);
        }
        return stackRecoil;
    }

    public static class GunRecoil {
        public static final Random rand = new Random();
        public float vertical;
        public float horizontal;
        public float recovery;
        public float recoveryScope;
        public float fall;
        public float increase;
        public float sneak;
        public float speed;
        public float sprayLength;
        public float antiRecoil;

        public GunRecoil(float vertical, float horizontal, float recovery, float recoveryScope, float fall, float increase, float sneak, float speed) {
            this.vertical = vertical;
            this.horizontal = horizontal;
            this.recovery = recovery;
            this.recoveryScope = recoveryScope;
            this.fall = fall;
            this.increase = increase;
            this.sneak = sneak;
            this.speed = speed;
        }

        public GunRecoil() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        public GunRecoil(GunRecoil gunRecoil) {
            this(gunRecoil.vertical, gunRecoil.horizontal, gunRecoil.recovery, gunRecoil.recoveryScope, gunRecoil.fall, gunRecoil.increase, gunRecoil.sneak, gunRecoil.speed);
        }

        public GunRecoil read(String[] split) {
            this.vertical = this.read(split, 1, this.vertical);
            this.horizontal = this.read(split, 2, this.horizontal);
            this.recovery = this.read(split, 3, this.recovery);
            this.recoveryScope = this.read(split, 4, this.recoveryScope);
            this.fall = this.read(split, 5, this.fall);
            this.increase = this.read(split, 6, this.increase);
            this.sneak = this.read(split, 7, this.sneak);
            this.speed = this.read(split, 8, this.speed);
            if (split.length < 2) {
                this.horizontal = this.vertical * 0.3f;
            }
            return this;
        }

        private float read(String[] split, int i, float alt) {
            return split.length > i ? Float.parseFloat(split[i].indexOf(61) == -1 ? split[i] : split[i].substring(split[i].indexOf(61) + 1)) : alt;
        }

        public GunRecoil copy() {
            String rc = "Recoil 1.9 horizontal=1.9 recovery=1 recoveryScope=1 fall=0.9 increase=2 sneak=1 speed=1.2";
            return new GunRecoil(this);
        }

        public void applyModifier(float recoilMultiplier) {
            this.vertical *= recoilMultiplier;
            this.horizontal *= recoilMultiplier;
        }

        public void addRecoil(GunRecoil recoil) {
            this.vertical += recoil.vertical;
            this.horizontal += 0.2f * (float)(rand.nextBoolean() ? -1 : 1) * recoil.horizontal;
            this.recovery = recoil.recovery;
            this.recoveryScope = recoil.recoveryScope;
            this.increase = recoil.increase;
            this.sneak = recoil.sneak;
            this.fall = recoil.fall;
            this.speed = recoil.speed;
            this.sprayLength = (float)((double)this.sprayLength + 0.05);
            this.vertical *= 1.0f + this.sprayLength * 2.0f * recoil.increase;
            this.horizontal *= 1.0f + this.sprayLength * 2.0f * recoil.increase;
            this.antiRecoil *= rand.nextFloat() * 0.1f;
        }

        public float update(boolean sneaking, boolean scoping, float playerSpeed) {
            float recov = 0.5f * this.recovery;
            if (sneaking) {
                recov *= 0.9f * this.sneak;
            }
            if (scoping) {
                recov *= 0.8f * this.recoveryScope;
            }
            if (this.vertical > 0.0f) {
                this.vertical *= recov;
            }
            if (this.horizontal != 0.0f) {
                this.horizontal *= recov;
            }
            this.sprayLength *= 0.95f;
            if (playerSpeed > 0.0f) {
                float speedMod = 1.0f + playerSpeed * this.speed;
                this.vertical *= speedMod;
                this.horizontal *= speedMod;
            }
            float anti = this.antiRecoil * 0.2f;
            this.antiRecoil *= 0.8f;
            this.antiRecoil += this.vertical * Math.max(0.0f, Math.min(1.0f, 1.0f - rand.nextFloat() * 0.2f - (this.fall - 1.0f)));
            float add = -this.vertical + anti;
            return add;
        }
    }
}

