/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest;

import com.chocolate.chocolateQuest.entity.npc.EntityHumanNPC;
import com.chocolate.chocolateQuest.quest.DialogAction;
import com.chocolate.chocolateQuest.quest.DialogCondition;
import com.chocolate.chocolateQuest.quest.DialogManager;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DialogOption {
    public int id;
    public String folder = "Quest/lang/default";
    public String name = "";
    public String prompt = "";
    public String[] text;
    public DialogOption[] options;
    public List<DialogAction> actions;
    public List<DialogCondition> conditions;

    public DialogOption() {
    }

    public DialogOption(DialogOption[] options, String name) {
        this();
        this.options = options;
        this.name = name;
    }

    public void setID(int id) {
        this.id = id;
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                this.options[i].setID(i);
            }
        }
    }

    public void execute(EntityPlayer player, EntityHumanNPC npc) {
        if (this.actions != null) {
            for (DialogAction action : this.actions) {
                boolean shouldExecuteAction = true;
                if (action.conditions != null) {
                    for (DialogCondition condition : action.conditions) {
                        if (condition.matches(player, npc)) continue;
                        shouldExecuteAction = false;
                        break;
                    }
                }
                if (!shouldExecuteAction) continue;
                action.execute(player, npc);
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list;
        tag.func_74778_a("Name", this.name);
        tag.func_74778_a("Folder", this.folder);
        if (this.options != null) {
            list = new NBTTagList();
            for (DialogOption option : this.options) {
                NBTTagCompound optionTag = new NBTTagCompound();
                option.writeToNBT(optionTag);
                list.func_74742_a((NBTBase)optionTag);
            }
            tag.func_74782_a("Options", (NBTBase)list);
        }
        if (this.actions != null) {
            list = new NBTTagList();
            for (DialogAction action : this.actions) {
                NBTTagCompound actionTag = new NBTTagCompound();
                action.writeToNBT(actionTag);
                list.func_74742_a((NBTBase)actionTag);
            }
            tag.func_74782_a("Actions", (NBTBase)list);
        }
        if (this.conditions != null) {
            list = new NBTTagList();
            for (DialogCondition condition : this.conditions) {
                NBTTagCompound conditionTag = new NBTTagCompound();
                condition.writeToNBT(conditionTag);
                list.func_74742_a((NBTBase)conditionTag);
            }
            tag.func_74782_a("Conditions", (NBTBase)list);
        }
        tag.func_74768_a("ID", this.id);
    }

    public void readFromNBT(NBTTagCompound tag) {
        int i;
        int optionCount;
        NBTTagList list;
        this.name = tag.func_74779_i("Name");
        this.folder = tag.func_74779_i("Folder");
        if (tag.func_74764_b("Options")) {
            list = (NBTTagList)tag.func_74781_a("Options");
            optionCount = list.func_74745_c();
            this.options = new DialogOption[optionCount];
            for (i = 0; i < optionCount; ++i) {
                this.options[i] = new DialogOption();
                this.options[i].readFromNBT(list.func_150305_b(i));
            }
        }
        if (tag.func_74764_b("Actions")) {
            list = (NBTTagList)tag.func_74781_a("Actions");
            optionCount = list.func_74745_c();
            for (i = 0; i < optionCount; ++i) {
                this.addAction(DialogAction.getFromNBT(list.func_150305_b(i)));
            }
        }
        if (tag.func_74764_b("Conditions")) {
            list = (NBTTagList)tag.func_74781_a("Conditions");
            optionCount = list.func_74745_c();
            for (i = 0; i < optionCount; ++i) {
                this.addCondition(DialogCondition.getFromNBT(list.func_150305_b(i)));
            }
        }
        this.id = tag.func_74762_e("ID");
    }

    public String toString() {
        return this.name;
    }

    public void addDialog(DialogOption newDialog) {
        if (this.options == null) {
            this.options = new DialogOption[]{newDialog};
        } else {
            DialogOption[] newOptions = new DialogOption[this.options.length + 1];
            for (int i = 0; i < this.options.length; ++i) {
                newOptions[i] = this.options[i];
            }
            newOptions[this.options.length] = newDialog;
            this.options = newOptions;
        }
    }

    public void removeDialog(DialogOption newDialog) {
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                if (newDialog != this.options[i]) continue;
                this.options[i] = null;
            }
            DialogOption[] newOptions = new DialogOption[this.options.length - 1];
            int cont = 0;
            for (int i = 0; i < this.options.length; ++i) {
                if (null == this.options[i]) continue;
                newOptions[cont] = this.options[i];
                ++cont;
            }
            this.options = newOptions;
        }
    }

    public void addAction(DialogAction newDialog) {
        if (this.actions == null) {
            this.actions = new ArrayList<DialogAction>();
        }
        this.actions.add(newDialog);
    }

    public void removeAction(DialogAction newDialog) {
        if (this.actions != null) {
            this.actions.remove(newDialog);
            if (this.actions.isEmpty()) {
                this.actions = null;
            }
        }
    }

    public void addCondition(DialogCondition newDialog) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<DialogCondition>();
        }
        this.conditions.add(newDialog);
    }

    public void removeCondition(DialogCondition condition) {
        if (this.conditions != null) {
            this.conditions.remove(condition);
            if (this.conditions.isEmpty()) {
                this.conditions = null;
            }
        }
    }

    public void replaceKeys(String playerName, EntityHumanNPC npc) {
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = this.replaceKeys(this.text[i], playerName, npc);
        }
        this.prompt = this.replaceKeys(this.prompt, playerName, npc);
    }

    public String replaceKeys(String s, String playerName, EntityHumanNPC npc) {
        if (s.contains("@sp")) {
            s = s.replaceAll("@sp", playerName);
        }
        if (s.contains("@name")) {
            s = s.replaceAll("@name", npc.func_70005_c_());
        }
        return s;
    }

    public void readText(String lang) {
        DialogManager.readText(lang, this);
    }

    public String getDefaultFileName() {
        return BDHelper.getInfoDir() + this.folder + "/default/" + this.name + ".dialog";
    }

    public void saveText() {
        DialogManager.saveText(this);
    }

    public DialogOption copy() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        DialogOption option = new DialogOption();
        option.readFromNBT(tag);
        return option;
    }
}

