/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.magic;

import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.magic.SpellProjectile;
import com.chocolate.chocolateQuest.utils.HelperPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class SpellHeal
extends SpellProjectile {
    @Override
    public void onShoot(EntityLivingBase shooter, Elements element, ItemStack is, int chargeTime) {
        World world = shooter.field_70170_p;
        EntityLivingBase target = null;
        if (shooter instanceof EntityPlayer) {
            MovingObjectPosition mop = HelperPlayer.getMovingObjectPositionFromPlayer(shooter, world, 15 + this.getExpansion(is) * 10);
            if (mop != null) {
                target = mop.field_72308_g;
            }
        } else {
            target = this.getRecomendedTarget((EntityHumanBase)shooter);
        }
        if (!world.field_72995_K && target instanceof EntityLivingBase) {
            int type = this.getType();
            EntityBaseBall ball = new EntityBaseBall(world, target, 9, 2, element);
            ball.setDamageMultiplier(this.getDamage(is) * 0.25f);
            ball.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v);
            world.func_72838_d((Entity)ball);
        }
    }

    @Override
    public boolean shouldStartCasting(ItemStack is, EntityLivingBase shooter, Entity target) {
        if (shooter instanceof EntityHumanBase) {
            return this.getRecomendedTarget((EntityHumanBase)shooter) != null;
        }
        return false;
    }

    public EntityLivingBase getRecomendedTarget(EntityHumanBase shooter) {
        EntityHumanBase entity = null;
        double minHealth = 99999.0;
        if (shooter.party != null) {
            for (int i = 0; i < shooter.party.getMembersLength(); ++i) {
                double health;
                EntityHumanBase ally = shooter.party.getMember(i);
                if (ally == null || !((health = (double)ally.func_110143_aJ()) < (double)ally.func_110138_aP()) || !(health < minHealth)) continue;
                minHealth = health;
                entity = ally;
            }
            EntityHumanBase ally = shooter.party.getLeader();
            double health = ally.func_110143_aJ();
            if (health < (double)ally.func_110138_aP() && health < minHealth) {
                minHealth = health;
                entity = ally;
            }
        } else {
            double health = shooter.func_110143_aJ();
            if (health < (double)shooter.func_110138_aP()) {
                return shooter;
            }
        }
        return entity;
    }

    @Override
    public float getCost(ItemStack itemstack) {
        return 12.0f;
    }

    @Override
    public int getRange(ItemStack itemstack) {
        return 64;
    }

    @Override
    public int getCoolDown() {
        return 15;
    }

    @Override
    public boolean isSupportSpell() {
        return true;
    }
}

