/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.gui.guinpc;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.gui.GuiButtonIcon;
import com.chocolate.chocolateQuest.gui.GuiHumanBase;
import com.chocolate.chocolateQuest.gui.GuiInventoryPlayer;
import com.chocolate.chocolateQuest.gui.guinpc.ContainerAwakement;
import com.chocolate.chocolateQuest.gui.guinpc.GuiButtonAwakements;
import com.chocolate.chocolateQuest.gui.guinpc.InventoryAwakement;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.packets.PacketUpdateAwakement;
import com.chocolate.chocolateQuest.packets.PacketUpdateConversation;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiAwakement
extends GuiInventoryPlayer {
    InventoryAwakement inventory;
    GuiButtonAwakements[] enchantButtons;
    ContainerAwakement containerSlots = (ContainerAwakement)this.field_147002_h;
    GuiButton scrollUp;
    GuiButton scrollDown;
    int UP = 1000;
    int DOWN = 1001;
    int scrollAmmount = 0;
    int type;
    int maxLevel = 0;

    public GuiAwakement(InventoryAwakement awInv, EntityPlayer player, int type, int level) {
        super(new ContainerAwakement((IInventory)player.field_71071_by, awInv, type, level), awInv, player);
        this.inventory = awInv;
        this.type = type;
        this.maxLevel = level;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int width = (this.field_146294_l - this.field_146999_f) / 2;
        int height = (this.field_146295_m - this.field_147000_g) / 2;
        int ENCHANTS = 4;
        int BUTTON_HEIGHT = 20;
        int BUTTON_WIDTH = 120;
        this.enchantButtons = new GuiButtonAwakements[ENCHANTS];
        for (int i = 0; i < ENCHANTS; ++i) {
            this.enchantButtons[i] = new GuiButtonAwakements(i, width + 60, height + BUTTON_HEIGHT * i, BUTTON_WIDTH, BUTTON_HEIGHT, " ");
            this.enchantButtons[i].disable();
            this.field_146292_n.add(this.enchantButtons[i]);
        }
        int scrollX = width + BUTTON_WIDTH + 44;
        this.scrollUp = new GuiButtonIcon(this.UP, scrollX, height - 8, 15.0f, 7.0f, 1.0f, 0.5f, "");
        this.field_146292_n.add(this.scrollUp);
        this.scrollUp.field_146125_m = false;
        this.scrollDown = new GuiButtonIcon(this.DOWN, scrollX, height + BUTTON_HEIGHT * 4, 15.0f, 7.5f, 1.0f, 0.5f, "");
        this.field_146292_n.add(this.scrollDown);
        this.scrollDown.field_146125_m = false;
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k < 256) {
            ((ContainerAwakement)this.field_147002_h).enchantItem(button.field_146127_k);
            PacketUpdateAwakement packet = new PacketUpdateAwakement(button.field_146127_k);
            ChocolateQuest.channel.sendPaquetToServer(packet);
        } else if (button.field_146127_k == this.UP && this.scrollAmmount > 0) {
            --this.scrollAmmount;
        } else if (button.field_146127_k == this.DOWN) {
            ++this.scrollAmmount;
        }
        this.updateButtons();
    }

    @Override
    protected void func_146984_a(Slot slot, int slotID, int x, int y) {
        super.func_146984_a(slot, slotID, x, y);
        this.updateButtons();
    }

    public void updateButtons() {
        ItemStack is = this.inventory.func_70301_a(0);
        if (is != null) {
            if (this.containerSlots.mode) {
                this.updateButtonsEnchantment(is);
            } else {
                this.updateButtonsAwakement(is);
            }
        } else {
            for (int i = 0; i < this.enchantButtons.length; ++i) {
                this.enchantButtons[i].field_146126_j = "";
                this.enchantButtons[i].xpRequired = 0;
                this.enchantButtons[i].field_146124_l = false;
            }
        }
    }

    public void updateButtonsEnchantment(ItemStack is) {
        int count = 0;
        int expRequired = this.containerSlots.getXPRequiredToEnchantItem();
        for (Enchantment aw : Enchantment.field_77331_b) {
            if (aw == null || !aw.func_92089_a(is) || EnchantmentHelper.func_77506_a((int)aw.field_77352_x, (ItemStack)is) >= aw.func_77325_b()) continue;
            ++count;
        }
        Enchantment[] enchantments = new Enchantment[count];
        count = 0;
        for (Enchantment enchantment : Enchantment.field_77331_b) {
            if (enchantment == null || !enchantment.func_92089_a(is) || EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)is) >= enchantment.func_77325_b()) continue;
            enchantments[count] = enchantment;
            ++count;
        }
        this.handleScroll(count);
        Map itemEnchantmentsMap = EnchantmentHelper.func_82781_a((ItemStack)is);
        for (int i = 0; i < this.enchantButtons.length; ++i) {
            int index = i + this.scrollAmmount;
            if (index < enchantments.length) {
                boolean canEnchant;
                int currentID = enchantments[index].field_77352_x;
                int level = EnchantmentHelper.func_77506_a((int)enchantments[index].field_77352_x, (ItemStack)is) + 1;
                int xp = expRequired + this.containerSlots.getXPRequiredForEnchantment(this.enchantButtons[i].field_146127_k, level);
                xp -= this.containerSlots.getCatalystRebate(xp);
                this.enchantButtons[i].field_146127_k = currentID;
                this.enchantButtons[i].field_146126_j = enchantments[index].func_77316_c(level);
                this.enchantButtons[i].xpRequired = xp;
                boolean bl = canEnchant = (this.player.field_71068_ca >= expRequired || this.player.field_71075_bZ.field_75098_d) && xp <= this.maxLevel;
                if (canEnchant) {
                    Iterator iterator = itemEnchantmentsMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        int enchantmentID = (Integer)iterator.next();
                        if (enchantmentID == currentID || enchantments[index].func_77326_a(Enchantment.field_77331_b[enchantmentID])) continue;
                        canEnchant = false;
                    }
                }
                if (!canEnchant) {
                    this.enchantButtons[i].field_146124_l = false;
                    continue;
                }
                this.enchantButtons[i].field_146124_l = true;
                continue;
            }
            this.enchantButtons[i].disable();
        }
    }

    public void updateButtonsAwakement(ItemStack is) {
        int count = 0;
        int expRequired = this.containerSlots.getXPRequiredToEnchantItem();
        for (Awakements aw : Awakements.awekements) {
            if (!aw.canBeUsedOnItem(is) || Awakements.getEnchantLevel(is, aw) >= aw.getMaxLevel() || !aw.canBeAddedByNPC(this.type)) continue;
            ++count;
        }
        Awakements[] awakements = new Awakements[count];
        count = 0;
        for (Awakements aw : Awakements.awekements) {
            if (!aw.canBeUsedOnItem(is) || Awakements.getEnchantLevel(is, aw) >= aw.getMaxLevel() || !aw.canBeAddedByNPC(this.type)) continue;
            awakements[count] = aw;
            ++count;
        }
        this.handleScroll(count);
        for (int i = 0; i < this.enchantButtons.length; ++i) {
            int index = i + this.scrollAmmount;
            if (index < awakements.length) {
                boolean canEnchant;
                int xp = expRequired + this.containerSlots.getXPRequiredForEnchantment(this.enchantButtons[i].field_146127_k, Awakements.getEnchantLevel(is, awakements[index]) + 1);
                xp -= this.containerSlots.getCatalystRebate(xp);
                this.enchantButtons[i].field_146127_k = awakements[index].id;
                this.enchantButtons[i].field_146126_j = awakements[index].getName();
                this.enchantButtons[i].xpRequired = xp;
                boolean bl = canEnchant = (this.player.field_71068_ca >= expRequired || this.player.field_71075_bZ.field_75098_d) && xp <= this.maxLevel;
                if (!canEnchant) {
                    this.enchantButtons[i].field_146124_l = false;
                    continue;
                }
                this.enchantButtons[i].field_146124_l = true;
                continue;
            }
            this.enchantButtons[i].disable();
        }
    }

    public void handleScroll(int entries) {
        this.scrollDown.field_146125_m = true;
        this.scrollUp.field_146125_m = true;
        if (this.scrollAmmount + 4 >= entries) {
            this.scrollAmmount = Math.max(0, entries - 4);
            this.scrollDown.field_146125_m = false;
        }
        if (this.scrollAmmount == 0) {
            this.scrollUp.field_146125_m = false;
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        int width = (this.field_146294_l - this.field_146999_f) / 2;
        int height = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(BDHelper.guiButtonsTexture);
        int x = 10 + width;
        int y = 10 + height + 50;
        this.func_73729_b(width, height, 64, 128, 64, 80);
        this.drawIcon(36, x, y);
        this.drawIcon(86, x + 32, y - 42);
        this.drawIcon(87 + this.type, x + 32, y - 20);
        super.func_146976_a(par1, par2, par3);
        int enchX = x + 50;
        int enchY = y - 50;
        GuiHumanBase.drawEntity((EntityLivingBase)this.inventory.npc, enchX - 40, enchY + 40);
    }

    @Override
    public int getPlayerInventoryOffset() {
        return 104;
    }

    public void func_146281_b() {
        PacketUpdateConversation packet = new PacketUpdateConversation(1, (EntityHumanBase)this.inventory.npc);
        ChocolateQuest.channel.sendPaquetToServer(packet);
        super.func_146281_b();
    }
}

