/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.block.BlockMobSpawnerTileEntity;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.EntitySchematicBuilder;
import com.chocolate.chocolateQuest.entity.ai.EnumAiState;
import com.chocolate.chocolateQuest.entity.mob.registry.DungeonMonstersBase;
import com.chocolate.chocolateQuest.entity.mob.registry.RegisterDungeonMobs;
import com.chocolate.chocolateQuest.items.mobControl.ItemMobToSpawner;
import com.chocolate.chocolateQuest.misc.EquipementHelper;
import java.util.Properties;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BuilderStronghold
extends BuilderBase {
    String folder;
    String folderEntance;
    String folderEntanceStairs;
    String folderStairs;
    String folderBossRoom;
    int rooms = 3;
    int floors = 3;
    int mobs = 3;
    boolean replaceBanners = true;

    @Override
    public BuilderBase load(Properties prop) {
        this.folder = prop.getProperty("folder");
        if (this.folder == null) {
            this.folder = "unspecified";
        }
        this.folderEntance = prop.getProperty("folder_entrance");
        if (this.folderEntance == null) {
            this.folderEntance = "unspecified";
        }
        this.folderStairs = prop.getProperty("folder_stairs");
        if (this.folderStairs == null) {
            this.folderStairs = "unspecified";
        }
        this.folderEntanceStairs = prop.getProperty("folder_entrance_stairs");
        if (this.folderEntanceStairs == null) {
            this.folderEntanceStairs = "unspecified";
        }
        this.folderBossRoom = prop.getProperty("folder_boss");
        if (this.folderBossRoom == null) {
            this.folderBossRoom = "unspecified";
        }
        this.rooms = Math.max(3, HelperReadConfig.getIntegerProperty(prop, "rooms", this.rooms));
        this.floors = Math.max(1, HelperReadConfig.getIntegerProperty(prop, "floors", this.floors));
        this.mobs = HelperReadConfig.getIntegerProperty(prop, "mobs", this.mobs);
        this.replaceBanners = HelperReadConfig.getBooleanProperty(prop, "replaceBanners", this.replaceBanners);
        return super.load(prop);
    }

    @Override
    public String getName() {
        return "stronghold";
    }

    @Override
    public void generate(Random random, World world, int x, int z, int mob) {
        int maxX = 15;
        int maxY = 15;
        boolean cont = false;
        int cant = 0;
        int media = 0;
        for (int i = 0; i < maxX; ++i) {
            for (int j = 0; j < maxY; ++j) {
                int h = world.func_72825_h(i + x, j + z);
                media += h;
                ++cant;
            }
        }
        int height = media / cant;
        this.generate(random, world, x, height, z, mob);
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int mob) {
        int z;
        int x;
        int center = this.rooms / 2;
        int height = 10;
        int roomSize = 15;
        j = Math.max(2, j - (this.floors + 1) * height);
        EntitySchematicBuilder builder = new EntitySchematicBuilder(world);
        builder.setMobID(mob, this.replaceBanners);
        builder.func_70107_b(i -= center * roomSize, j, k -= center * roomSize);
        builder.addBuildingPlans(BuilderHelper.getRandomNBTMap(this.folderEntance, random, this.getDungeonName()), center * roomSize + i, (this.floors + 1) * height + j, center * roomSize + k);
        int mobLevel = (int)Math.sqrt((world.func_72861_E().field_71574_a - i) * (world.func_72861_E().field_71574_a - i) + (world.func_72861_E().field_71573_c - j) * (world.func_72861_E().field_71573_c - j)) / 1000 - 1;
        int stairsX = random.nextInt(this.rooms);
        int stairsZ = random.nextInt(this.rooms);
        int prevStairsX = center;
        int prevStairsZ = center;
        for (int y = this.floors - 1; y >= 0; --y) {
            while (stairsX == prevStairsX && stairsZ == prevStairsZ) {
                stairsX = random.nextInt(this.rooms);
                stairsZ = random.nextInt(this.rooms);
            }
            for (x = 0; x < this.rooms; ++x) {
                for (z = 0; z < this.rooms; ++z) {
                    Schematic schematic = null;
                    if (x == stairsX && z == stairsZ) {
                        if (y == 0) {
                            schematic = BuilderHelper.getRandomNBTMap(this.folderBossRoom, random, this.getDungeonName());
                        }
                    } else if (x == prevStairsX && z == prevStairsZ) {
                        if (y != this.floors - 1) {
                            schematic = BuilderHelper.getRandomNBTMap(this.folderStairs, random, this.getDungeonName());
                        }
                    } else {
                        schematic = BuilderHelper.getRandomNBTMap(this.folder, random, this.getDungeonName());
                    }
                    if (schematic == null) continue;
                    int posX = x * roomSize + i;
                    int posY = y * height + j;
                    int posZ = z * roomSize + k;
                    for (int index = 0; index < this.mobs; ++index) {
                        this.addMobsToSchematic(world, posX, posY, posZ, schematic, random, mob, mobLevel);
                    }
                    builder.addBuildingPlans(schematic, posX, posY, posZ);
                }
            }
            prevStairsX = stairsX;
            prevStairsZ = stairsZ;
        }
        Schematic s = new Schematic(this.rooms * roomSize, this.floors * height, this.rooms * roomSize, ChocolateQuest.emptyBlock);
        for (x = 0; x < s.width; ++x) {
            for (int y = 0; y < s.height; ++y) {
                s.setBlock(x, y, 0, Blocks.field_150417_aV);
                s.setBlock(0, y, x, Blocks.field_150417_aV);
                s.setBlock(x, y, s.width - 1, Blocks.field_150417_aV);
                s.setBlock(s.width - 1, y, x, Blocks.field_150417_aV);
            }
            for (z = 0; z < s.width; ++z) {
                s.setBlock(x, 0, z, Blocks.field_150417_aV);
                s.setBlock(x, s.height - 1, z, Blocks.field_150417_aV);
            }
        }
        s.setPosition(i - center * roomSize, j, k - center * roomSize);
        builder.addBuildingPlans(s, i, j, k);
        s = BuilderHelper.getRandomNBTMap(this.folderEntanceStairs, random, this.getDungeonName());
        builder.addBuildingPlans(s, center * roomSize + i, (this.floors - 1) * height + j, center * roomSize + k);
        world.func_72838_d((Entity)builder);
    }

    public void addMobsToSchematic(World world, int i, int j, int k, Schematic schematic, Random random, int mobType, int mobLevel) {
        int x = random.nextInt(schematic.width);
        int z = random.nextInt(schematic.length);
        int y = -1;
        for (int index = 0; index < schematic.height - 1; ++index) {
            if (schematic.getBlock(x, index, z) != Blocks.field_150350_a || schematic.getBlock(x, index + 1, z) != Blocks.field_150350_a) continue;
            y = index;
            break;
        }
        if (y > -1) {
            NBTTagCompound tag;
            DungeonMonstersBase mob = RegisterDungeonMobs.mobList.get(mobType);
            EntityHumanBase human = (EntityHumanBase)mob.getEntity(world, i, j, k);
            EquipementHelper.equipHumanRandomly(human, mobLevel, EquipementHelper.getRandomType(human, mobLevel > 6 ? 1 : 5));
            human.partyPositionPersistance = false;
            human.AIMode = EnumAiState.WANDER.ordinal();
            schematic.setBlock(x, y, z, ChocolateQuest.spawner);
            BlockMobSpawnerTileEntity te = new BlockMobSpawnerTileEntity();
            te.mobNBT = tag = ItemMobToSpawner.getHumanSaveTagAndKillIt(i, j, k, human);
            te.mob = -1;
            te.field_145851_c = x;
            te.field_145848_d = y;
            te.field_145849_e = z;
            schematic.addTileEntity(te);
        }
    }
}

