/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.BuilderBlockData;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.Perlin3D;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.entity.EntitySchematicBuilder;
import java.util.Properties;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class BuilderNether
extends BuilderBase {
    String folder = "pigcity";
    int rows = 4;
    int posY = 31;
    BuilderBlockData floorBlock;
    BuilderBlockData lavaBlock = new BuilderBlockData(Blocks.field_150353_l);
    boolean replaceBanners = true;

    @Override
    public BuilderBase load(Properties prop) {
        this.rows = HelperReadConfig.getIntegerProperty(prop, "rows", 4);
        if (this.rows < 1) {
            this.rows = 1;
        }
        if (this.rows > 20) {
            this.rows = 20;
        }
        this.posY = HelperReadConfig.getIntegerProperty(prop, "posY", 31);
        this.floorBlock = HelperReadConfig.getBlock(prop, "floorBlock", new BuilderBlockData(Blocks.field_150385_bj));
        this.lavaBlock = HelperReadConfig.getBlock(prop, "lavaBlock", this.lavaBlock);
        this.folder = prop.getProperty("folder");
        if (this.folder == null) {
            this.folder = "pigcity";
        }
        this.replaceBanners = HelperReadConfig.getBooleanProperty(prop, "replaceBanners", this.replaceBanners);
        return super.load(prop);
    }

    @Override
    public String getName() {
        return "lavaCity";
    }

    @Override
    public void generate(Random random, World world, int x, int z, int mob) {
        this.generate(random, world, x, this.posY, z, mob);
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int mob) {
        int x;
        Perlin3D p = new Perlin3D(world.func_72905_C(), 8, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        int rowSize = 21;
        int size = this.rows * rowSize;
        int height = 32;
        int wallSize = 4;
        for (int x2 = 0; x2 < size; ++x2) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < size; ++z) {
                    float noiseVar = Math.max(0.0f, 2.0f - (float)(height - y) / 4.0f);
                    noiseVar += Math.max(0.0f, (float)wallSize - (float)x2 / 2.0f);
                    noiseVar += Math.max(0.0f, (float)wallSize - (float)(size - x2) / 2.0f);
                    noiseVar += Math.max(0.0f, (float)wallSize - (float)z / 2.0f);
                    noiseVar += Math.max(0.0f, (float)wallSize - (float)(size - z) / 2.0f);
                    if (!(p.getNoiseAt(x2 + i, y + j, z + k) * p2.getNoiseAt(x2 + i, y + j, z + k) * (double)noiseVar < 0.5)) continue;
                    world.func_147468_f(i + x2, j + y, k + z);
                }
            }
        }
        BuilderHelper b = BuilderHelper.builderHelper;
        Schematic s = new Schematic(size, 1, size);
        for (x = 0; x < s.width; ++x) {
            for (int z = 0; z < s.length; ++z) {
                if (!(x % 21 > 2 && x % 21 < 18 && z % 21 > 2 && z % 21 < 18 || x % 21 > 8 && x % 21 < 12 || z % 21 > 8 && z % 21 < 12)) {
                    this.lavaBlock.placeBlock(s, x, 0, z, random);
                    continue;
                }
                this.floorBlock.placeBlock(s, x, 0, z, random);
            }
        }
        if (ChocolateQuest.config.useInstantDungeonBuilder) {
            b.putSchematicInWorld(random, world, s, i, j, k, mob, this.replaceBanners);
            for (x = 0; x < s.width; x += 21) {
                for (int z = 0; z < s.length; z += 21) {
                    b.putSchematicInWorld(random, world, BuilderHelper.getRandomNBTMap(this.folder, random, this.getDungeonName()), x + 3 + i, j + 1, z + 3 + k, mob, this.replaceBanners);
                }
            }
        } else {
            EntitySchematicBuilder builder = new EntitySchematicBuilder(world);
            builder.setMobID(mob, this.replaceBanners);
            builder.func_70107_b(i, j, k);
            builder.addBuildingPlans(s, i, j, k);
            for (int x3 = 0; x3 < s.width; x3 += 21) {
                for (int z = 0; z < s.length; z += 21) {
                    builder.addBuildingPlans(BuilderHelper.getRandomNBTMap(this.folder, random, this.getDungeonName()), x3 + 3 + i, j + 1, z + 3 + k);
                }
            }
            world.func_72838_d((Entity)builder);
        }
    }
}

