/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLRockMountains
extends TerrainBase {
    private float width;
    private float strength;
    private float terrainHeight;
    private int wavelength = 39;
    private SimplexOctave.Disk jitter = new SimplexOctave.Disk();
    private double amplitude = 12.0;

    public TerrainHLRockMountains(float mountainWidth, float mountainStrength, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.terrainHeight = height;
        this.terrainHeight = 30.0f;
        this.width = 120.0f;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        simplex.riverJitter().evaluateNoise((float)x / (float)this.wavelength, (float)y / (float)this.wavelength, this.jitter);
        float pX = (float)((double)x + this.jitter.deltax() * this.amplitude);
        float pY = (float)((double)y + this.jitter.deltay() * this.amplitude);
        float h = simplex.noise2(pX / 19.0f, pY / 19.0f);
        h = h * h * 2.0f;
        float h2 = simplex.noise2(pX / 13.0f, pY / 13.0f);
        h2 = h2 * h2 * 1.3f;
        h = Math.max(h, h2);
        h += h2;
        float h3 = simplex.noise2(pX / 53.0f, pY / 53.0f);
        h3 = h3 * h3 * 5.0f;
        float m = TerrainHLRockMountains.unsignedPower(simplex.noise2(pX / this.width, pY / this.width), 1.4f) * this.strength * river;
        float m2 = TerrainHLRockMountains.unsignedPower(simplex.noise2(pY / (this.width * 1.5f), pX / (this.width * 1.5f)), 1.4f) * this.strength * river;
        m = Math.max(m, m2);
        h = m > 10.0f ? h * m / 10.0f : (h += h3);
        m = TerrainHLRockMountains.above(m, -50.0f);
        return this.terrainHeight + h + m;
    }
}

