/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLFlyingMountains
extends TerrainBase {
    private float width;
    private float strength;
    private float terrainHeight;
    private float cragWidth;
    private int wavelength = 20;
    private SimplexOctave.Disk jitter = new SimplexOctave.Disk();
    private double amplitude = 5.0;

    public TerrainHLFlyingMountains(float mountainWidth, float mountainStrength, float height, float cragWidth) {
        super(height);
        this.width = mountainWidth;
        this.strength = mountainStrength * 1.3f;
        this.terrainHeight = height;
        this.cragWidth = cragWidth;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        simplex.riverJitter().evaluateNoise((float)x / (float)this.wavelength, (float)y / (float)this.wavelength, this.jitter);
        int pX = (int)Math.round((double)x + this.jitter.deltax() * this.amplitude);
        int pY = (int)Math.round((double)y + this.jitter.deltay() * this.amplitude);
        x = pX;
        y = pY;
        float firstJump = 0.3f;
        float secondJump = 0.5f;
        float firstScatter = 0.3f;
        float secondScatter = 0.45f;
        float adjust = 0.0f;
        float firstLevel = simplex.noise2((float)x / this.width, (float)y / this.width) * 5.0f + 10.0f + simplex.noise2((float)x / 20.0f, (float)y / 20.0f);
        float secondAdded = simplex.octave(1).noise2((float)x / this.width, (float)y / this.width) * 10.0f + 40.0f + simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        float secondLevel = (firstLevel *= river) + TerrainHLFlyingMountains.borderAdjusted(secondAdded, border, 0.8f, 0.7f);
        float thirdAdded = simplex.octave(2).noise2((float)x / this.width, (float)y / this.width) * 15.0f + 30.0f + simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        float thirdLevel = secondLevel + TerrainHLFlyingMountains.borderAdjusted(thirdAdded, border, 0.95f, 0.88f);
        float scatter = Math.abs((float)simplex.octave(1).noise((float)x / this.cragWidth, (float)y / this.cragWidth, 1.0));
        if (river < firstJump || scatter < firstScatter) {
            adjust = firstLevel;
        } else if (river < secondJump || scatter < secondScatter) {
            if ((double)scatter > (double)firstScatter + 0.1) {
                adjust = secondLevel;
            } else {
                float lift = (scatter - firstScatter) * 10.0f;
                lift = (0.5f - lift) * 2.0f;
                lift = TerrainHLFlyingMountains.unsignedPower(lift, 0.5f);
                lift = -lift / 2.0f + 0.5f;
                adjust = secondLevel * lift + firstLevel * (1.0f - lift);
            }
        } else if (scatter > secondScatter + 0.1f) {
            adjust = thirdLevel;
        } else {
            float lift = (scatter - secondScatter) * 10.0f;
            lift *= lift;
            adjust = thirdLevel * lift + secondLevel * (1.0f - lift);
        }
        return this.terrainHeight + adjust;
    }
}

