/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoBaseBiomeDecorations;
import rtg.world.biome.deco.DecoBoulder;
import rtg.world.biome.deco.DecoCobwebs;
import rtg.world.biome.deco.DecoDeadBush;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoMushrooms;
import rtg.world.biome.deco.DecoShrub;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.deco.helper.DecoHelperThisOrThat;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.tree.rtg.TreeRTGCeibaPentandra;
import rtg.world.gen.feature.tree.rtg.TreeRTGCeibaRosea;
import rtg.world.gen.feature.tree.rtg.TreeRTGRhizophoraMucronata;
import rtg.world.gen.surface.vanilla.SurfaceVanillaRoofedForest;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaRoofedForest;

public class RealisticBiomeVanillaRoofedForest
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_150585_R.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_150585_R.field_76753_B;

    public RealisticBiomeVanillaRoofedForest(BiomeConfig config) {
        super(config, BiomeGenBase.field_150585_R, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainVanillaRoofedForest(), new SurfaceVanillaRoofedForest(config, (Block)Blocks.field_150349_c, Blocks.field_150346_d, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150346_d, 2, 0.08f));
        this.waterSurfaceLakeChance = 3;
        DecoMushrooms decoMushrooms = new DecoMushrooms();
        decoMushrooms.chance = 4;
        decoMushrooms.maxY = 90;
        decoMushrooms.randomType = DecoMushrooms.RandomType.ALWAYS_GENERATE;
        this.addDeco(decoMushrooms);
        TreeRTGRhizophoraMucronata mucronataTree = new TreeRTGRhizophoraMucronata(3, 4, 13.0f, 0.32f, 0.1f);
        mucronataTree.logBlock = Blocks.field_150363_s;
        mucronataTree.logMeta = 1;
        mucronataTree.leavesBlock = Blocks.field_150361_u;
        mucronataTree.leavesMeta = 1;
        mucronataTree.minTrunkSize = 2;
        mucronataTree.maxTrunkSize = 3;
        mucronataTree.minCrownSize = 10;
        mucronataTree.maxCrownSize = 18;
        mucronataTree.noLeaves = false;
        this.addTree(mucronataTree);
        DecoTree mangroveTree = new DecoTree(mucronataTree);
        mangroveTree.treeType = DecoTree.TreeType.RTG_TREE;
        mangroveTree.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        mangroveTree.treeConditionChance = 1;
        mangroveTree.strengthFactorForLoops = 8.0f;
        mangroveTree.maxY = 110;
        this.addDeco(mangroveTree);
        TreeRTGCeibaPentandra pentandraTree = new TreeRTGCeibaPentandra(13.0f, 3, 0.32f, 0.1f);
        pentandraTree.logBlock = Blocks.field_150363_s;
        pentandraTree.logMeta = 1;
        pentandraTree.leavesBlock = Blocks.field_150361_u;
        pentandraTree.leavesMeta = 1;
        pentandraTree.minTrunkSize = 2;
        pentandraTree.maxTrunkSize = 3;
        pentandraTree.minCrownSize = 10;
        pentandraTree.maxCrownSize = 18;
        pentandraTree.noLeaves = false;
        this.addTree(pentandraTree);
        DecoTree ceibaPentandraTree = new DecoTree(pentandraTree);
        ceibaPentandraTree.treeType = DecoTree.TreeType.RTG_TREE;
        ceibaPentandraTree.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        ceibaPentandraTree.treeConditionChance = 1;
        ceibaPentandraTree.strengthFactorForLoops = 8.0f;
        ceibaPentandraTree.maxY = 110;
        this.addDeco(ceibaPentandraTree);
        TreeRTGCeibaRosea roseaTree = new TreeRTGCeibaRosea(16.0f, 5, 0.32f, 0.1f);
        roseaTree.logBlock = Blocks.field_150363_s;
        roseaTree.logMeta = 1;
        roseaTree.leavesBlock = Blocks.field_150361_u;
        roseaTree.leavesMeta = 1;
        roseaTree.minTrunkSize = 2;
        roseaTree.maxTrunkSize = 3;
        roseaTree.minCrownSize = 10;
        roseaTree.maxCrownSize = 18;
        roseaTree.noLeaves = false;
        this.addTree(roseaTree);
        DecoTree ceibaRoseaTree = new DecoTree(roseaTree);
        ceibaRoseaTree.treeType = DecoTree.TreeType.RTG_TREE;
        ceibaRoseaTree.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        ceibaRoseaTree.treeConditionChance = 1;
        ceibaRoseaTree.strengthFactorForLoops = 8.0f;
        ceibaRoseaTree.maxY = 110;
        this.addDeco(ceibaRoseaTree);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.distribution.noiseDivisor = 80.0f;
        decoFallenTree.distribution.noiseFactor = 60.0f;
        decoFallenTree.distribution.noiseAddend = -15.0f;
        decoFallenTree.logCondition = DecoFallenTree.LogCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        decoFallenTree.logConditionChance = 16;
        decoFallenTree.logConditionNoise = 0.0f;
        decoFallenTree.logBlock = Blocks.field_150363_s;
        decoFallenTree.logMeta = 1;
        decoFallenTree.leavesBlock = Blocks.field_150361_u;
        decoFallenTree.leavesMeta = (byte)-1;
        decoFallenTree.minSize = 4;
        decoFallenTree.maxSize = 9;
        this.addDeco(decoFallenTree, this.config._boolean("decorationLogs"));
        DecoShrub darkOakShrub = new DecoShrub();
        darkOakShrub.logBlock = Blocks.field_150363_s;
        darkOakShrub.logMeta = 1;
        darkOakShrub.leavesBlock = Blocks.field_150361_u;
        darkOakShrub.leavesMeta = 1;
        darkOakShrub.maxY = 100;
        darkOakShrub.strengthFactor = 10.0f;
        DecoShrub oakShrub = new DecoShrub();
        oakShrub.logBlock = Blocks.field_150364_r;
        oakShrub.logMeta = 0;
        oakShrub.leavesBlock = Blocks.field_150362_t;
        oakShrub.leavesMeta = 0;
        oakShrub.maxY = 100;
        oakShrub.strengthFactor = 10.0f;
        this.addDeco(new DecoHelperThisOrThat(4, DecoHelperThisOrThat.ChanceType.NOT_EQUALS_ZERO, darkOakShrub, oakShrub));
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.boulderBlock = Blocks.field_150341_Y;
        decoBoulder.chance = 16;
        decoBoulder.maxY = 80;
        decoBoulder.strengthFactor = 2.0f;
        this.addDeco(decoBoulder);
        DecoCobwebs decoCobwebs = new DecoCobwebs();
        decoCobwebs.chance = 1;
        decoCobwebs.minY = 63;
        decoCobwebs.maxY = 76;
        decoCobwebs.strengthFactor = 30.0f;
        decoCobwebs.adjacentBlock = Blocks.field_150363_s;
        decoCobwebs.adjacentBlockMeta = 1;
        decoCobwebs.minAdjacents = 2;
        this.addDeco(decoCobwebs, this.config._boolean("decorationCobwebs"));
        DecoBaseBiomeDecorations decoBaseBiomeDecorations = new DecoBaseBiomeDecorations();
        decoBaseBiomeDecorations.notEqualsZeroChance = 2;
        decoBaseBiomeDecorations.maxY = 100;
        this.addDeco(decoBaseBiomeDecorations);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.maxY = 100;
        decoGrass.strengthFactor = 20.0f;
        this.addDeco(decoGrass);
        DecoDeadBush decoDeadBush = new DecoDeadBush();
        decoDeadBush.maxY = 100;
        decoDeadBush.chance = 2;
        decoDeadBush.strengthFactor = 2.0f;
        this.addDeco(decoDeadBush);
    }
}

