/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.ridiculousworld;

import cpw.mods.fml.common.Loader;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.api.biome.ridiculousworld.config.BiomeConfigRW;
import rtg.util.Logger;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.ridiculousworld.RealisticBiomeRWBotanicalGarden;
import rtg.world.biome.realistic.ridiculousworld.RealisticBiomeRWMountainOfMadness;
import rtg.world.biome.realistic.ridiculousworld.RealisticBiomeRWMurica;
import rtg.world.biome.realistic.ridiculousworld.RealisticBiomeRWOssuary;
import rtg.world.biome.realistic.ridiculousworld.RealisticBiomeRWRockCandyMountain;
import rtg.world.biome.realistic.ridiculousworld.RealisticBiomeRWShadowFen;
import rtg.world.biome.realistic.ridiculousworld.RealisticBiomeRWSpookyForest;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.terrain.TerrainBase;

public class RealisticBiomeRWBase
extends RealisticBiomeBase {
    public static RealisticBiomeBase rwBotanicalGarden;
    public static RealisticBiomeBase rwMountainOfMadness;
    public static RealisticBiomeBase rwMurica;
    public static RealisticBiomeBase rwOssuary;
    public static RealisticBiomeBase rwRockCandyMountain;
    public static RealisticBiomeBase rwShadowFen;
    public static RealisticBiomeBase rwSpookyForest;

    public RealisticBiomeRWBase(BiomeConfig config, BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        super(config, b, riverbiome, t, s);
        this.waterSurfaceLakeChance = 0;
        this.lavaSurfaceLakeChance = 0;
    }

    public static void addBiomes() {
        if (Loader.isModLoaded((String)"RidiculousWorld")) {
            BiomeGenBase[] b = BiomeGenBase.func_150565_n();
            for (int i = 0; i < 256; ++i) {
                if (b[i] == null) continue;
                if (b[i].field_76791_y == null) {
                    Logger.warn("Biome ID %d has no name.", b[i].field_76756_M);
                    continue;
                }
                BiomeGenBase rwBiome = b[i];
                String biomeName = b[i].field_76791_y;
                String biomeClass = b[i].func_150562_l().getName();
                if (biomeName == "Botanical Garden" && biomeClass == "fox.spiteful.ridiculous.biomes.BiomeGenBotania") {
                    rwBotanicalGarden = new RealisticBiomeRWBotanicalGarden(rwBiome, BiomeConfigRW.biomeConfigRWBotanicalGarden);
                    continue;
                }
                if (biomeName == "Murica" && biomeClass == "fox.spiteful.ridiculous.biomes.BiomeGenMurica") {
                    rwMurica = new RealisticBiomeRWMurica(rwBiome, BiomeConfigRW.biomeConfigRWMurica);
                    continue;
                }
                if (biomeName == "Mountain of Madness" && biomeClass == "fox.spiteful.ridiculous.biomes.BiomeGenMadness") {
                    rwMountainOfMadness = new RealisticBiomeRWMountainOfMadness(rwBiome, BiomeConfigRW.biomeConfigRWMountainOfMadness);
                    continue;
                }
                if (biomeName == "Ossuary" && biomeClass == "fox.spiteful.ridiculous.biomes.BiomeGenOssuary") {
                    rwOssuary = new RealisticBiomeRWOssuary(rwBiome, BiomeConfigRW.biomeConfigRWOssuary);
                    continue;
                }
                if (biomeName == "Rock Candy Mountain" && biomeClass == "fox.spiteful.ridiculous.biomes.BiomeGenCandy") {
                    rwRockCandyMountain = new RealisticBiomeRWRockCandyMountain(rwBiome, BiomeConfigRW.biomeConfigRWRockCandyMountain);
                    continue;
                }
                if (biomeName == "Shadow Fen" && biomeClass == "fox.spiteful.ridiculous.biomes.BiomeGenShadow") {
                    rwShadowFen = new RealisticBiomeRWShadowFen(rwBiome, BiomeConfigRW.biomeConfigRWShadowFen);
                    continue;
                }
                if (biomeName != "Spooky Forest" || biomeClass != "fox.spiteful.ridiculous.biomes.BiomeGenSpooky") continue;
                rwSpookyForest = new RealisticBiomeRWSpookyForest(rwBiome, BiomeConfigRW.biomeConfigRWSpookyForest);
            }
        }
    }
}

