/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TimedHashSet<Type>
implements Set<Type> {
    private final int holdMillis;
    private Set<Type> map = new HashSet<Type>();
    private LinkTail link = new LinkTail();

    public TimedHashSet(int holdTicks) {
        this.holdMillis = holdTicks;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        this.clearEntries();
        return this.map.contains(arg0);
    }

    @Override
    public Iterator<Type> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[] toArray() {
        return this.map.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.map.toArray(arg0);
    }

    @Override
    public boolean add(Type arg0) {
        this.clearEntries();
        return this.map.add(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends Type> arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private synchronized void clearEntries() {
        this.link.clear();
    }

    private class Timed<Key>
    extends LinkEntry {
        final long time;
        final Key timed;

        Timed(Key timed) {
            this.timed = timed;
            this.time = System.currentTimeMillis();
        }

        @Override
        void remove() {
            TimedHashSet.this.map.remove(this.timed);
        }

        @Override
        boolean old() {
            return this.time + (long)TimedHashSet.this.holdMillis < System.currentTimeMillis();
        }
    }

    private class LinkTail
    extends LinkEntry {
        LinkEntry latest;

        LinkTail() {
            this.latest = this;
            this.next = this;
        }

        @Override
        boolean old() {
            return false;
        }

        @Override
        void remove() {
            throw new RuntimeException();
        }

        void clear() {
            while (this.next.old()) {
                this.next.remove();
                this.next = this.next.next;
            }
        }

        void add(Type added) {
            Timed toAdd = new Timed(added);
            toAdd.next = this;
            this.latest.next = toAdd;
            this.latest = toAdd;
        }
    }

    private abstract class LinkEntry {
        LinkEntry next;

        private LinkEntry() {
        }

        abstract boolean old();

        abstract void remove();
    }
}

