/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LimitedSet<Type>
implements Set<Type>,
Iterable<Type> {
    private HashSet<Type> members = new HashSet();
    private ArrayList<Type> limiting;
    private int nextIndex;
    private int maxSize;
    private boolean full = false;

    public LimitedSet(int maxSize) {
        this.limiting = new ArrayList(maxSize);
        this.maxSize = maxSize;
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.members.contains(arg0);
    }

    @Override
    public Iterator<Type> iterator() {
        return this.members.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.members.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.members.toArray(arg0);
    }

    @Override
    public boolean add(Type arg0) {
        if (this.full) {
            this.members.remove(this.limiting.get(this.nextIndex));
            this.limiting.set(this.nextIndex, arg0);
        } else {
            this.limiting.add(arg0);
        }
        ++this.nextIndex;
        if (this.nextIndex >= this.maxSize) {
            this.nextIndex = 0;
            this.full = true;
        }
        return this.members.add(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.members.remove(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.members.containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends Type> arg0) {
        for (Type added : arg0) {
            this.add(added);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.members.retainAll(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.members.removeAll(arg0);
    }

    @Override
    public void clear() {
        this.members.clear();
    }
}

