/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.NbtBlockType;
import bq_standard.client.gui.tasks.PanelTaskBlockBreak;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskBlockBreak;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class TaskBlockBreak
implements ITask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private final TreeMap<UUID, int[]> userProgress = new TreeMap();
    public final List<NbtBlockType> blockTypes = new ArrayList<NbtBlockType>();

    public TaskBlockBreak() {
        this.blockTypes.add(new NbtBlockType());
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskBlockBreak.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.block_break";
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        pInfo.ALL_UUIDS.forEach(uuid -> {
            if (this.isComplete((UUID)uuid)) {
                return;
            }
            int[] tmp = this.getUsersProgress((UUID)uuid);
            for (int i = 0; i < this.blockTypes.size(); ++i) {
                NbtBlockType block = this.blockTypes.get(i);
                if (block == null || tmp[i] >= block.n) continue;
                return;
            }
            this.setComplete((UUID)uuid);
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    public void onBlockBreak(ParticipantInfo pInfo, DBEntry<IQuest> quest, Block block, int meta, int x, int y, int z) {
        TileEntity tile = block.hasTileEntity(meta) ? pInfo.PLAYER.field_70170_p.func_147438_o(x, y, z) : null;
        NBTTagCompound tags = null;
        if (tile != null) {
            tags = new NBTTagCompound();
            tile.func_145841_b(tags);
        }
        List<Tuple2<UUID, int[]>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        boolean changed = false;
        for (int i = 0; i < this.blockTypes.size(); ++i) {
            NbtBlockType targetBlock = this.blockTypes.get(i);
            int tmpMeta = targetBlock.m < 0 || targetBlock.m == Short.MAX_VALUE ? Short.MAX_VALUE : meta;
            boolean oreMatch = targetBlock.oreDict.length() > 0 && OreDictionary.getOres((String)targetBlock.oreDict).contains(new ItemStack(block, 1, tmpMeta));
            int index = i;
            if (!oreMatch && (block != targetBlock.b || targetBlock.m >= 0 && meta != targetBlock.m) || !ItemComparison.CompareNBTTag((NBTBase)targetBlock.tags, (NBTBase)tags, (boolean)true)) continue;
            progress.forEach(entry -> {
                if (((int[])entry.func_76340_b())[index] >= targetBlock.n) {
                    return;
                }
                int[] nArray = (int[])entry.func_76340_b();
                int n = index;
                nArray[n] = nArray[n] + 1;
            });
            changed = true;
            break;
        }
        if (changed) {
            this.setBulkProgress(progress);
            this.detect(pInfo, quest);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList bAry = new NBTTagList();
        for (NbtBlockType block : this.blockTypes) {
            bAry.func_74742_a((NBTBase)block.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("blocks", (NBTBase)bAry);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.blockTypes.clear();
        NBTTagList bList = nbt.func_150295_c("blocks", 10);
        for (int i = 0; i < bList.func_74745_c(); ++i) {
            NbtBlockType block = new NbtBlockType();
            block.readFromNBT(bList.func_150305_b(i));
            this.blockTypes.add(block);
        }
        if (nbt.func_150297_b("blockID", 8)) {
            Block targetBlock = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("blockID"));
            targetBlock = targetBlock != Blocks.field_150350_a ? targetBlock : Blocks.field_150364_r;
            int targetMeta = nbt.func_74762_e("blockMeta");
            NBTTagCompound targetNbt = nbt.func_74775_l("blockNBT");
            int targetNum = nbt.func_74762_e("amount");
            NbtBlockType leg = new NbtBlockType();
            leg.b = targetBlock;
            leg.m = targetMeta;
            leg.tags = targetNbt;
            leg.n = targetNum;
            this.blockTypes.add(leg);
        }
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                int[] data = new int[this.blockTypes.size()];
                List dNbt = NBTConverter.getTagList((NBTTagList)pTag.func_150295_c("data", 3));
                for (int i = 0; i < data.length && i < dNbt.size(); ++i) {
                    data[i] = ((NBTBase.NBTPrimitive)dNbt.get(i)).func_150287_d();
                }
                this.userProgress.put(uuid, data);
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                int[] data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    NBTTagList pArray = new NBTTagList();
                    for (int i : data) {
                        pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                    }
                    pJson.func_74782_a("data", (NBTBase)pArray);
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                NBTTagList pArray = new NBTTagList();
                for (int i : data) {
                    pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                }
                pJson.func_74782_a("data", (NBTBase)pArray);
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskBlockBreak(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }

    private void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID uuid) {
        int[] progress = this.userProgress.get(uuid);
        return progress == null || progress.length != this.blockTypes.size() ? new int[this.blockTypes.size()] : progress;
    }

    private List<Tuple2<UUID, int[]>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple2<UUID, int[]>> list = new ArrayList<Tuple2<UUID, int[]>>();
        uuids.forEach(key -> list.add(new Tuple2(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }

    private void setBulkProgress(@Nonnull List<Tuple2<UUID, int[]>> list) {
        list.forEach(entry -> this.setUserProgress((UUID)entry.func_76341_a(), (int[])entry.func_76340_b()));
    }
}

