/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util.xml;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import net.slimevoid.library.core.SlimevoidCore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLLoader {
    protected static Map<String, Integer> xmlVariables = new HashMap<String, Integer>();
    protected static FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.substring(name.length() - 4, name.length()).equals(".xml");
        }
    };

    private static int getInteger(String value) {
        int returns;
        try {
            returns = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return returns;
    }

    public static void addXmlVariable(String var, int val) {
        Integer flag;
        if (xmlVariables.containsKey(var)) {
            for (int i = 1; i < 4096; ++i) {
                String tempVar = var + i;
                if (xmlVariables.containsKey(tempVar)) continue;
                var = var + i;
                break;
            }
        }
        if ((flag = xmlVariables.put(var, val)) != null) {
            SlimevoidCore.console("SlimevoidLib", "XML Variable replaced ID [" + flag + "] with ID [" + val + "] and mapped to " + var);
        } else {
            SlimevoidCore.console("SlimevoidLib", "XML Variable loaded for [" + var + "] @ID [" + val + "]");
        }
    }

    protected static String getValue(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag).item(0).getChildNodes();
        Node node = nodes.item(0);
        return node.getNodeValue();
    }
}

