/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.library.ISlimevoidHelper;
import net.slimevoid.library.core.SlimevoidCore;

public class SlimevoidHelper {
    private static boolean initialized = false;
    private static List<ISlimevoidHelper> helperClasses;

    public static void init() {
        if (!initialized) {
            helperClasses = new ArrayList<ISlimevoidHelper>();
            initialized = true;
        }
    }

    public static void registerHelper(ISlimevoidHelper newHelper) {
        if (!helperClasses.contains(newHelper)) {
            helperClasses.add(newHelper);
        } else {
            SlimevoidCore.console("Slimevoid Lib", "Attempted to register helper Object " + newHelper.getHelperName() + " that was already registered.");
        }
    }

    public static Block getBlock(World world, int x, int y, int z) {
        for (ISlimevoidHelper helper : helperClasses) {
            Block id = helper.getBlock(world, x, y, z);
            if (id == null) continue;
            return id;
        }
        return world.func_147439_a(x, y, z);
    }

    public static TileEntity getBlockTileEntity(IBlockAccess world, int x, int y, int z) {
        for (ISlimevoidHelper helper : helperClasses) {
            TileEntity tileentity = helper.getBlockTileEntity(world, x, y, z);
            if (tileentity == null) continue;
            return tileentity;
        }
        return world.func_147438_o(x, y, z);
    }

    public static boolean targetExists(World world, int x, int y, int z) {
        for (ISlimevoidHelper helper : helperClasses) {
            boolean exists = helper.targetExists(world, x, y, z);
            if (!exists) continue;
            return true;
        }
        return world.func_72899_e(x, y, z);
    }

    public static boolean isUseableByPlayer(World world, EntityPlayer player, int xCoord, int yCoord, int zCoord, double xDiff, double yDiff, double zDiff, double distance) {
        for (ISlimevoidHelper helper : helperClasses) {
            boolean isUseable = helper.isUseableByPlayer(world, player, xCoord, yCoord, zCoord, xDiff, yDiff, zDiff, distance);
            if (!isUseable) continue;
            return true;
        }
        return player.func_70092_e((double)xCoord + xDiff, (double)yCoord + yDiff, (double)zCoord + zDiff) <= distance;
    }

    public static boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        for (ISlimevoidHelper helper : helperClasses) {
            boolean isLadder = helper.isLadder(world, x, y, z, entity);
            if (!isLadder) continue;
            return true;
        }
        return false;
    }

    public static boolean isReflectedClass(Class _class, int traceValue) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean flag = stackTraceElements[traceValue + 1].getClassName().equals(_class.getName());
        return flag;
    }

    public static boolean isReflectedMethod(String methodName, int traceValue) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean flag = stackTraceElements[traceValue + 1].getMethodName().equals(methodName);
        return flag;
    }
}

