/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.skin.cape.renderer.texture;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tlauncher.skin.cape.model.DynamicTexture;

public class FramedTexture {
    private static int frameIndex;
    private static final Logger LOGGER;
    private int currentFrameIndex;
    private long lastTimNano = System.nanoTime();
    private final long updatingTextureInNano;
    private boolean animated;
    private List<ResourceLocation> frames;

    public FramedTexture(long updatingTextureInNano, boolean animated) {
        this.updatingTextureInNano = updatingTextureInNano;
        this.frames = new ArrayList<ResourceLocation>();
        this.animated = animated;
    }

    public FramedTexture(int framesSize, long updatingTextureInNano, boolean animated) {
        this(updatingTextureInNano, animated);
        this.frames = new ArrayList<ResourceLocation>(framesSize);
    }

    public static FramedTexture createOneFramedTexture(int[] data, int width, int height) {
        FramedTexture texture = new FramedTexture(1L, false);
        ResourceLocation resourceLocation = new ResourceLocation(String.format("dynamic/framedTexture%s.png", FramedTexture.getNextFrameIndex()));
        DynamicTexture dynamicTexture = new DynamicTexture(width, height, data);
        Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, (ITextureObject)dynamicTexture);
        texture.frames.add(resourceLocation);
        return texture;
    }

    public void initByOneImage(int[] image, int width, int height) {
        ResourceLocation res = new ResourceLocation("dynamic/framedTexture" + FramedTexture.getNextFrameIndex() + ".png");
        Object object = Minecraft.func_71410_x().func_110434_K().func_110581_b(res);
        if (object == null) {
            object = new DynamicTexture(width, height, image);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(res, object);
        }
        this.frames.add(res);
    }

    private ResourceLocation getFrame(int index) {
        return this.frames.get(index);
    }

    private static int getNextFrameIndex() {
        return ++frameIndex;
    }

    public ResourceLocation getFrame() {
        if (!this.animated) {
            return this.getFrame(0);
        }
        if (System.nanoTime() - this.lastTimNano >= this.updatingTextureInNano) {
            this.lastTimNano = System.nanoTime();
            this.currentFrameIndex = this.currentFrameIndex + 1 < this.frames.size() ? ++this.currentFrameIndex : 0;
        }
        return this.frames.get(this.currentFrameIndex);
    }

    public List<ResourceLocation> getFrames() {
        return this.frames;
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

