/*
 * Decompiled with CFR 0.152.
 */
package bq_npc_integration.network;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketRegistry;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import bq_npc_integration.core.BQ_NPCs;
import bq_npc_integration.storage.NpcDialogDB;
import bq_npc_integration.storage.NpcFactionDB;
import bq_npc_integration.storage.NpcQuestDB;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class NetNpcSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_npc_integration:sync_npc_data");

    public static void registerHandler() {
        if (BQ_NPCs.proxy.isClient()) {
            ((IPacketRegistry)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_REG)).registerClientHandler(ID_NAME, NetNpcSync::onClient);
        }
    }

    public static void sendSync(@Nullable EntityPlayerMP player, int type) {
        if (type < 0 || type > 2) {
            return;
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("type", type);
        switch (type) {
            case 0: {
                payload.func_74782_a("data", (NBTBase)NpcQuestDB.INSTANCE.writeToNBT(new NBTTagList()));
                break;
            }
            case 1: {
                payload.func_74782_a("data", (NBTBase)NpcFactionDB.INSTANCE.writeToNBT(new NBTTagList()));
                break;
            }
            case 2: {
                payload.func_74782_a("data", (NBTBase)NpcDialogDB.INSTANCE.writeToNBT(new NBTTagList()));
            }
        }
        if (player != null) {
            ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToPlayers(new QuestingPacket(ID_NAME, payload), new EntityPlayerMP[]{player});
        } else {
            ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToAll(new QuestingPacket(ID_NAME, payload));
        }
    }

    private static void onClient(NBTTagCompound message) {
        if (!message.func_150297_b("type", 99)) {
            BQ_NPCs.logger.error("Recieved invalid sync type: NULL");
            return;
        }
        NBTTagList data = message.func_150295_c("data", 10);
        int type = message.func_74762_e("type");
        switch (type) {
            case 0: {
                NpcQuestDB.INSTANCE.readFromNBT(data);
                break;
            }
            case 1: {
                NpcFactionDB.INSTANCE.readFromNBT(data);
                break;
            }
            case 2: {
                NpcDialogDB.INSTANCE.readFromNBT(data);
                break;
            }
            default: {
                BQ_NPCs.logger.error("Recieved invalid sync type: " + type);
            }
        }
    }
}

