/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.common;

import com.github.abrarsyed.secretroomsmod.blocks.TileEntityCamo;
import com.github.abrarsyed.secretroomsmod.common.BlockLocation;
import com.github.abrarsyed.secretroomsmod.network.PacketChangeOwnership;
import com.github.abrarsyed.secretroomsmod.network.PacketManager;
import com.github.abrarsyed.secretroomsmod.network.PacketSyncOwnership;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OwnershipManager {
    private static OwnershipManager INSTANCE;
    private TIntObjectMap<Map<BlockLocation, UUID>> ownership;
    private static final String FILE_NAME = "SecretRooms-ownership.dat";
    private static Logger LOG;

    protected static void init() {
        INSTANCE = new OwnershipManager();
        OwnershipManager.INSTANCE.ownership = new TIntObjectHashMap();
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static void setOwnership(UUID id, BlockLocation loc) {
        Map map = (Map)OwnershipManager.INSTANCE.ownership.get(loc.dimId);
        if (map == null) {
            map = Maps.newHashMap();
            OwnershipManager.INSTANCE.ownership.put(loc.dimId, (Object)map);
        }
        map.put(loc, id);
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            EntityPlayer player = OwnershipManager.getPlayerFromId(id);
            if (player == null) {
                return;
            }
            PacketManager.sendToPlayer(new PacketChangeOwnership(true, loc), player);
        }
    }

    public static Map<BlockLocation, UUID> getOwnershipMap(int world) {
        return (Map)OwnershipManager.INSTANCE.ownership.get(world);
    }

    public static void clearDimension(int world) {
        OwnershipManager.INSTANCE.ownership.remove(world);
    }

    public static void removeBlock(BlockLocation loc) {
        Map map = (Map)OwnershipManager.INSTANCE.ownership.get(loc.dimId);
        if (map != null) {
            map.remove(loc);
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketManager.sendToDimension(new PacketChangeOwnership(false, loc), loc.dimId);
        }
    }

    public static boolean isOwner(UUID player, BlockLocation loc) {
        return OwnershipManager.equalsUUID(player, OwnershipManager.getOwner(loc));
    }

    public static UUID getOwner(BlockLocation loc) {
        UUID gotten;
        Map map = (Map)OwnershipManager.INSTANCE.ownership.get(loc.dimId);
        UUID uUID = gotten = map == null ? null : (UUID)map.get(loc);
        if (gotten == null) {
            World world = loc.getWorld();
            if (world == null) {
                return null;
            }
            TileEntity entity = loc.getWorld().func_147438_o(loc.x, loc.y, loc.z);
            if (entity instanceof TileEntityCamo) {
                gotten = ((TileEntityCamo)entity).getOwner();
            }
        }
        return gotten;
    }

    private Collection<BlockLocation> getAllForPlayer(UUID player, int dimension) {
        LinkedList<BlockLocation> locs = new LinkedList<BlockLocation>();
        for (Map.Entry e : ((Map)this.ownership.get(dimension)).entrySet()) {
            if (!OwnershipManager.equalsUUID(player, (UUID)e.getValue())) continue;
            locs.add((BlockLocation)e.getKey());
        }
        return locs;
    }

    @SubscribeEvent
    public void onWorldChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        PacketManager.sendToPlayer(new PacketSyncOwnership(e.fromDim), e.player);
        PacketManager.sendToPlayer(new PacketSyncOwnership(e.toDim, this.getAllForPlayer(e.player.func_110124_au(), e.toDim)), e.player);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        File save = this.getSaveFile(e.world);
        int dimid = e.world.field_73011_w.field_76574_g;
        HashMap map = Maps.newHashMap();
        this.ownership.put(dimid, (Object)map);
        if (!save.exists()) {
            LOG.debug("Ownership data for dimension {} not found ({})", new Object[]{dimid, save});
            return;
        }
        LOG.debug("reading ownership data for dimension {} from {}", new Object[]{dimid, save});
        try {
            DataInputStream in = this.getDataIn(save);
            int readDim = in.readInt();
            if (readDim != dimid) {
                in.close();
                throw new IllegalArgumentException("WRONG DIMENSION ID! " + readDim + "instead of " + dimid);
            }
            int keys = in.readInt();
            for (int i = 0; i < keys; ++i) {
                map.put(BlockLocation.readFromData(in, false, dimid), new UUID(in.readLong(), in.readLong()));
            }
            in.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (!map.isEmpty()) {
            PacketManager.sendToAll(new PacketSyncOwnership(e.world.field_73011_w.field_76574_g));
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.saveWorld(e.world);
    }

    public static EntityPlayer getPlayerFromId(UUID id) {
        for (Object playerObj : FMLCommonHandler.instance().getSidedDelegate().getServer().func_71203_ab().field_72404_b) {
            EntityPlayer player = (EntityPlayer)playerObj;
            if (!OwnershipManager.equalsUUID(id, player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.saveWorld(e.world);
        this.ownership.remove(e.world.field_73011_w.field_76574_g);
        PacketManager.sendToAll(new PacketSyncOwnership(e.world.field_73011_w.field_76574_g));
    }

    private void saveWorld(World world) {
        File save = this.getSaveFile(world);
        int dimid = world.field_73011_w.field_76574_g;
        LOG.debug("Saving ownership data for dimension {} to {}", new Object[]{dimid, save});
        Map map = (Map)this.ownership.get(dimid);
        if (map == null) {
            return;
        }
        try {
            save.getParentFile().mkdirs();
            DataOutputStream out = this.getDataOut(save);
            out.writeInt(dimid);
            out.writeInt(map.keySet().size());
            for (Map.Entry e : map.entrySet()) {
                ((BlockLocation)e.getKey()).writeToData(out, false);
                out.writeLong(((UUID)e.getValue()).getMostSignificantBits());
                out.writeLong(((UUID)e.getValue()).getLeastSignificantBits());
            }
            out.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private File getSaveFile(World world) {
        String worldSaveFolder = world.field_73011_w.getSaveFolder();
        worldSaveFolder = worldSaveFolder == null ? "" : "/" + worldSaveFolder;
        return new File(DimensionManager.getCurrentSaveRootDirectory() + worldSaveFolder, FILE_NAME);
    }

    private DataOutputStream getDataOut(File file) throws FileNotFoundException, IOException {
        return new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
    }

    private DataInputStream getDataIn(File file) throws FileNotFoundException, IOException {
        return new DataInputStream(new GZIPInputStream(new FileInputStream(file)));
    }

    private static final boolean equalsUUID(UUID one, UUID two) {
        if (one == null || two == null) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        String user1 = UsernameCache.getLastKnownUsername((UUID)one);
        String user2 = UsernameCache.getLastKnownUsername((UUID)two);
        if (user1 == null || user1 == null) {
            return false;
        }
        return user1.equalsIgnoreCase(user2);
    }

    static {
        LOG = LogManager.getLogger();
    }
}

