/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.blocks;

import com.github.abrarsyed.secretroomsmod.api.BlockHolder;
import com.github.abrarsyed.secretroomsmod.api.ITileEntityCamo;
import com.github.abrarsyed.secretroomsmod.common.FakeWorld;
import com.github.abrarsyed.secretroomsmod.common.SecretRooms;
import com.github.abrarsyed.secretroomsmod.network.PacketCamo;
import com.github.abrarsyed.secretroomsmod.network.PacketManager;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCamo
extends TileEntity
implements ITileEntityCamo {
    private BlockHolder holder = null;
    private boolean[] isCamo = new boolean[6];
    private UUID owner;

    public TileEntityCamo() {
        Arrays.fill(this.isCamo, true);
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.holder = BlockHolder.buildFromNBT(nbt);
        for (int i = 0; i < this.isCamo.length; ++i) {
            this.isCamo[i] = nbt.func_74767_n("isCamo" + i);
        }
        boolean hasOwner = nbt.func_74764_b("ownerMost");
        if (hasOwner) {
            long most = nbt.func_74763_f("ownerMost");
            long least = nbt.func_74763_f("ownerLeast");
            this.owner = new UUID(most, least);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.holder == null) {
            new BlockHolder(Blocks.field_150348_b, 0, null).writeToNBT(nbt);
        } else {
            this.holder.writeToNBT(nbt);
        }
        for (int i = 0; i < this.isCamo.length; ++i) {
            nbt.func_74757_a("isCamo" + i, this.isCamo[i]);
        }
        if (this.owner != null) {
            nbt.func_74772_a("ownerMost", this.owner.getMostSignificantBits());
            nbt.func_74772_a("ownerLeast", this.owner.getLeastSignificantBits());
        }
    }

    public Packet func_145844_m() {
        return PacketManager.toMcPacket(new PacketCamo(this));
    }

    @Override
    public void setBlockHolder(BlockHolder holder) {
        if (holder == null) {
            return;
        }
        FakeWorld fake = SecretRooms.proxy.getFakeWorld(this.field_145850_b);
        if (fake != null) {
            fake.addOverrideBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e, holder);
        }
        this.holder = holder;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145843_s() {
        FakeWorld fake;
        if (this.field_145850_b != null && (fake = SecretRooms.proxy.getFakeWorld(this.field_145850_b)) != null) {
            fake.removeOverrideBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        super.func_145843_s();
    }

    public void func_145829_t() {
        FakeWorld fake = SecretRooms.proxy.getFakeWorld(this.field_145850_b);
        if (fake != null) {
            fake.addOverrideBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.holder);
        }
        super.func_145829_t();
    }

    @Override
    public BlockHolder getBlockHolder() {
        return this.holder;
    }

    public Block getCopyBlock() {
        return this.holder == null ? null : this.holder.block;
    }

    public boolean isCamoSide(int side) {
        if (side >= 0 && side <= 5) {
            return this.isCamo[side];
        }
        return false;
    }

    @Override
    public boolean[] getIsCamo() {
        return this.isCamo;
    }

    @Override
    public void setIsCamo(boolean[] camo) {
        this.isCamo = camo;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(UUID id) {
        this.owner = id;
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }
}

