/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.api;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHolder {
    private final NBTTagCompound nbt;
    public Block block;
    public final int metadata;

    public BlockHolder(IBlockAccess world, int x, int y, int z) {
        this.block = world.func_147439_a(x, y, z);
        this.metadata = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            this.nbt = new NBTTagCompound();
            te.func_145841_b(this.nbt);
            this.nbt.func_74768_a("x", 0);
            this.nbt.func_74768_a("y", 0);
            this.nbt.func_74768_a("z", 0);
        } else {
            this.nbt = null;
        }
    }

    public BlockHolder(Block block, int meta, NBTTagCompound nbt) {
        this.nbt = nbt;
        this.block = block;
        this.metadata = meta;
    }

    public TileEntity getTileEntity(World world, int x, int y, int z) {
        if (this.block == null || this.nbt == null) {
            return null;
        }
        TileEntity te = TileEntity.func_145827_c((NBTTagCompound)this.nbt);
        te.func_145834_a(world);
        te.field_145851_c = x;
        te.field_145848_d = y;
        te.field_145849_e = z;
        return te;
    }

    public void writeToNBT(NBTTagCompound compound) {
        GameRegistry.UniqueIdentifier ident = GameRegistry.findUniqueIdentifierFor((Block)this.block);
        compound.func_74778_a("copyMod", ident.modId);
        compound.func_74778_a("copyBlock", ident.name);
        compound.func_74768_a("copyMeta", this.metadata);
        compound.func_74757_a("hasCopyTE", this.nbt != null);
        if (this.nbt != null) {
            compound.func_74782_a("copyTE", (NBTBase)this.nbt);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        result = 31 * result + this.metadata;
        result = 31 * result + (this.nbt == null ? 0 : this.nbt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockHolder other = (BlockHolder)obj;
        if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
            return false;
        }
        if (this.metadata != other.metadata) {
            return false;
        }
        return !(this.nbt == null ? other.nbt != null : !this.nbt.equals((Object)other.nbt));
    }

    public static BlockHolder buildFromNBT(NBTTagCompound nbt) {
        Block block = null;
        block = nbt.func_74764_b("copyID") ? Block.func_149729_e((int)nbt.func_74762_e("copyID")) : GameRegistry.findBlock((String)nbt.func_74779_i("copyMod"), (String)nbt.func_74779_i("copyBlock"));
        int meta = nbt.func_74762_e("copyMeta");
        NBTTagCompound nbtNew = null;
        boolean hasNBT = nbt.func_74767_n("hasCopyTE");
        if (hasNBT) {
            nbtNew = nbt.func_74775_l("copyTE");
        }
        return new BlockHolder(block, meta, nbtNew);
    }

    public Block getBlock() {
        return this.block;
    }
}

