/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.NBTStatsInfo;

public class EntryNBTByteArray
extends EntryAbstract {
    private final String name;
    private final double[][] values;

    public EntryNBTByteArray(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.name = FileHelper.readText(node, path, "name", "");
        JsonArray nodes = node.getAsJsonArray("value");
        if (nodes == null) {
            throw new MobPropertyException("Missing or invalid value!", path);
        }
        int length = nodes.size();
        this.values = new double[length][];
        for (int i = 0; i < length; ++i) {
            this.values[i] = FileHelper.readCounts(node, path, "value", i, 0.0, 0.0);
        }
    }

    @Override
    public String[] getRequiredFields() {
        return new String[0];
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"name", "value"};
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        byte[] value = new byte[this.values.length];
        int i = value.length;
        while (i-- > 0) {
            value[i] = (byte)FileHelper.getCount(this.values[i], nbtStats.random);
        }
        nbtStats.addTag(this.name, (NBTBase)new NBTTagByteArray(value));
    }
}

